/* $Id: ConditionDialog.java,v 1.3 2005/08/26 04:50:22 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;

/**
 * \p̃_CAO񋟂B
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ConditionDialog extends JDialog
{
	/** \p̃r[ */
	private ConditionEditorView view;

	/**
	 * \p_CAO\B
	 * 
	 * @param c	eR|[lg
	 * @param exp	
	 * @return	XVꂽ
	 */
	public static Expression showDialog(Component c, Expression exp)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		ConditionDialog dialog = new ConditionDialog(frame, exp);
		dialog.setVisible(true);
		Expression result = dialog.view.getExpression();
		dialog.dispose();
		return result;
	}

	/**
	 * \p_CAO𐶐B
	 * 
	 * @param frame	et[
	 * @param exp	
	 */
	private ConditionDialog(Frame frame, Expression exp)
	{
		super(frame, true);
		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		setTitle(rm.getResource("ConditionDialog.title"));
		
		view = new ConditionEditorView();
		view.setExpression(exp);

		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView(view);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener listener = new CloseAction();
		JButton setButton = new JButton(rm.getResource("JButton.label.set"));
		setButton.setActionCommand("OK_OPTION");
		setButton.addActionListener(listener);
		getRootPane().setDefaultButton(setButton);
		buttonPane.add(setButton);

		JButton cancelButton = new JButton(rm.getResource("JButton.label.cancel"));
		cancelButton.addActionListener(listener);
		buttonPane.add(cancelButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();

		setLocationRelativeTo(frame);
	}

	/**
	 * {^ꂽƂ̏
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * mFsAȂΕB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if ("OK_OPTION".equals(e.getActionCommand())) {
				if (view.check() == false) {
					//G[̂ŁAR~bgreturn
					//_CAO͕Ȃ
					return;
				}
				view.commit();
			}
			setVisible(false);
		}
	}
}
