/* $Id: ConditionEditorView.java,v 1.4 2005/08/26 04:50:26 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;

import jp.co.argo21.commons.swing.BooleanDocument;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.expression.ExceptionExpression;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.tool.wfd.expression.LogicalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.OtherwiseExpression;
import jp.co.argo21.nautica.tool.wfd.expression.RelationalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.UnaryExpression;

/**
 * GfB^r[łB
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class ConditionEditorView extends JTabbedPane
{
	/** pZq */
	static public String[] STR_OPS;
	/** lpZq */
	static public String[] NUM_OPS;
	/** ^pZq */
	static public String[] BOOL_OPS;
	/** _pZq */
	static public String[] LOG_OPS;

	/** ϐe[uJ */
	static private String varTableColumn;
	/** e[uJ */
	static private String condTableColumn;

	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** {^ */
	private JRadioButton condButton;
	/** OTHERWISE{^ */
	private JRadioButton otherButton;
	/** EXCEPTION{^ */
	private JRadioButton exButton;
	/** vZXϐꗗ */
	private JTable varTable;
	/** {Zq */
	private JComboBox basOpeBox;
	/** {EӃtB[h */
	private JTextField basRField;
	/** P_tB[h */
	private JTextField unaryField;
	/** 񍀘_ӃtB[h */
	private JTextField logLField;
	/** {Zq */
	private JComboBox logOpeBox;
	/** 񍀘_EӃtB[h */
	private JTextField logRField;
	/** {{^ */
	private JRadioButton basButton;
	/** P_{^ */
	private JRadioButton unaryButton;
	/** 񍀘_{^ */
	private JRadioButton logButton;
	/** ꗗ */
	private JTable condTable;
	/** I{^ */
	private JButton selUniButton;
	/** I{^ */
	private JButton selLogLButton;
	/** I{^ */
	private JButton selLogRButton;
	/** ǉ{^ */
	private JButton addButton;
	/** \tB[h */
	private JTextArea previewArea;

	/**  */
	private Expression expression;
	
	/** ϐꗗ */
	private List vars;
	
	/** ꗗ */
	private List expressions = new ArrayList();

	/** _̍ӏ */
	private Expression logLExp;
	/** _̉Eӏ */
	private Expression logRExp;
	/** ے̏ */
	private Expression unaryExp;
	
	
	/** ͐ */
	private Document strDocument = new ByteLimitedDocument(128);
	
	/** l͐ */
	private Document numDocument = new NumericDocument(9, true);
	
	/** ^͐ */
	private Document boolDocument = new BooleanDocument();

	/**
	 * 萔̏
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		STR_OPS = new String[2];
		STR_OPS[0] = rm.getResource("ConditionEditorView.basicope.0");
		STR_OPS[1] = rm.getResource("ConditionEditorView.basicope.1");

		NUM_OPS = new String[6];
		NUM_OPS[0] = rm.getResource("ConditionEditorView.basicope.0");
		NUM_OPS[1] = rm.getResource("ConditionEditorView.basicope.1");
		NUM_OPS[2] = rm.getResource("ConditionEditorView.basicope.2");
		NUM_OPS[3] = rm.getResource("ConditionEditorView.basicope.3");
		NUM_OPS[4] = rm.getResource("ConditionEditorView.basicope.4");
		NUM_OPS[5] = rm.getResource("ConditionEditorView.basicope.5");

		BOOL_OPS = new String[2];
		BOOL_OPS[0] = rm.getResource("ConditionEditorView.basicope.0");
		BOOL_OPS[1] = rm.getResource("ConditionEditorView.basicope.1");

		LOG_OPS = new String[2];
		LOG_OPS[0] = rm.getResource("ConditionEditorView.logope.0");
		LOG_OPS[1] = rm.getResource("ConditionEditorView.logope.1");

		varTableColumn = rm.getResource("ConditionEditorView.column.0");
		condTableColumn = rm.getResource("ConditionEditorView.column.1");
	}
	
	/**
	 * GfB^r[𐶐B
	 */
	public ConditionEditorView()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel = createConditionEditorPanel(rm);
		addTab(rm.getResource("ConditionEditorView.tab.0"), panel);

		validate();
	}
	
	/**
	 * pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createConditionEditorPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(580, 370);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ConditionEditorView.label.0"));

		condButton = new JRadioButton(rm.getResource("ConditionEditorView.kind.0"));
		condButton.addActionListener(new SelectConditionAction());
		otherButton = new JRadioButton(rm.getResource("ConditionEditorView.kind.1"));
		otherButton.addActionListener(new SelectOtherwiseAction());
		exButton = new JRadioButton(rm.getResource("ConditionEditorView.kind.2"));
		exButton.addActionListener(new SelectExceptionAction());

		JPanel kindPane = new JPanel();
		kindPane.setLayout(new GridLayout(1, 3, 5, 5));
		kindPane.setBorder(border);
		kindPane.add(condButton);
		kindPane.add(otherButton);
		kindPane.add(exButton);

		ButtonGroup kindGroup = new ButtonGroup();
		kindGroup.add(condButton);
		kindGroup.add(otherButton);
		kindGroup.add(exButton);

		basButton = new JRadioButton(rm.getResource("ConditionEditorView.cond.0"));
		basButton.addActionListener(new SelectBasicExpressionAction());
		unaryButton = new JRadioButton(rm.getResource("ConditionEditorView.cond.1"));
		unaryButton.addActionListener(new SelectUnaryExpressionAction());
		logButton = new JRadioButton(rm.getResource("ConditionEditorView.cond.2"));
		logButton.addActionListener(new SelectLogicalExpressionAction());

		ButtonGroup expGroup = new ButtonGroup();
		expGroup.add(basButton);
		expGroup.add(unaryButton);
		expGroup.add(logButton);

		varTable = new JTable(new VarTableModel());
		varTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		varTable.setRowHeight(35);
		varTable.getColumnModel().getColumn(0).setCellRenderer(new VarRenderer());
		ListSelectionModel vlsm = varTable.getSelectionModel();
		vlsm.addListSelectionListener(new VarSelectAction());
		JScrollPane sp0 = new JScrollPane();
		sp0.setViewportView(varTable);
		basOpeBox = new JComboBox(STR_OPS);
		basRField = new JTextField();
		basRField.setDocument(strDocument);

		unaryField = new JTextField();
		unaryField.setEditable(false);

		logLField = new JTextField();
		logLField.setEditable(false);
		logOpeBox = new JComboBox(LOG_OPS);
		logRField = new JTextField();
		logRField.setEditable(false);
		selUniButton = new JButton(rm.getResource("JButton.label.select"));
		selUniButton.addActionListener(new SelectExpressionAction(unaryField));
		selLogLButton = new JButton(rm.getResource("JButton.label.select"));
		selLogLButton.addActionListener(new SelectExpressionAction(logLField));
		selLogRButton = new JButton(rm.getResource("JButton.label.select"));
		selLogRButton.addActionListener(new SelectExpressionAction(logRField));

		condTable = new JTable(new ConditionTableModel());
		condTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		condTable.setRowHeight(35);
		condTable.getColumnModel().getColumn(0).setCellRenderer(new ConditionRenderer());
		ListSelectionModel clsm = condTable.getSelectionModel();
		clsm.addListSelectionListener(new ConditionSelectAction());
		JScrollPane sp1 = new JScrollPane();
		sp1.setViewportView(condTable);
		addButton = new JButton(rm.getResource("JButton.label.add"));
		addButton.addActionListener(new AddExpressionAction());
		previewArea = new JTextArea();
		previewArea.setLineWrap(true);
		previewArea.setEditable(false);
		JScrollPane sp2 = new JScrollPane();
		sp2.setViewportView(previewArea);

		condButton.setSelected(true);
		basButton.setSelected(true);
		setConditionEditable(true);
		setBasicExpressionEditable();

		panel.add(locate(l0,             10,  10, 100,  25));
		panel.add(locate(kindPane,       10,  40, 560,  35));
		panel.add(locate(basButton,      10,  80, 105,  25));
		panel.add(locate(unaryButton,      10, 190, 105,  25));
		panel.add(locate(logButton,      10, 220, 105,  25));
		panel.add(locate(sp0,           120,  80, 165, 105));
		panel.add(locate(basOpeBox,     290, 130, 100,  25));
		panel.add(locate(basRField,     290, 160, 100,  25));
		panel.add(locate(unaryField,      120, 190, 100,  25));
		panel.add(locate(selUniButton,  225, 190,  60,  25));
		panel.add(locate(logOpeBox,     290, 220, 100,  25));
		panel.add(locate(logLField,     120, 220, 100,  25));
		panel.add(locate(selLogLButton, 225, 220,  60,  25));
		panel.add(locate(logRField,     120, 250, 100,  25));
		panel.add(locate(selLogRButton, 225, 250,  60,  25));
		panel.add(locate(sp1,           400,  80, 170, 225));
		panel.add(locate(addButton,     330, 280,  60,  25));
		panel.add(locate(sp2,            10, 310, 560,  50));

		validate();
		
		return panel;
	}

	/**
	 * ҏW̉ۂݒ肷B
	 * 
	 * @param b	ҏW̉
	 */	
	private void setConditionEditable(boolean b)
	{
		basButton.setEnabled(b);
		unaryButton.setEnabled(b);
		logButton.setEnabled(b);
		varTable.setEnabled(b);
		basOpeBox.setEnabled(b);
		basRField.setEditable(b);
		selUniButton.setEnabled(b);
		logOpeBox.setEnabled(b);
		selLogLButton.setEnabled(b);
		selLogRButton.setEnabled(b);
		addButton.setEnabled(b);
	}

	/**
	 * {̕ҏW\ɂB
	 */	
	private void setBasicExpressionEditable()
	{
		varTable.setEnabled(true);
		basOpeBox.setEnabled(true);
		basRField.setEditable(true);
		selUniButton.setEnabled(false);
		logOpeBox.setEnabled(false);
		selLogLButton.setEnabled(false);
		selLogRButton.setEnabled(false);
		addButton.setEnabled(true);
		varTable.clearSelection();
		basOpeBox.setSelectedIndex(0);
		basRField.setText("");
		basRField.setToolTipText("");
	}

	/**
	 * ے̕ҏW\ɂB
	 */
	private void setUnaryExpressionEditable()
	{
		varTable.setEnabled(false);
		basOpeBox.setEnabled(false);
		basRField.setEditable(false);
		selUniButton.setEnabled(true);
		logOpeBox.setEnabled(false);
		selLogLButton.setEnabled(false);
		selLogRButton.setEnabled(false);
		addButton.setEnabled(true);
		unaryField.setText("");
		unaryField.setToolTipText("");
		unaryExp = null;
	}

	/**
	 * _̕ҏW\ɂB
	 */
	private void setLogicalExpressionEditable()
	{
		varTable.setEnabled(false);
		basOpeBox.setEnabled(false);
		basRField.setEditable(false);
		selUniButton.setEnabled(false);
		logOpeBox.setEnabled(true);
		selLogLButton.setEnabled(true);
		selLogRButton.setEnabled(true);
		addButton.setEnabled(true);
		logLField.setText("");
		logLField.setToolTipText("");
		logOpeBox.setSelectedIndex(0);
		logRField.setText("");
		logRField.setToolTipText("");
		logLExp = null;
		logRExp = null;
	}

	/**
	 * Iꂽϐ̌^ɉĉʂ̏ԂXVB
	 * 
	 * @param var	ϐ
	 */	
	private void variableSelected(VariableElement var)
	{
		int type = var.getType();
		if (type == VariableElement.INTEGER) {
			basOpeBox.setModel(new DefaultComboBoxModel(NUM_OPS));
			basRField.setHorizontalAlignment(SwingConstants.RIGHT);
		} else if (type == VariableElement.BOOLEAN) {
			basOpeBox.setModel(new DefaultComboBoxModel(BOOL_OPS));
			basRField.setHorizontalAlignment(SwingConstants.LEFT);
		} else {
			basOpeBox.setModel(new DefaultComboBoxModel(STR_OPS));
			basRField.setHorizontalAlignment(SwingConstants.LEFT);
		}
		basOpeBox.updateUI();
	}

	/**
	 * VȊ{쐬B
	 */
	private void makeNewBasicExpression()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		int selected = varTable.getSelectedRow();
		if (selected < 0) {
			DialogUtilities.showError(rm.getResource("message.error.0041"));
			return;
		}
		int ope = RelationalExpression.EQUAL;
		if (basOpeBox.getSelectedIndex() == 1) ope = RelationalExpression.NOT_EQUAL;
		else if (basOpeBox.getSelectedIndex() == 2) ope = RelationalExpression.LESS_THAN;
		else if (basOpeBox.getSelectedIndex() == 3) ope = RelationalExpression.LESS_EQUAL;
		else if (basOpeBox.getSelectedIndex() == 4) ope = RelationalExpression.GREATER_THAN;
		else if (basOpeBox.getSelectedIndex() == 5) ope = RelationalExpression.GREATER_EQUAL;
		
		VariableElement v = (VariableElement)vars.get(selected);
		
		Expression exp = new RelationalExpression(v.getID(), ope, basRField.getText());
		expressions.add(exp);

		setBasicExpressionEditable();
		condTable.updateUI();
	}

	/**
	 * VȔے쐬B
	 */
	private void makeNewUnaryExpression()
	{
		if (unaryExp == null) {
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			DialogUtilities.showError(rm.getResource("message.error.0042"));
			return;
		}
		Expression exp = new UnaryExpression(unaryExp);
		expressions.add(exp);

		setUnaryExpressionEditable();
		condTable.updateUI();
	}

	/**
	 * VȘ_쐬B
	 */
	private void makeNewLogicalExpression()
	{
		if (logLExp == null) {
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			DialogUtilities.showError(rm.getResource("message.error.0043"));
			return;
		}
		if (logRExp == null) {
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			DialogUtilities.showError(rm.getResource("message.error.0044"));
			return;
		}
		int ope = LogicalExpression.OR;
		if (logOpeBox.getSelectedIndex() == 0) ope = LogicalExpression.AND;
		
		Expression exp = new LogicalExpression(logLExp, ope, logRExp);
		expressions.add(exp);

		setLogicalExpressionEditable();
		condTable.updateUI();
	}

	/**
	 * ԂB
	 * 
	 * @return	
	 */
	public Expression getExpression()
	{
		return expression;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param exp	
	 */	
	public void setExpression(Expression exp)
	{
		expression = exp;
		int ix = -1;
		if (exp == null) {
			setConditionEditable(true);
			condButton.setSelected(true);
		} else if (exp instanceof OtherwiseExpression) {
			setConditionEditable(false);
			otherButton.setSelected(true);
		} else if (exp instanceof ExceptionExpression) {
			setConditionEditable(false);
			exButton.setSelected(true);
		} else {
			setConditionEditable(true);
			condButton.setSelected(true);
			exp.getAllExpressions(expressions);
			ix = expressions.indexOf(exp);			
		}
		repaint();
		if (ix > -1) condTable.getSelectionModel().setLeadSelectionIndex(ix);
	}

	/**
	 * IÕ`FbNsB
	 * 
	 * @return	ȂtrueB
	 */	
	public boolean check()
	{
		if (condButton.isSelected()) {
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = condTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0005"));
				return false;
			}
		}
		return true;
	}

	/**
	 * ҏWʂR~bgB
	 */	
	public void commit()
	{
		if (condButton.isSelected()) {
			int selected = condTable.getSelectedRow();
			expression = (Expression)expressions.get(selected);
		} else if (otherButton.isSelected()) {
			expression = new OtherwiseExpression();
		} else if (exButton.isSelected()) {
			expression = new ExceptionExpression();
		}
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	protected Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}

	/**
	 * ҏWIꍇ̏
	 */	
	class SelectConditionAction extends AbstractAction
	{
		/**
		 * ҏW\ɂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setConditionEditable(true);
		}
	}
	
	/**
	 * OTHERWISEIꂽꍇ̏
	 */	
	class SelectOtherwiseAction extends AbstractAction
	{
		/**
		 * ҏWsɂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setConditionEditable(false);
		}
	}
	
	/**
	 * EXCEPTIONIꂽꍇ̏
	 */	
	class SelectExceptionAction extends AbstractAction
	{
		/**
		 * ҏWsɂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setConditionEditable(false);
		}
	}
	
	/**
	 * {Iꂽꍇ̏
	 */	
	class SelectBasicExpressionAction extends AbstractAction
	{
		/**
		 * {ҏW\ɂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setBasicExpressionEditable();
		}
	}
	
	/**
	 * _Iꂽꍇ̏
	 */	
	class SelectLogicalExpressionAction extends AbstractAction
	{
		/**
		 * _ҏW\ɂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setLogicalExpressionEditable();
		}
	}
	
	/**
	 * ےIꂽꍇ̏
	 */	
	class SelectUnaryExpressionAction extends AbstractAction
	{
		/**
		 * ےҏW\ɂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setUnaryExpressionEditable();
		}
	}
	
	/**
	 * ǉ{^ꂽꍇ̏
	 */	
	class AddExpressionAction extends AbstractAction
	{
		/**
		 * ͍ڂ炠炽ȏ쐬AꗗɒǉB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (basButton.isSelected()) {
				makeNewBasicExpression();
			} else if (unaryButton.isSelected()) {
				makeNewUnaryExpression();
			} else if (logButton.isSelected()) {
				makeNewLogicalExpression();
			}
		}
	}
	
	/**
	 * I{^ꂽꍇ̏
	 */
	class SelectExpressionAction extends AbstractAction
	{
		/** ΉeLXgtB[h */
		private JTextField field;
		
		/**
		 * ANV𐶐B
		 * 
		 * @param f	eLXgtB[h
		 */
		SelectExpressionAction(JTextField f)
		{
			this.field = f;
		}
		
		/**
		 * IꂽeLXgtB[hɊtB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = condTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0005"));
				return;
			}
			Expression exp = (Expression)expressions.get(selected);
			if (field == unaryField) {
				unaryExp = exp;
			} else if (field == logLField) {
				logLExp = exp;
			} else if (field == logRField) {
				logRExp = exp;
			}
			field.setText(exp.getExpressionString(vars));
			field.setToolTipText(exp.getExpressionString(vars));
		}
	}

	/**
	 * ϐe[uIꂽꍇ̏
	 */	
	class VarSelectAction implements ListSelectionListener
	{
		/**
		 * e[u̕ύXʂɔfB
		 * 
		 * @param e	Cxg
		 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
		 */
		public void valueChanged(ListSelectionEvent e)
		{
			if (e.getValueIsAdjusting()) return;

			ListSelectionModel lsm = (ListSelectionModel)e.getSource();
			if (lsm.isSelectionEmpty() == false) {
				int selected = lsm.getMinSelectionIndex();
				VariableElement v = (VariableElement)vars.get(selected);
				variableSelected(v);
				int type = v.getType();
				String s = v.getInitialValue();
				if (s == null) s = "";
				basRField.setText(s);
				if (type == VariableElement.INTEGER) {
					basRField.setDocument(numDocument);
					basRField.setHorizontalAlignment(SwingUtilities.RIGHT);
				} else if (type == VariableElement.BOOLEAN) {
					basRField.setDocument(boolDocument);
					basRField.setHorizontalAlignment(SwingUtilities.LEFT);
				} else {
					basRField.setDocument(strDocument);
					basRField.setHorizontalAlignment(SwingUtilities.LEFT);
				}
			}
		}
	}

	/**
	 * e[uIꂽꍇ̏
	 */	
	class ConditionSelectAction implements ListSelectionListener
	{
		/**
		 * e[u̕ύXʂɔfB
		 * 
		 * @param e
		 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
		 */
		public void valueChanged(ListSelectionEvent e)
		{
			if (e.getValueIsAdjusting()) return;

			ListSelectionModel lsm = (ListSelectionModel)e.getSource();
			if (lsm.isSelectionEmpty() == false) {
				int selected = lsm.getMinSelectionIndex();
				previewArea.setText(((Expression)expressions.get(selected)).getExpressionString(vars));
			}
		}
	}

	/**
	 * ϐe[u䃂f
	 */
	class VarTableModel extends AbstractTableModel
	{
		/**
		 * ϐe[u䃂f𐶐B
		 */
		VarTableModel()
		{
			vars = WorkflowDesignerManager.getMainFrame().getPackage().getVariables();
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return 1;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			return vars.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return varTableColumn;
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			return vars.get(row);
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return Element.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}

	/**
	 * ϐe[ũZ_[B
	 */	
	class VarRenderer extends DefaultTableCellRenderer
	{
		/** ACR */
		private Icon icon;
		
		/**
		 * ϐe[upZ_[𐶐B
		 */
		VarRenderer()
		{
			String name = WorkflowDesignerConstants.EL_VARIABLE + "-cur";
			icon = IconManager.getIcon(name);
		}
		
		/**
		 * Z̃_OsB
		 * 
		 * @param table	e[u
		 * @param o	Ze
		 * @param isSelected	I
		 * @param hasFocus	tH[JX
		 * @param row	s
		 * @param column	
		 * @return	_OꂽZ
		 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
		 */
		public Component getTableCellRendererComponent(
		JTable table,
		Object o,
		boolean isSelected,
		boolean hasFocus,
		int row,
		int column)
		{
			super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			Element elem = (Element)o;
			setText(elem.getName());

			if (icon != null) setIcon(icon);
			setToolTipText(elem.getTooltipText(rm));
			return this;
		}
	}

	/**
	 * e[u䃂f
	 */
	class ConditionTableModel extends AbstractTableModel
	{
		/**
		 * e[u䃂f𐶐B
		 */
		ConditionTableModel()
		{
			vars = WorkflowDesignerManager.getMainFrame().getPackage().getVariables();
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return 1;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			return expressions.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return condTableColumn;
		}

		/**
		 * Z̓eԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			return expressions.get(row);
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return Expression.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}

	/**
	 * e[ũZ_[B
	 */	
	class ConditionRenderer extends DefaultTableCellRenderer
	{
		/** ACR */
		private Icon icon;
		
		/**
		 * e[upZ_[𐶐B
		 */
		ConditionRenderer()
		{
			String name = "condition-cur";
			icon = IconManager.getIcon(name);
		}
		
		/**
		 * Z̃_OsB
		 * 
		 * @param table	e[u
		 * @param o	Ze
		 * @param isSelected	I
		 * @param hasFocus	tH[JX
		 * @param row	s
		 * @param column	
		 * @return	_OꂽZ
		 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
		 */
		public Component getTableCellRendererComponent(
		JTable table,
		Object o,
		boolean isSelected,
		boolean hasFocus,
		int row,
		int column)
		{
			super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			Expression exp = (Expression)o;
			String s = exp.getExpressionString(vars);
			setText(s);

			if (icon != null) setIcon(icon);
			setToolTipText(s);
			return this;
		}
	}
}
