/* $Id: DesktopPane.java,v 1.6 2005/08/26 04:50:07 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Point;

import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;

/**
 * WorkflowDesigner̃fXNgbvB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class DesktopPane extends JDesktopPane
{
	/**
	 * WorkflowDesigner̃fXNgbv𐶐B
	 */
	public DesktopPane()
	{
		setBackground(Color.gray);
	}

	/**
	 * ݑIĂt[ԂB
	 *
	 * @return ݑIĂt[
	 */
	public ProcessDesignFrame getCurrentProcessDesignFrame()
	{
		JInternalFrame frame = getSelectedFrame();

		if (frame instanceof ProcessDesignFrame) {
			return (ProcessDesignFrame)frame;
		} else {
			return null;
		}
	}

	/**
	 * Ɏw肳ꂽvfҏWĂt[ԂB
	 * 
	 * @param e vf
	 * @return ҏWt[
	 */
	public ProcessDesignFrame getEditingProcessDesignFrame(Element e)
	{
		if ((e instanceof ProcessElement) == false) return null;
		
		JInternalFrame[] frames = getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER.intValue());
		ProcessDesignFrame frame = null;
		for (int i = 0; i < frames.length; i++) {
			if (frames[i] instanceof ProcessDesignFrame) {
				if (((ProcessDesignFrame)frames[i]).isEditingProcess((ProcessElement)e)) {
					frame = (ProcessDesignFrame)frames[i];
					break;
				}
			}
		}
		return frame;
	}

	/**
	 * Ɏw肳ꂽvfҏWVKt[ԂB
	 * 
	 * @param e vf
	 * @return ҏWt[
	 */
	public ProcessDesignFrame createProcessDesignFrame(Element e)
	{
		if ((e instanceof ProcessElement) == false) return null;
		
		ProcessDesignFrame frame = new ProcessDesignFrame((ProcessElement)e);
		Point p = getNextLocation();
		frame.setLocation(p);
		add(frame);
		frame.setVisible(true);
		frame.initialize();
		try { frame.setSelected(true); } catch (Exception ex) {}
		frame.toFront();
		return frame;
	}

	/**
	 * JĂ邷ׂẴt[XVB
	 */
	public void updateAllFrame()
	{
		JInternalFrame[] frames = getAllFrames();
		for (int i = frames.length - 1; i >= 0; i--) {
			if (frames[i] instanceof ProcessDesignFrame) {
				ProcessDesignFrame frame = (ProcessDesignFrame)frames[i];
				if (frame.isVisible()) {
					frame.getView().getProcessFlowView().inspectSelectedActivity(false);
					frame.getView().updateUI();
				}
			}
		}
	}

	/**
	 * JĂ邷ׂẴt[B
	 */
	public void closeAllFrame()
	{
		JInternalFrame[] frames = getAllFrames();
		for (int i = frames.length - 1; i >= 0; i--) {
			frames[i].setVisible(false);
			frames[i].dispose();
		}
	}

	/**
	 * fXNgbv̎̕\ʒuԂB
	 *
	 * @return ̕\ʒu
	 */
	public Point getNextLocation()
	{
		JInternalFrame[] frames = getAllFramesInLayer(JLayeredPane.DEFAULT_LAYER.intValue());
		if (frames == null) return new Point(0, 0);

		int count = frames.length;
		return new Point(25 * (count % 6), 25 * (count % 6));
	}
}
