/* $Id: ElementList.java,v 1.5 2005/08/26 04:50:15 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.dnd.*;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;


/**
 * vfXg񋟂B
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class ElementList extends JScrollPane implements ChangeElementListener
{
	/** Pʕ */
	static private final int GRID_W = 80;
	/** Pʍ */
	static private final int GRID_H = 70;
	/** ŏr[TCY */
	static private final Dimension MINIMUM_VIEW_SIZE = new Dimension(GRID_W, GRID_H);
	/** r[̃tHg */
	static private final Font VIEW_FONT = new Font("MonoSpaced", Font.PLAIN, 10);
	/** hbÕ}EXJ[\zbg|Cgʒu */
	static private final Point CURSOR_POINT = new Point(16, 16);

	/** |bvAbvj[ */
	private JPopupMenu popup;
	/** VK쐬j[ */
	private JMenuItem popNew;
	/** ҏWj[ */
	private JMenuItem popInspect;
	/** 폜j[ */
	private JMenuItem popDelete;
	/** ACR\pr[ */
	private IconView view;

	/** vf̌^ */
	private String elementType;
	/** vfꗗ */
	private List elements;

	/** IĂCfNX */
	private int selectedIndex;

	/**
	 * vf𐶐B
	 * 
	 * @param elems	vfꗗ
	 * @param type	vf̌^
	 */
	public ElementList(List elems, String type)
	{
		elementType = type;
		elements = elems;
		this.selectedIndex = -1;

		InspectorDialog.addChangeElementListener(elementType, this);

		buildPopupMenu();

		view = new IconView();
		Dimension size = new Dimension(MINIMUM_VIEW_SIZE);
		view.setPreferredSize(size);
		view.setSize(size);
		
		setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
		setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
		setViewportView(view);
	}

	/**
	 * |bvAbvj[̐
	 */
	private void buildPopupMenu()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		popup = new JPopupMenu();

		popNew = new JMenuItem(rm.getResource("ElementList.menu.new"));
		popInspect = new JMenuItem(rm.getResource("ElementList.menu.inspect"));
		popDelete = new JMenuItem(rm.getResource("ElementList.menu.delete"));

		popNew.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					executeNewElement();
				}
			}
		);

		popInspect.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					executeInspectElement();
				}
			}
		);

		popDelete.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					executeDeleteElement();
				}
			}
		);

		popup.add(popNew);
		popup.add(popInspect);
		popup.add(popDelete);
	}

	/**
	 * ACR\GÃTCYČvZB
	 */
	public void recalc()
	{
		Dimension size = getSize();
		int count = 1;
		if (elements != null) count += elements.size();

		size.width = count * GRID_W;
		size.height = GRID_H;
		view.setPreferredSize(size);
		view.setSize(size);
		view.repaint();
	}

	/**
	 * vf̐VK쐬sB
	 */
	private void executeNewElement()
	{
		//VKGg쐬
		ElementFactory factory = ElementFactory.getInstance();
		Element newElem = factory.createElement(elementType);
		if (newElem == null) return;
		
		elements.add(newElem);
		selectedIndex = elements.size() - 1;
		recalc();
	}

	/**
	 * vf̕ҏWsB
	 */
	private void executeInspectElement()
	{
		Element elem = getSelectedElement();
		if (elem == null) return;
		
		if (elementType == WorkflowDesignerConstants.EL_PROCESS) {
			//t[\
			DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
			ProcessDesignFrame frame = desktop.getEditingProcessDesignFrame(elem);
			if (frame == null) {
				frame = desktop.createProcessDesignFrame(elem);
			}
			WorkflowDesignerManager.getMainFrame().getToolbox().setSelectedIndex(0);
		} else {
			//CXyN^\
			InspectorDialog.showDialog(this, elem);
		}
	}

	/**
	 * vf̍폜sB
	 */
	private void executeDeleteElement()
	{
		Element elem = getSelectedElement();
		if (elem == null) return;

		PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
		if (pkg.isUsed(elem)) {
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			DialogUtilities.showWarning(rm.getResource("message.warn.0104"));
			return;
		}
		if (elementType == WorkflowDesignerConstants.EL_PROCESS) {
			if (((ProcessElement)elem).getAccessLevel() == ProcessElement.PUBLIC) {
				//[gvZX̂Ƃ͍폜G[ɂĔB
				ResourceManager rm = WorkflowDesignerManager.getResourceManager();
				DialogUtilities.showWarning(rm.getResource("message.warn.0001"));
				return;
			} else {
				DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
				//ɂ̃vZXJĂ邩mFB
				ProcessDesignFrame frame = desktop.getEditingProcessDesignFrame(elem);
				if (frame != null) {
					frame.setVisible(false);
					desktop.remove(frame);
					frame.dispose();
				}
			}
		}
		elements.remove(elem);
		
		//desktop̍XV
		DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
		desktop.updateAllFrame();
		recalc();
	}

	/**
	 * vfꗗݒ肷B
	 * 
	 * @param list	vfꗗ
	 */
	public void setElements(List list)
	{
		elements = list;
		selectedIndex = -1;
		recalc();
	}

	/**
	 * w肳ꂽʒu̗vfԂB
	 * 
	 * @param p	}EXW
	 * @return	vf
	 */
	private Element getElement(Point p)
	{
		if (elements == null) return  null;
		if (p.x < 0) return  null;
		else if (p.y < 0 || p.y >= GRID_H) return  null;

		int ix = p.x / GRID_W;
		int count = elements.size();
		if (ix >= count) return null;
		return (Element)elements.get(ix);
	}

	/**
	 * IꂽvfԂB
	 * 
	 * @return	vf
	 */
	private Element getSelectedElement()
	{
		if (elements == null) return  null;
		if (selectedIndex < 0) return  null;
		
		int count = elements.size();
		if (selectedIndex >= count) return null;
		return (Element)elements.get(selectedIndex);
	}

	/**
	 * vf̕ύX𔽉fB
	 * 
	 * @param elem	ύXꂽvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener#elementChanged(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public void elementChanged(Element elem)
	{
		repaint();
	}

	/**
	 * vf̃hbv𔽉fBgpB
	 * 
	 * @param elem	hbvꂽvf
	 * @see jp.co.argo21.nautica.tool.wfd.dnd.DropElementListener#elementDropped(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public void elementDropped(Element elem)
	{
		//NOP
	}
	
	/**
	 * vf̃ACRۂɕ\r[łB
	 */
	private class IconView
	extends JComponent
	implements MouseListener, MouseMotionListener, DragGestureListener
	{
		/**
		 * ACRr[𐶐B
		 */
		public IconView()
		{
			Dimension size = new Dimension(MINIMUM_VIEW_SIZE);
			setPreferredSize(MINIMUM_VIEW_SIZE);
			setMinimumSize(MINIMUM_VIEW_SIZE);
			setSize(MINIMUM_VIEW_SIZE);

			addMouseListener(this);
			addMouseMotionListener(this);
			DragSource dragSource = new DragSource();
			dragSource.createDefaultDragGestureRecognizer(this, DnDConstants.ACTION_COPY, this);
		}

		/**
		 * ACR\GA`悷B
		 *
		 * @param g `ΏۃOtBbNX
		 */
		public void paintComponent(Graphics g)
		{
			g.setFont(VIEW_FONT);
			Dimension size = this.getSize();
			g.setColor(Color.white);
			g.fillRect(0, 0, size.width, size.height);

			this.paintElements(g);

			g.dispose();
		}

		/**
		 * \vf`悷B
		 *
		 * @param g `ΏۃOtBbNX
		 */
		private void paintElements(Graphics g)
		{
			if (elements == null) return;

			int count = elements.size();
			int sindex = -1;
			Element selement = null;
			for (int i = 0; i < count; i++) {
				Element child = (Element)elements.get(i);

				if (i != selectedIndex) {
					paintElement(g, child, i, 0);
				} else {
					sindex = i;
					selement = child;
				}
			}
			if (selement != null) paintSelectedElement(g, selement, sindex, 0);
		}

		/**
		 * \vf`悷B
		 *
		 * @param g     `ΏۃOtBbNX
		 * @param elem  \vf
		 * @param px    XW
		 * @param py    YW
		 */
		private void paintElement(Graphics g, Element elem, int px, int py)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			Graphics2D g2 = (Graphics2D)g;
			Shape shape = g2.getClip();
		
			int x = GRID_W * px;
			int y = GRID_H * py;
			int w = GRID_W;
			int h = GRID_H;

			Icon icon = IconManager.getIcon(elementType);
			int iconW = icon.getIconWidth();
			int iconH = icon.getIconHeight();
			int iconX = x + ((w - iconW) / 2);
			int iconY = y + 2;
			icon.paintIcon(this, g2, iconX, iconY);

			FontMetrics metrics = g.getFontMetrics();
			int fontH = metrics.getHeight();
			int descent = metrics.getDescent();

			g.setColor(Color.black);
			String n = elem.getName();
			if (StringUtils.checkNull(n)) n = rm.getResource("ElementList.noname");
			int lineW = metrics.stringWidth(n);
			if (lineW <= (w - 4)) {
				int dx = x + ((w - lineW) / 2);
				int dy = y + 2 + iconH + fontH - descent;
				g2.drawString(n, dx, dy);
			} else {
				int dotW = metrics.stringWidth("...");
				int dx = x + 2;
				int cy = y + 2 + iconH;
				int dw = w - (dotW + 4);
				g2.clipRect(dx, cy, dw, fontH);
				int dy = cy + fontH - descent;
				g2.drawString(n, dx, dy);
				g2.setClip(shape);
				dx = x + w - (dotW + 1);
				g2.clipRect(dx, cy, dotW, fontH);
				g2.drawString("...", dx, dy);
			}
			g2.setClip(shape);
		}

		/**
		 * \vf`悷B
		 *
		 * @param g     `ΏۃOtBbNX
		 * @param elem   \vf
		 * @param px    XW
		 * @param py    YW
		 */
		private void paintSelectedElement(Graphics g, Element elem, int px, int py)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			if (selectedIndex < 0) return;
			Dimension size = getSize();
			int x = GRID_W * px;
			int y = GRID_H * py;
			int w = GRID_W;
			int h = GRID_H;

			Icon selectedIcon = IconManager.getIcon(elementType + "-s");
			int iconW = selectedIcon.getIconWidth();
			int iconH = selectedIcon.getIconHeight();
			int iconX = x + ((w - iconW) / 2);
			int iconY = y + 2;
			selectedIcon.paintIcon(this, g, iconX, iconY);

			FontMetrics metrics = g.getFontMetrics();
			int fontH = metrics.getHeight();
			int descent = metrics.getDescent();
			String n = elem.getName();
			if (StringUtils.checkNull(n)) n = rm.getResource("ElementList.noname");
			int lineW = metrics.stringWidth(n);
			int dx = x + ((w - lineW) / 2);
			int dy = y + 2 + iconH;

			if (dx < 0) dx = 0;
			g.setColor(SystemColor.textHighlight);
			g.fillRect(dx, dy, lineW, fontH);
			
			dy = dy + fontH - descent;
			g.setColor(SystemColor.textHighlightText);
			g.drawString(n, dx, dy);
		}

		/**
		 * IԂČvZB
		 * 
		 * @param p	}EXʒu
		 */		
		private void recalcSelection(Point p)
		{
			if (p.x < 0) selectedIndex = -1;
			else if (p.y < 0 || p.y >= GRID_H) selectedIndex = -1;
			else selectedIndex = p.x / GRID_W;
			repaint();
		}


		/*
		 * C^tF[XDragGestureListener
		 */
		/**
		 * vf̃hbOJn𔻒肷B
		 * 
		 * @param e	Cxg
		 * @see java.awt.dnd.DragGestureListener#dragGestureRecognized(java.awt.dnd.DragGestureEvent)
		 */
		public void dragGestureRecognized(DragGestureEvent e)
		{
			//hbOɂđIꂽꍇ̏
			recalcSelection(e.getDragOrigin());

			Element elem = ElementList.this.getSelectedElement();
			if (elem == null) return;

			Transferable t = new ElementContext(elem, elementType);

			String iconName = elementType + "-cur";
			ImageIcon icon = (ImageIcon)IconManager.getIcon(iconName);
			Cursor cursor = Toolkit.getDefaultToolkit()
				.createCustomCursor(icon.getImage(), CURSOR_POINT, elementType);

			e.startDrag(cursor, t);
		}

		/**
		 * C^tF[XMouseListener
		 */
		/**
		 * }EXNbN𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
		 */
		public void mouseClicked(MouseEvent e)
		{
			recalcSelection(e.getPoint());

			if (selectedIndex < 0) return;

			if (e.getClickCount() >= 2) {
				executeInspectElement();
			}
		}

		/**
		 * }EX𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
		 */
		public void mousePressed(MouseEvent e)
		{
		}

		/**
		 * }EX̉𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
		 */
		public void mouseReleased(MouseEvent e)
		{
			if (e.isPopupTrigger()
			|| e.getModifiers() == MouseEvent.BUTTON2_MASK
			|| e.getModifiers() == MouseEvent.BUTTON3_MASK) {
				//|bvAbvoOɑIԂ𔻒肷B
				recalcSelection(e.getPoint());

				Element elem = getSelectedElement();
				if (elem == null) {
					popInspect.setEnabled(false);
					popDelete.setEnabled(false);
				} else {
					popInspect.setEnabled(true);
					popDelete.setEnabled(true);
				}
				popup.show(e.getComponent(), e.getX(), e.getY());
			}
		}

		/**
		 * }EX̐N𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
		 */
		public void mouseEntered(MouseEvent e)
		{
		}

		/**
		 * }EX̒Eo𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
		 */
		public void mouseExited(MouseEvent e)
		{
		}

		/**
		 * }EXhbO𔻒肷B
		 *
		 * @param	e		}EXCxg
		 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
		 */
		public void mouseDragged(MouseEvent e)
		{
		}

		/**
		 * }EXړ𔻒肷B
		 *
		 * @param	e		}EXCxg
		 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
		 */
		public void mouseMoved(MouseEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			Element elem = getElement(e.getPoint());
			if (elem == null) setToolTipText(null);
			else setToolTipText(elem.getTooltipText(rm));
		}
	}
}
