/* $Id: ElementReceivableView.java,v 1.3 2005/08/26 04:50:06 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;

import jp.co.argo21.nautica.tool.wfd.dnd.DropElementListener;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;

/**
 * vfACR̃hbv󂯓\ȃr[
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ElementReceivableView extends JComponent
implements MouseListener, DropTargetListener
{
	/** r[̃TCY */
	static private final Dimension VIEW_SIZE = new Dimension(60, 60);
	/** }XNF */
	static private final Color MASK_COLOR = new Color(255, 255, 255, 128);
	/** g */
	static private final Border border = BorderFactory.createLoweredBevelBorder();
	/** Xi[ */
	private List listeners = new ArrayList();

	/** 󂯓ꒆǂtO */
	private boolean isReceiving;
	/** 󂯓vf̌^ */
	private String elementType;
	/** 󂯓ꂽvf */
	private Element element;

	/**
	 * r[𐶐B
	 * 
	 * @param type 󂯓vf̌^
	 */
	public ElementReceivableView(String type)
	{
		elementType = type;
		setSize(VIEW_SIZE);
		setPreferredSize(VIEW_SIZE);
		setMinimumSize(VIEW_SIZE);
		DropTarget dt = new DropTarget(this, this);
		addMouseListener(this);
	}

	/**
	 * ACR\GA`悷B
	 *
	 * @param g `ΏۃOtBbNX
	 */
	public void paintComponent(Graphics g)
	{
		Dimension size = this.getSize();

		//`͈͈ȊO̔wi̕`
		g.setColor(Color.white);
		g.fillRect(0, 0, size.width, size.height);
		//ANeBreBACR̕`
		if (isReceiving || element != null) {
			Icon icon = IconManager.getIcon(elementType);

			int iconX = (size.width - icon.getIconWidth()) / 2;
			int iconY = (size.height - icon.getIconHeight()) / 2;
			icon.paintIcon(this, g, iconX, iconY);
		}

		if (isReceiving) {
			g.setColor(MASK_COLOR);
			g.fillRect(0, 0, size.width, size.height);
		}
		border.paintBorder(this, g, 0, 0, size.width, size.height);

		g.dispose();
	}

	/**
	 * vfԂB
	 * 
	 * @return	vf
	 */
	public Element getElement()
	{
		return element;
	}

	/**
	 * vfݒ肷
	 * 
	 * @param element	vf
	 */
	public void setElement(Element element)
	{
		this.element = element;
		repaint();
	}

	/*
	 * C^tF[XMouseListener
	 */
	/**
	 * }EXNbN𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e)
	{
		if (element == null) return;
		
		if (e.getClickCount() >= 2) {
			//vf̃_CAO\
			InspectorDialog.showDialog(ElementReceivableView.this, element);
			//ACRXVꂽƂ𓯕
			fireElementChanged();
		}

		repaint();
	}

	/**
	 * }EX𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e) { /* NOP */ }

	/**
	 * }EX̉𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e) { /* NOP */ }

	/**
	 * }EX̐N𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e) { /* NOP */ }

	/**
	 * }EX̒Eo𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e) { /* NOP */ }

	/**
	 * hbOr[ɓꍇɌĂ΂B
	 * 
	 * @param e DropTargetDragEvent
	 * @see java.awt.dnd.DropTargetListener#dragEnter(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dragEnter(DropTargetDragEvent e)
	{
		e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
	}

	/**
	 * hbOr[oꍇɌĂ΂B
	 * 
	 * @param e DropTargetEvent
	 * @see java.awt.dnd.DropTargetListener#dragExit(java.awt.dnd.DropTargetEvent)
	 */
	public void dragExit(DropTargetEvent e)
	{
		isReceiving = false;
		repaint();
	}

	/**
	 * hbOr[ɂꍇɌĂ΂B
	 * 
	 * @param e DropTargetDragEvent
	 * @see java.awt.dnd.DropTargetListener#dragOver(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dragOver(DropTargetDragEvent e)
	{
		try {
			DataFlavor[] flavors = e.getCurrentDataFlavors();
			if (flavors == null) return;
			if (flavors.length != 1) return;
			DataFlavor df = flavors[0];
			if (df == null) return;

			if (df.getPrimaryType().equals(WorkflowDesignerConstants.PTYPE)
				&& df.getSubType().equals(WorkflowDesignerConstants.STYPE_ELEMENT)) {
				if (df.getHumanPresentableName().equals(elementType)) {
					isReceiving = true;
					repaint();
				}
			}
		} catch (Exception ex) {
		} finally {
			repaint();
		}
	}

	/**
	 * hbvsꂽƂɌĂ΂B
	 * 
	 * @param e DropTargetDropEvent
	 * @see java.awt.dnd.DropTargetListener#drop(java.awt.dnd.DropTargetDropEvent)
	 */
	public void drop(DropTargetDropEvent e)
	{
		e.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);

		try {
			boolean invalid = false;
			Transferable t = e.getTransferable();
			if (t == null) invalid = true;
			DataFlavor[] flavors = t.getTransferDataFlavors();
			if (flavors == null) invalid = true;
			if (flavors.length != 1) invalid = true;
			DataFlavor df = flavors[0];
			if (df == null) invalid = true;
			if (df.getPrimaryType().equals(WorkflowDesignerConstants.PTYPE)
				&& df.getSubType().equals(WorkflowDesignerConstants.STYPE_ELEMENT)) {
				if (df.getHumanPresentableName().equals(elementType)) {
					//OK
				} else {
					invalid = true;
				}
			} else {
				invalid = true;
			}

			if (invalid) {
				e.dropComplete(false);
				return;
			}

			setElement((Element)t.getTransferData(df));
			
			//ACRhbvꂽƂ𓯕
			fireElementDropped();
			e.dropComplete(true);
		} catch (Exception ex) {
			e.dropComplete(false);
		} finally {
			isReceiving = false;
			repaint();
		}
	}

	/**
	 * hbvANV؂ւƂɌĂ΂B
	 * gp
	 * 
	 * @param e DropTargetDragEvent
	 * @see java.awt.dnd.DropTargetListener#dropActionChanged(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dropActionChanged(DropTargetDragEvent e) { /* nop */ }

	/**
	 * Xi[ǉB
	 * 
	 * @param l Xi[
	 */
	public void addChangeElementListener(DropElementListener l)
	{
		if (listeners.contains(l) == false) listeners.add(l);
	}

	/**
	 * Xi[폜B
	 * 
	 * @param l Xi[
	 */
	public void removeChangeElementListener(DropElementListener l)
	{
		if (listeners.contains(l)) listeners.remove(l);
	}

	/**
	 * Xi[ɗvf̕ύX𓯕񂷂B
	 */
	private void fireElementChanged()
	{
		Iterator it = listeners.iterator();
		while (it.hasNext()) {
			ChangeElementListener l = (ChangeElementListener)it.next();
			l.elementChanged(element);
		}
	}

	/**
	 * Xi[ɗvf̃hbv𓯕񂷂B
	 */
	private void fireElementDropped()
	{
		Iterator it = listeners.iterator();
		while (it.hasNext()) {
			ChangeElementListener l = (ChangeElementListener)it.next();
			l.elementDropped(element);
		}
	}
}

