/* $Id: FileManager.java,v 1.3 2005/08/26 04:50:27 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.wfmc.x2002.xpdl10.PackageDocument;

/**
 * WufUCiŎgpt@C̓o͊ǗsB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class FileManager
{
	/** ۑpXPDL */
	static private final String EMPTY_FLOW
		= "/jp/co/argo21/nautica/tool/wfd/resources/empty.xpdl";

	/** pXPDL */
	static private final String INITIAL_FLOW
		= "/jp/co/argo21/nautica/tool/wfd/resources/initial.xpdl";

	/** [Nt[`XPDLt@C */
	private String filename;
	
	/** [Nt[`hLg */
	private PackageDocument document;
	
	/**
	 * [Nt[`XPDLt@CԂB
	 * 
	 * @return [Nt[`XPDLt@C
	 */
	public String getFilename()
	{
		return filename;
	}
	
	/**
	 * [Nt[`hLgԂB
	 * 
	 * @return [Nt[`hLg
	 */
	public PackageDocument getDocument()
	{
		return document;
	}
	
	/**
	 * [Nt[`hLgݒ肷B
	 * 
	 * @param doc [Nt[`hLg
	 */
	public void setDocument(PackageDocument doc)
	{
		document = doc;
	}
	
	/**
	 * ̃[Nt[`hLgԂB
	 * 
	 * @throws XmlException XMLO
	 * @throws IOException o͗O
	 * @return [Nt[`hLg
	 */
	public PackageDocument getEmptyDocument() throws XmlException, IOException
	{
		InputStream in = getClass().getResourceAsStream(EMPTY_FLOW);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");
		PackageDocument doc = PackageDocument.Factory.parse(in, opts);
		in.close();
		return doc;
	}
	
	/**
	 * [Nt[`hLgB
	 * 
	 * @throws XmlException XMLO
	 * @throws IOException o͗O
	 */
	public void initDocument() throws XmlException, IOException
	{
		filename = null;
		InputStream in = getClass().getResourceAsStream(INITIAL_FLOW);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");
		document = PackageDocument.Factory.parse(in, opts);
		in.close();
	}
	
	/**
	 * [Nt[`hLg[hB
	 * 
	 * @param fn XPDLt@C
	 * @throws XmlException XMLO
	 * @throws IOException o͗O
	 */
	public void loadDocument(String fn) throws XmlException, IOException
	{
		File f = new File(fn);
		InputStream in = new FileInputStream(f);
		XmlOptions opts = new XmlOptions();
		opts.setCharacterEncoding("utf-8");
		document = PackageDocument.Factory.parse(in, opts);
		in.close();
		filename = fn;
	}
	
	/**
	 * [Nt[`hLgt@CɕۑB
	 * 
	 * @throws XmlException XMLO
	 * @throws IOException o͗O
	 */
	public void saveDocument() throws XmlException, IOException
	{
		OutputStream out = new FileOutputStream(filename);
		XmlOptions opts = new XmlOptions();
		opts.setSavePrettyPrint();
		opts.setSavePrettyPrintIndent(2);
		opts.setCharacterEncoding("utf-8");
		document.save(out, opts);
		out.close();
	}
	
	/**
	 * [Nt[`hLgt@CɕۑB
	 * 
	 * @param fn XPDLt@C
	 * @throws XmlException XMLO
	 * @throws IOException o͗O
	 */
	public void saveDocument(String fn) throws XmlException, IOException
	{
		OutputStream out = new FileOutputStream(fn);
		XmlOptions opts = new XmlOptions();
		opts.setSavePrettyPrint();
		opts.setSavePrettyPrintIndent(2);
		opts.setCharacterEncoding("utf-8");
		document.save(out, opts);
		out.close();
		filename = fn;
	}
}
