/* $Id: FlowDesignToolBar.java,v 1.3 2005/08/26 04:50:19 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.dnd.ActivityItemContext;

/**
 * ANeBreBIpo[B
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class FlowDesignToolBar extends JToolBar
{
	/** t[ҏW[h\萔 */
	static public final int POINT_MODE    = 1;
	/** ڑ[h\萔 */
	static public final int CONNECT_MODE  = 2;
	/** V~[V[h\萔 */
	static public final int SIM_MODE      = 3;

	/** {^TCY */
	static private final Dimension BUTTON_SIZE = new Dimension(50, 50);
	/** J[\̈ʒu */
	static private final Point CURSOR_POINT = new Point(16, 16);

	/** t[ҏW[h{^ */
	JToggleButton pointerButton;

	/** Xi[ */
	private List listeners = new ArrayList();
	/** ݂̃[h */
	private int mode = POINT_MODE;
	/** hbO\ǂtO */
	private boolean draggable = true;

	/** t[ACeI{^ꗗ */
	private ActivityItem[] buttons
		= new ActivityItem[WorkflowDesignerConstants.DROPPABLE_ITEMS.length];

	/**
	 * t[ACeIpo[𐶐B
	 */
	public FlowDesignToolBar()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		
		setFloatable(false);
		
		ButtonGroup group = new ButtonGroup();

		pointerButton = new ModeButton("pointer");
		pointerButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					mode = POINT_MODE;
					setDraggable(true);
					fireModeChanged();
				}
			}
		);
		add(pointerButton);
		int maxItem = WorkflowDesignerConstants.DROPPABLE_ITEMS.length;
		for (int i = 0; i < maxItem; i++) {
			buttons[i]
				= new ActivityItem(WorkflowDesignerConstants.DROPPABLE_ITEMS[i]);
			add(buttons[i]);
		}

		JToggleButton connectButton = new ModeButton("connect");
		connectButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					mode = CONNECT_MODE;
					setDraggable(false);
					fireModeChanged();
				}
			}
		);
		add(connectButton);

		JToggleButton simulateButton = new ModeButton("simulate");
		simulateButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					mode = SIM_MODE;
					setDraggable(false);
					fireModeChanged();
				}
			}
		);
		add(simulateButton);

		addSeparator();

		JButton validateButton
			= new JButton(IconManager.getIcon("validation"));
		validateButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					WorkflowDesignerManager.getMainFrame().validatePackage();
				}
			}
		);
		validateButton.setPressedIcon(IconManager.getIcon("validation-s"));
		validateButton.setContentAreaFilled(false);
		validateButton.setFocusPainted(false);
		validateButton.setRolloverEnabled(true);
		validateButton.setBorderPainted(false);
		validateButton.setMaximumSize(BUTTON_SIZE);
		validateButton.setPreferredSize(BUTTON_SIZE);
		validateButton.setToolTipText(rm.getResource("FlowDesignToolBar.validation.tooltip"));
		add(validateButton);

		addSeparator();

		String iconName = WorkflowDesignerConstants.EL_PACKAGE;
		JButton packageButton = new JButton(IconManager.getIcon(iconName));
		packageButton.addActionListener(
			new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					WorkflowDesignerManager.getMainFrame().showPackageInspector();
				}
			}
		);
		packageButton.setPressedIcon(IconManager.getIcon(iconName + "-s"));
		packageButton.setContentAreaFilled(false);
		packageButton.setFocusPainted(false);
		packageButton.setRolloverEnabled(true);
		packageButton.setBorderPainted(false);
		packageButton.setMaximumSize(BUTTON_SIZE);
		packageButton.setPreferredSize(BUTTON_SIZE);
		packageButton.setToolTipText(rm.getResource("FlowDesignToolBar.model.tooltip"));
		add(packageButton);

		group.add(pointerButton);
		group.add(connectButton);
		group.add(simulateButton);

		pointerButton.setSelected(true);
	}

	/**
	 * c[o[̏sB
	 */	
	void init()
	{
		pointerButton.setSelected(true);
		listeners.clear();
	}

	/**
	 * [hύXXi[ǉB
	 * 
	 * @param l [hύXXi[
	 */
	public void addModeChangedListener(ModeChangeListener l)
	{
		if (listeners.contains(l) == false) listeners.add(l);
	}

	/**
	 * [hύXXi[폜B
	 * 
	 * @param l [hύXXi[
	 */
	public void removeModeChangedListener(ModeChangeListener l)
	{
		if (listeners.contains(l)) listeners.remove(l);
	}

	/**
	 * [hύXXi[ɓ񂷂B
	 */
	private void fireModeChanged()
	{
		Iterator it = listeners.iterator();
		while (it.hasNext()) {
			ModeChangeListener l = (ModeChangeListener)it.next();
			l.modeChanged(mode);
		}
	}

	/**
	 * hbO\ǂݒ肷B
	 * 
	 * 
	 * @param flag hbO\tO
	 */
	public void setDraggable(boolean flag)
	{
		this.draggable = flag;
		for (int i = 0; i < buttons.length; i++) {
			buttons[i].setEnabled(draggable);
		}
	}
	
	/**
	 * hbO\ǂԂB
	 * 
	 * 
	 * @return hbO\tO
	 */
	public boolean isDraggable()
	{
		return draggable;
	}

	/**
	 * [hύX{^R|[lg
	 */
	class ModeButton extends JToggleButton
	{
		/**
		 * [hύX{^𐶐B
		 * 
		 * @param name	C[W
		 */
		public ModeButton(String name)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			setContentAreaFilled(false);
			setFocusPainted(false);
			setRolloverEnabled(true);
			setBorderPainted(false);
			setIcon(IconManager.getIcon(name));
			setSelectedIcon(IconManager.getIcon(name + "-s"));
			setMaximumSize(BUTTON_SIZE);
			setPreferredSize(BUTTON_SIZE);
			setToolTipText(rm.getResource("FlowDesignToolBar." + name + ".tooltip"));
		}
	}	

	/**
	 * ANeBreBI{^R|[lg
	 */
	class ActivityItem extends JLabel
	implements DragGestureListener
	{
		/** ANeBreBpbg */
		private String name;
		
		/**
		 * ANeBreBpbg\p
		 * 
		 * @param name	ANeBreBpbg
		 */
		public ActivityItem(String name)
		{
			this.name = name;
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			setBorder(BorderFactory.createLoweredBevelBorder());
			setBorderPainted(true);
			setIcon(IconManager.getIcon(name));
			setMaximumSize(BUTTON_SIZE);
			setPreferredSize(BUTTON_SIZE);
			setToolTipText(rm.getResource("FlowDesignToolBar." + name + ".tooltip"));
			DragSource dragSource = new DragSource();
			dragSource.createDefaultDragGestureRecognizer(this, DnDConstants.ACTION_COPY, this);
		}

		/*
		 * C^tF[XDragGestureListener
		 */
		/**
		 * hbOJnB
		 * 
		 * @param e	Cxg
		 * @see java.awt.dnd.DragGestureListener#dragGestureRecognized(java.awt.dnd.DragGestureEvent)
		 */
		public void dragGestureRecognized(DragGestureEvent e)
		{
			if (isEnabled() == false) return;

			Point p = e.getDragOrigin();
			int ix = p.y / 50;		
			if (ix < 0) return;
			else if (ix >= WorkflowDesignerConstants.DROPPABLE_ITEMS.length) return;
			
			Transferable t = new ActivityItemContext(name);

			ImageIcon icon = (ImageIcon)IconManager.getIcon(name);
			Cursor cursor = Toolkit.getDefaultToolkit()
				.createCustomCursor(icon.getImage(), CURSOR_POINT, name);

			e.startDrag(cursor, t);
		}
	}	
}
