/* $Id: InspectorDialog.java,v 1.4 2005/08/26 04:50:08 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import javax.swing.*;

import java.awt.*;
import java.awt.event.*;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.inspector.AbstractElementInspector;
import jp.co.argo21.nautica.tool.wfd.inspector.ChangeElementListener;
import jp.co.argo21.nautica.tool.wfd.inspector.Inspector;

/**
 * CXyN^\p̃_CAO񋟂B
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class InspectorDialog extends JDialog
{
	/** CyN^}l[W */
	static private InspectorManager manager;

	/** \̃CXyN^ */
	private Inspector inspector;

	/**
	 * CXyN^}l[W̏
	 */
	static
	{
		manager = new ElementInspectorManager();
	}

	/**
	 * _CAO\B
	 * 
	 * @param c	eR|[lg
	 * @param elem	vf
	 * @return	XVꂽvf
	 */
	public static Element showDialog(Component c, Element elem)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		InspectorDialog dialog = new InspectorDialog(frame, elem);
		dialog.setVisible(true);
		Element result = dialog.inspector.getInspectable();
		dialog.dispose();
		return result;
	}

	/**
	 * _CAO\B
	 * 
	 * @param c	eR|[lg
	 * @param elemType	vf^
	 * @return	XVꂽvf
	 */
	public static Element showDialog(Component c, String elemType)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		InspectorDialog dialog = new InspectorDialog(frame, elemType);
		dialog.setVisible(true);
		Element result = dialog.inspector.getInspectable();
		dialog.dispose();
		return result;
	}

	/**
	 * vfύXXi[ǉB
	 * 
	 * @param elemType	vf^
	 * @param l	Xi[
	 */
	public static void addChangeElementListener(String elemType, ChangeElementListener l)
	{
		Inspector i = manager.getInspectorForName(elemType);
		
		if (i instanceof AbstractElementInspector) {
			((AbstractElementInspector)i).addChangeElementListener(l);
		}
	}

	/**
	 * vfύXXi[폜B
	 * 
	 * @param elemType	vf^
	 * @param l	Xi[
	 */
	public static void removeChangeElementListener(String elemType, ChangeElementListener l)
	{
		Inspector i = manager.getInspectorForName(elemType);
		
		if (i instanceof AbstractElementInspector) {
			((AbstractElementInspector)i).removeChangeElementListener(l);
		}
	}

	/**
	 * _CAO𐶐B
	 * 
	 * @param frame	et[
	 * @param elem	vf
	 */
	private InspectorDialog(Frame frame, Element elem)
	{
		super(frame, true);

		if (elem == null) {
			inspector = manager.getDefaultInspector();
		} else {
			String inspectorName = ElementInspectorManager.getInspectorKey(elem);
			inspector = manager.getInspectorForName(inspectorName);
		}
		inspector.init();
		inspector.setInspectable(elem);
		
		createDialog();

		setLocationRelativeTo(frame);
	}

	/**
	 * _CAO𐶐B
	 * 
	 * @param frame	et[
	 * @param elemType	vf^
	 */
	private InspectorDialog(Frame frame, String elemType)
	{
		super(frame, true);

		if (elemType == null) {
			inspector = manager.getDefaultInspector();
		} else {
			inspector = manager.getInspectorForName(elemType);
		}
		inspector.init();
		inspector.setInspectable(null);
		
		createDialog();

		setLocationRelativeTo(frame);
	}

	/**
	 * _CAO쐬B
	 */
	private void createDialog()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		setTitle(rm.getResource("InspectorDialog.title"));
		
		JScrollPane scroll = new JScrollPane();
		scroll.setViewportView((JComponent)inspector);

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener listener = new CloseAction();
		if (inspector.isAutoCommit()) { 
			JButton closeButton = new JButton(rm.getResource("JButton.label.close"));
			closeButton.addActionListener(listener);
			getRootPane().setDefaultButton(closeButton);
			buttonPane.add(closeButton);
		} else {
			JButton setButton = new JButton(rm.getResource("JButton.label.set"));
			setButton.setActionCommand("OK_OPTION");
			setButton.addActionListener(listener);
			getRootPane().setDefaultButton(setButton);
			buttonPane.add(setButton);

			JButton cancelButton = new JButton(rm.getResource("JButton.label.cancel"));
			cancelButton.addActionListener(listener);
			buttonPane.add(cancelButton);
		}

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();
	}

	/**
	 * _CAOƂ̏
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * ؂sĂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if ("OK_OPTION".equals(e.getActionCommand())) {
				if (inspector.check() == false) {
					//G[̂ŁAR~bgreturn
					//_CAO͕Ȃ
					return;
				}
				inspector.commit();
			}
			inspector.unload();
			setVisible(false);
		}
	}
}
