/* $Id: InspectorManager.java,v 1.3 2005/08/26 04:50:24 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.util.Hashtable;
import java.util.Map;

import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.inspector.Inspector;
import jp.co.argo21.nautica.tool.wfd.inspector.NoInspectableInspector;

/**
 * CXyN^Ǘ邽߂̊NX
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class InspectorManager
{
	/** ftHgCXyN^ */
	static public final String DEFALT_INSPECTOR = "DEFAULT_INSPECTOR";

	/** CXyN^ꗗ */
	private Map inspectors = new Hashtable();

	/**
	 * CXyN^}l[W𐶐B
	 */
	public InspectorManager()
	{
		putInspectorForName(DEFALT_INSPECTOR, new NoInspectableInspector());
	}

	/**
	 * ftHgCXyN^ԂB
	 * 
	 * @return	CXyN^
	 */
	public Inspector getDefaultInspector()
	{
		return (Inspector)inspectors.get(DEFALT_INSPECTOR);
	}

	/**
	 * w肳ꂽOɑΉCXyN^Ԃ
	 * 
	 * @param name	CXyN^
	 * @return	CXyN^
	 */
	public Inspector getInspectorForName(String name)
	{
		if (name == null) return getDefaultInspector();

		Inspector inspector = (Inspector)inspectors.get(name);
		if (inspector == null) return getDefaultInspector();

		return inspector;
	}

	/**
	 * w肳ꂽOŃCXyN^o^B
	 * 
	 * @param name	CXyN^
	 * @param inspector	CXyN^
	 */
	protected void putInspectorForName(String name, Inspector inspector)
	{
		if (StringUtils.checkNull(name)) return;
		if (inspector == null) return;
		
		inspectors.put(name, inspector);		
	}
}
