/* $Id: MenuBar.java,v 1.3 2005/08/26 04:50:03 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.action.ActionNames;

/**
 * Nautica WorkflowDesigner̃j[o[łB
 *
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
final class MenuBar extends JMenuBar
{
	/** t@C */
	private JMenu     fileMenu            = new JMenu();
	/** VK` */
	private JMenuItem newItem             = new JMenuItem();
	/** J */
	private JMenuItem openItem            = new JMenuItem();
	/** ۑ */
	private JMenuItem saveItem            = new JMenuItem();
	/** ʖŕۑ */
	private JMenuItem saveToItem          = new JMenuItem();
	/**  */
	private JMenuItem printItem           = new JMenuItem();
	/** I */
	private JMenuItem exitItem            = new JMenuItem();

	/** ҏW */
	private JMenu     editMenu            = new JMenu();
	/** ؂ */
	private JMenuItem cutItem             = new JMenuItem();
	/** Rs[ */
	private JMenuItem copyItem            = new JMenuItem();
	/** y[Xg */
	private JMenuItem pasteItem           = new JMenuItem();
	/** 폜 */
	private JMenuItem deleteItem          = new JMenuItem();


	/** c[ */
	private JMenu     toolMenu            = new JMenu();
	/** Or[A */
	private JMenuItem exceptionViewerItem = new JMenuItem();
	/** ݒ */
	private JMenuItem preferenceItem      = new JMenuItem();

	/** wv */
	private JMenu     helpMenu            = new JMenu();
	/** wv\ */
	private JMenuItem helpItem            = new JMenuItem();
	/** o[W\ */
	private JMenuItem versionItem         = new JMenuItem();

	/**
	 * j[o[\zB
	 */
	public MenuBar()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		ActionMap am = WorkflowDesignerManager.getActionMap();
		
		initFileMenu(rm, am);
		initEditMenu(rm, am);
		//initToolMenu(rm, am);
		initHelpMenu(rm, am);
	}
	
	/**
	 * t@Cj[\zB
	 * 
	 * @param rm	\[X}l[W
	 * @param am	ANV}bv
	 */
	private void initFileMenu(ResourceManager rm, ActionMap am)
	{
		newItem.setText(rm.getResource("Menu.file.new"));
		newItem.setMnemonic('N');
		newItem.addActionListener(am.get(ActionNames.NEW_PACKAGE));

		openItem.setText(rm.getResource("Menu.file.open"));
		openItem.setMnemonic('O');
		openItem.addActionListener(am.get(ActionNames.OPEN_PACKAGE));

		saveItem.setText(rm.getResource("Menu.file.save"));
		saveItem.setMnemonic('S');
		saveItem.addActionListener(am.get(ActionNames.SAVE_PACKAGE));

		saveToItem.setText(rm.getResource("Menu.file.saveTo"));
		saveToItem.setMnemonic('A');
		saveToItem.addActionListener(am.get(ActionNames.SAVE_TO_PACKAGE));

		printItem.setText(rm.getResource("Menu.file.print"));
		printItem.setMnemonic('P');
		printItem.addActionListener(am.get(ActionNames.PRINT_PACKAGE));

		exitItem.setText(rm.getResource("Menu.file.exit"));
		exitItem.setMnemonic('X');
		exitItem.addActionListener(am.get(ActionNames.EXIT));

		fileMenu.setText(rm.getResource("Menu.file"));
		fileMenu.setMnemonic('F');
		fileMenu.add(newItem);
		fileMenu.add(openItem);
		fileMenu.addSeparator();
		fileMenu.add(saveItem);
		fileMenu.add(saveToItem);
		fileMenu.addSeparator();
		fileMenu.add(printItem);
		fileMenu.addSeparator();
		fileMenu.add(exitItem);

		add(fileMenu);
	}
	
	/**
	 * ҏWj[\zB
	 * 
	 * @param rm	\[X}l[W
	 * @param am	ANV}bv
	 */
	private void initEditMenu(ResourceManager rm, ActionMap am)
	{
		cutItem.setText(rm.getResource("Menu.edit.cut"));
		cutItem.setMnemonic('T');
		cutItem.addActionListener(am.get(ActionNames.CUT_ACTIVITY));
		cutItem.setEnabled(false);

		copyItem.setText(rm.getResource("Menu.edit.copy"));
		copyItem.setMnemonic('C');
		copyItem.addActionListener(am.get(ActionNames.COPY_ACTIVITY));
		copyItem.setEnabled(false);

		pasteItem.setText(rm.getResource("Menu.edit.paste"));
		pasteItem.setMnemonic('P');
		pasteItem.addActionListener(am.get(ActionNames.PASTE_ACTIVITY));
		pasteItem.setEnabled(false);

		deleteItem.setText(rm.getResource("Menu.edit.delete"));
		deleteItem.setMnemonic('D');
		deleteItem.addActionListener(am.get(ActionNames.DELETE_ACTIVITY));
		deleteItem.setEnabled(false);

		editMenu.setText(rm.getResource("Menu.edit"));
		editMenu.setMnemonic('E');
		editMenu.add(cutItem);
		editMenu.add(copyItem);
		editMenu.add(pasteItem);
		editMenu.addSeparator();
		editMenu.add(deleteItem);

		add(editMenu);
	}
	
	/**
	 * c[j[\zB
	 * 
	 * @param rm	\[X}l[W
	 * @param am	ANV}bv
	 */
	private void initToolMenu(ResourceManager rm, ActionMap am)
	{
		exceptionViewerItem.setText(rm.getResource("Menu.tool.exception"));
		exceptionViewerItem.setMnemonic('E');
		exceptionViewerItem.addActionListener(am.get(ActionNames.EXCEPTION_VIEWER));

		preferenceItem.setText(rm.getResource("Menu.tool.preference"));
		preferenceItem.setMnemonic('O');
		preferenceItem.addActionListener(am.get(ActionNames.PREFERENCES));

		toolMenu.setText(rm.getResource("Menu.tool"));
		toolMenu.setMnemonic('T');
		toolMenu.add(exceptionViewerItem);
		toolMenu.addSeparator();
		toolMenu.add(preferenceItem);

		add(toolMenu);
	}
	
	/**
	 * wvj[\zB
	 * 
	 * @param rm	\[X}l[W
	 * @param am	ANV}bv
	 */
	private void initHelpMenu(ResourceManager rm, ActionMap am)
	{
		helpItem.setText(rm.getResource("Menu.help.help"));
		helpItem.setMnemonic('H');
		helpItem.addActionListener(am.get(ActionNames.HELP));

		versionItem.setText(rm.getResource("Menu.help.version"));
		versionItem.setMnemonic('A');
		versionItem.addActionListener(am.get(ActionNames.ABOUT));

		helpMenu.setText(rm.getResource("Menu.help"));
		helpMenu.setMnemonic('H');
		helpMenu.add(helpItem);
		helpMenu.addSeparator();
		helpMenu.add(versionItem);

		add(helpMenu);
	}
	
	/**
	 * Rs[\ǂԂB
	 * 
	 * @return	\Ȃtrue
	 */
	boolean getEnableCopyAction()
	{
		return copyItem.isEnabled();
	}

	/**
	 * Rs[\ǂݒ肷B
	 * 
	 * @param f	tO
	 */	
	void setEnableCopyAction(boolean f)
	{
		cutItem.setEnabled(f);
		copyItem.setEnabled(f);
	}

	/**
	 * y[Xg\ǂԂB
	 * 
	 * @return	\Ȃtrue
	 */	
	boolean getEnablePasteAction()
	{
		return pasteItem.isEnabled();
	}

	/**
	 * y[Xg\ǂݒ肷B
	 * 
	 * @param f	tO
	 */	
	void setEnablePasteAction(boolean f)
	{
		pasteItem.setEnabled(f);
	}

	/**
	 * 폜\ǂԂB
	 * 
	 * @return	\Ȃtrue
	 */	
	boolean getEnableDeleteAction()
	{
		return deleteItem.isEnabled();
	}

	/**
	 * 폜\ǂݒ肷B
	 * 
	 * @param f	tO
	 */	
	void setEnableDeleteAction(boolean f)
	{
		deleteItem.setEnabled(f);
	}
}
