/* $Id: PackageValidator.java,v 1.4 2005/08/26 04:50:14 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;


/**
 * pbP[W̌؂sB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class PackageValidator
{
	/** G[ */
	static private final int E = ValidationResult.ERROR; 
	/** x */
	static private final int W = ValidationResult.WARNING; 
	
	/** ؊ */
	static private final PackageValidator singleton = new PackageValidator();

	/**
	 * ؊ԂB
	 * 
	 * @return	؊
	 */
	static public PackageValidator getInstance()
	{
		return singleton;
	}

	/**
	 * ؊𐶐B
	 */
	private PackageValidator()
	{
	}

	/**
	 * ،ʂPǉB
	 * 
	 * @param results	ʈꗗ
	 * @param kind	ʎ
	 * @param elem	Ώۗvf
	 * @param msgid	bZ[W
	 */	
	private void addResult(List results, int kind, Element elem, String msgid)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		ValidationResult r = new ValidationResult(kind, elem, rm.getResource(msgid));
		results.add(r);
	}

	/**
	 * w肳ꂽpbP[W؂B
	 * 
	 * @param elem	pbP[W
	 * @return	،ʈꗗ
	 */
	public List validate(PackageElement elem)
	{
		List results = new ArrayList();

		if (elem == null) {
			addResult(results, E, elem, "message.error.0101");
			return results;
		} 
		
		validatePackageElement(elem, results);
		
		if (results.size() == 0) return null;
		else return results;
	}

	/**
	 * w肳ꂽpbP[W؂B
	 * 
	 * @param elem	pbP[W
	 * @param results	،ʈꗗ
	 */
	private void validatePackageElement(
	PackageElement elem,
	List results)
	{
		if (StringUtils.checkNull(elem.getName())) 
			addResult(results, E, elem, "message.error.0102");
		
		List apps = elem.getApplications();
		if (apps.size() > 0) {
			Iterator it = apps.iterator();
			while (it.hasNext()) {
				ApplicationElement e = (ApplicationElement)it.next();
				validateApplicationElement(e, results);
				validateSameName(e, apps, results);			}
		}
		
		List parts = elem.getParticipants();
		if (parts.size() > 0) {
			Iterator it = parts.iterator();
			while (it.hasNext()) {
				ParticipantElement e = (ParticipantElement)it.next();
				validateParticipantElement(e, results);
				validateSameName(e, parts, results);			}
		}
		
		List vars = elem.getVariables();
		if (vars.size() > 0) {
			Iterator it = vars.iterator();
			while (it.hasNext()) {
				VariableElement e = (VariableElement)it.next();
				validateVariableElement(e, results);
				validateSameName(e, vars, results);
			}
		}
		
		List procs = elem.getProcesses();
		if (procs.size() > 0) {
			Iterator it = procs.iterator();
			while (it.hasNext()) {
				ProcessElement e = (ProcessElement)it.next();
				validateProcessElement(elem, e, results);
				validateSameName(e, procs, results);			}
		}
	}

	/**
	 * w肳ꂽAvP[V؂B
	 * 
	 * @param elem	AvP[V
	 * @param results	،ʈꗗ
	 */
	private void validateApplicationElement(
	ApplicationElement elem,
	List results)
	{
		if (StringUtils.checkNull(elem.getName())) 
			addResult(results, E, elem, "message.error.0103");
		
		List params = elem.getParameters();
		if (params.size() > 0) {
			Iterator it = params.iterator();
			while (it.hasNext()) {
				ParameterElement e = (ParameterElement)it.next();
				validateParameterElement(e, results);
			}
		}
	}

	/**
	 * w肳ꂽ[Nt[Q҂؂B
	 * 
	 * @param elem	[Nt[Q
	 * @param results	،ʈꗗ
	 */
	private void validateParticipantElement(
	ParticipantElement elem,
	List results)
	{
		if (StringUtils.checkNull(elem.getName())) 
			addResult(results, E, elem, "message.error.0104");
	}

	/**
	 * w肳ꂽvZXϐ؂B
	 * 
	 * @param elem	vZXϐ
	 * @param results	،ʈꗗ
	 */
	private void validateVariableElement(
	VariableElement elem,
	List results)
	{
		if (StringUtils.checkNull(elem.getName())) 
			addResult(results, E, elem, "message.error.0105");
		if (StringUtils.checkNull(elem.getInitialValue())) 
			addResult(results, W, elem, "message.warn.0101");
	}

	/**
	 * w肳ꂽvZX؂B
	 * 
	 * @param pkg	pbP[W
	 * @param elem	vZX
	 * @param results	،ʈꗗ
	 */
	private void validateProcessElement(
	PackageElement pkg,
	ProcessElement elem,
	List results)
	{
		if (StringUtils.checkNull(elem.getName())) 
			addResult(results, E, elem, "message.error.0106");

		List rsps = elem.getResponsibles();
		if (rsps.size() == 0)
			addResult(results, W, elem, "message.warn.0102");

		List params = elem.getParameters();
		if (params.size() > 0) {
			Iterator it = params.iterator();
			while (it.hasNext()) {
				ParameterElement e = (ParameterElement)it.next();
				validateParameterElement(e, results);
			}
		}
		
		List acts = elem.getActivities();
		List trs = elem.getTransitions();
		if (acts.size() > 0) {
			Iterator it = acts.iterator();
			while (it.hasNext()) {
				ActivityElement e = (ActivityElement)it.next();
				validateTransition(e, trs, results);
				validateActivityElement(pkg, e, results);
			}
		}
		
		if (trs.size() > 0) {
			Iterator it = trs.iterator();
			while (it.hasNext()) {
				TransitionElement e = (TransitionElement)it.next();
				validateTransitionElement(e, results);
			}
		}
	}

	/**
	 * w肳ꂽp[^؂B
	 * 
	 * @param elem	p[^
	 * @param results	،ʈꗗ
	 */
	private void validateParameterElement(
	ParameterElement elem,
	List results)
	{
		//NOP
	}

	/**
	 * w肳ꂽANeBreB؂B
	 * 
	 * @param pkg	pbP[W
	 * @param elem	ANeBreB
	 * @param results	،ʈꗗ
	 */
	private void validateActivityElement(
	PackageElement pkg,
	ActivityElement elem,
	List results)
	{
		if (StringUtils.checkNull(elem.getName())) 
			addResult(results, E, elem, "message.error.0107");

		String type = elem.getType();

		if (type.equals(ActivityElement.INTERACTIVE)) {
			if (StringUtils.checkNull(elem.getPerformerID()))
				addResult(results, W, elem, "message.error.0119");
		} else if (type.equals(ActivityElement.AUTOMATIC)) {
			if (StringUtils.checkNull(elem.getPerformerID()))
				addResult(results, W, elem, "message.error.0119" +
						"");
			if (StringUtils.checkNull(elem.getApplicationID())) {
				addResult(results, E, elem, "message.error.0108");
				validateApplication(elem, pkg.getApplications(), results);

				List params = elem.getApplicationParameters();
				if (params.size() > 0) {
					Iterator it = params.iterator();
					while (it.hasNext()) {
						String aid = (String)it.next();
						validateActualParams(elem, aid, pkg.getVariables(), results);
					}
				}
				
			}
		} else if (type.equals(ActivityElement.SUBPROCESS)) {
			if (StringUtils.checkNull(elem.getSubprocessID())) {
				addResult(results, E, elem, "message.error.0109");
				validateSubprocess(elem, pkg.getProcesses(), results);

				List params = elem.getSubprocessParameters();
				if (params.size() > 0) {
					Iterator it = params.iterator();
					while (it.hasNext()) {
						String pid = (String)it.next();
						validateActualParams(elem, pid, pkg.getVariables(), results);
					}
				}
			}
		}
	}

	/**
	 * w肳ꂽJڂ؂B
	 * 
	 * @param elem	J
	 * @param results	،ʈꗗ
	 */
	private void validateTransitionElement(
	TransitionElement elem,
	List results)
	{
		switch (elem.getType()) {
			case TransitionElement.CONDITION:
				if (elem.getCondition() == null) 
					addResult(results, E, elem, "message.error.0110");
				break;
		}
	}

	/**
	 * w肳ꂽANeBreB̑Jڂ؂B
	 * 
	 * @param elem	ANeBreB
	 * @param trs	Jڈꗗ
	 * @param results	،ʈꗗ
	 */	
	private void validateTransition(
	ActivityElement elem,
	List trs,
	List results)
	{
		int in = 0;
		int out = 0;
		Iterator it = trs.iterator();
		while (it.hasNext()) {
			TransitionElement e = (TransitionElement)it.next();
			if (elem == e.getSource()) out++;
			else if (elem == e.getDestination()) in++;
		}
		if (elem.getType().equals(ActivityElement.START)) {
			if (out == 0)
				addResult(results, E, elem, "message.error.0111");
		} else if (elem.getType().equals(ActivityElement.END)) {
			if (in == 0)
				addResult(results, E, elem, "message.error.0112");
		} else {
			if (in == 0)
				addResult(results, E, elem, "message.error.0112");
			if (out == 0)
				addResult(results, E, elem, "message.error.0111");
		}
	}

	/**
	 * w肳ꂽANeBreB̃vZXϐ؂B
	 * 
	 * @param elem	ANeBreB
	 * @param vars	vZXϐꗗ
	 * @param results	،ʈꗗ
	 */	
	private void validateSameName(
	Element elem,
	List vars,
	List results)
	{
		Iterator it = vars.iterator();
		while (it.hasNext()) {
			Element e = (Element)it.next();
			if (elem.getName() == null || e.getName() == null) {
			} else if (elem == e) {
			} else if (elem.getName().equals(e.getName())) {
				addResult(results, E, elem, "message.error.0113");
			}
		}
	}

	/**
	 * w肳ꂽANeBreB̃AvP[V؂B
	 * 
	 * @param elem	ANeBreB
	 * @param apps	AvP[Vꗗ
	 * @param results	،ʈꗗ
	 */	
	private void validateApplication(
	ActivityElement elem,
	List apps,
	List results)
	{
		Iterator it = apps.iterator();
		String appID = elem.getApplicationID();
		if (appID == null) return;
		
		boolean found = false;
		while (it.hasNext()) {
			ApplicationElement e = (ApplicationElement)it.next();
			if (appID.equals(e.getID())) {
				found = true;
				break;
			}
		}
		if (found == false)
			addResult(results, E, elem, "message.error.0114");
	}

	/**
	 * w肳ꂽANeBreB̃TuvZX؂B
	 * 
	 * @param elem	ANeBreB
	 * @param procs	vZXꗗ
	 * @param results	،ʈꗗ
	 */	
	private void validateSubprocess(
	ActivityElement elem,
	List procs,
	List results)
	{
		Iterator it = procs.iterator();
		String procID = elem.getSubprocessID();
		if (procID == null) return;
		
		boolean found = false;
		while (it.hasNext()) {
			ProcessElement e = (ProcessElement)it.next();
			if (procID.equals(e.getID())) {
				found = true;
				break;
			}
		}
		if (found == false)
			addResult(results, E, elem, "message.error.0115");
	}

	/**
	 * w肳ꂽANeBreBɊ蓖Ăꂽs؂B
	 * 
	 * @param elem	ANeBreB
	 * @param parts	[Nt[Q҈ꗗ
	 * @param results	،ʈꗗ
	 */	
	private void validateParticipant(
	ActivityElement elem,
	List parts,
	List results)
	{
		Iterator it = parts.iterator();
		String partID = elem.getPerformerID();
		if (partID == null) return;
		
		boolean found = false;
		while (it.hasNext()) {
			ParticipantElement e = (ParticipantElement)it.next();
			if (partID.equals(e.getID())) {
				found = true;
				break;
			}
		}
		if (found == false)
			addResult(results, E, elem, "message.error.0116");
	}

	/**
	 * w肳ꂽANeBreBɊ蓖Ăꂽp[^؂B
	 * 
	 * @param elem	ANeBreB
	 * @param id	p[^ID
	 * @param params	p[^ꗗ
	 * @param results	،ʈꗗ
	 */	
	private void validateActualParams(
	ActivityElement elem,
	String id,
	List params,
	List results)
	{
		Iterator it = params.iterator();
		if (StringUtils.checkNull(id)) {
			addResult(results, E, elem, "message.error.0117");
			return;
		} 
		
		boolean found = false;
		while (it.hasNext()) {
			VariableElement e = (VariableElement)it.next();
			if (id.equals(e.getID())) {
				found = true;
				break;
			}
		}
		if (found == false)
			addResult(results, E, elem, "message.error.0118");
	}
}
