/* $Id: ProcessDesignFrame.java,v 1.3 2005/08/26 04:50:11 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JInternalFrame;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;

/**
 * vZXfUCp̃t[񋟂
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessDesignFrame extends JInternalFrame
{
	/** ^uyC */
	private JTabbedPane tabbedPane;
	
	/** XvbgyC */
	private JSplitPane splitPane;

	/** t[fUCp̃r[ */
	private ProcessDesignView view;

	/** ANeBreBCXyN^\p̃r[ */
	private ActivityInspectorView inspectorView;
	
	/** vZX */
	private ProcessElement process;
	
	/**  CXyN^JĂ邩ǂtO*/
	private boolean isInfoOpened;

	/**
	 * t[𐶐B
	 * 
	 * @param proc	vZX
	 */
	public ProcessDesignFrame(ProcessElement proc)
	{
		super("", true, true, true, true);

		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		setFrameIcon(IconManager.getIcon("process-frameicon"));
		
		this.process = proc;
		view = new ProcessDesignView(process);
		view.addProcessInfoActionListener(new ProcessInfoAction());
		view.addDividerActionListener(new DividerAction());

		inspectorView = new ActivityInspectorView();
		
		splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		splitPane.setLeftComponent(view);
		splitPane.setRightComponent(inspectorView);
		
		tabbedPane = new JTabbedPane();
		tabbedPane.addTab(rm.getResource("ProcessDesignFrame.tab.0"), splitPane);
		
		Container contentPane = this.getContentPane();
		BorderLayout layout = new BorderLayout();
		contentPane.setLayout(layout);
		contentPane.add(tabbedPane, BorderLayout.CENTER);

		setTitle(rm.getResource("ProcessDesignFrame.title"));
		setSize(new Dimension(800, 600));
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		addInternalFrameListener(
			new InternalFrameAdapter() {
				public void internalFrameOpened(InternalFrameEvent e) {
					opened();
				}

				public void internalFrameActivated(InternalFrameEvent e) {
					activated();
				}

				public void internalFrameDeactivated(InternalFrameEvent e) {
					deactivated();
				}

				public void internalFrameClosing(InternalFrameEvent e) {
					close();
				}
			}
		);
		this.validate();
	}

	/**
	 * vZXfUCr[ԂB
	 * 
	 * @return	vZXfUCr[
	 */
	public ProcessDesignView getView()
	{
		return view;
	}

	/**
	 * w肳ꂽvZXҏWĂ邩ǂԂB
	 * 
	 * @param proc	vZX
	 * @return	ҏWĂꍇɂtrue
	 */	
	public boolean isEditingProcess(ProcessElement proc)
	{
		return (this.process == proc);
	}

	/**
	 * w肳ꂽANeBreBp̃CXyN^ZbgB
	 * 
	 * @param act	ANeBreB
	 */	
	public void setInspector(ActivityElement act)
	{
		inspectorView.inspect(act);
	}

	/**
	 * CXyN^\B
	 */	
	public void showInspector()
	{
		splitPane.setDividerLocation(0.5d);
		isInfoOpened = true;
	}

	/**
	 * vZXԂB
	 * 
	 * @return	vZX
	 */
	public ProcessElement getProcess()
	{
		return process;
	}


	/**
	 * t[B
	 */
	void initialize()
	{
		ActivityElement selected = view.getProcessFlowView().getSelectedActivity();
		
		inspectorView.inspect(selected);
		
		isInfoOpened = false;
		splitPane.setDividerLocation(1.0d);
	}
	
	/**
	 * J̏
	 */
	void opened()
	{
		FlowDesignToolBar toolbar = WorkflowDesignerManager.getMainFrame().getToolbox().getToolBar();
		toolbar.addModeChangedListener(view);
	}
	
	/**
	 * ANeBuԂɂȂ̏
	 */
	void activated()
	{
		view.getProcessFlowView().notifyFrameIsActivated();
	}
	
	/**
	 * ANeBuԂɂȂ̏
	 */
	void deactivated()
	{
		view.getProcessFlowView().notifyFrameIsDeactivated();
	}
	
	/**
	 * 鎞̏
	 */
	void close()
	{
		FlowDesignToolBar toolbar = WorkflowDesignerManager.getMainFrame().getToolbox().getToolBar();
		toolbar.removeModeChangedListener(view);
		setVisible(false);
		dispose();
	}

	/**
	 * vZX{^ꂽꍇ̏
	 */
	class ProcessInfoAction implements ActionListener
	{
		/**
		 * vZXݒp̃CXyN^\B
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			InspectorDialog.showDialog(ProcessDesignFrame.this, process);
		}
	}

	/**
	 * CXyN^\{^ꂽꍇ̏
	 */
	class DividerAction implements ActionListener
	{
		/**
		 * ԂɉāACXyN^̕\Ɣ\؂ւB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			if (isInfoOpened) splitPane.setDividerLocation(1.0d);
			else splitPane.setDividerLocation(0.5d);
			isInfoOpened = (! isInfoOpened);
		}
	}
}
