/* $Id: ProcessFlowView.java,v 1.4 2005/08/26 04:50:19 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.Grid;
import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ActivityState;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;
import jp.co.argo21.nautica.tool.wfd.element.impl.ActivityElementImpl;
import jp.co.argo21.nautica.tool.wfd.element.impl.TransitionElementImpl;
import jp.co.argo21.nautica.tool.wfd.expression.ConditionalVariable;
import jp.co.argo21.nautica.tool.wfd.sim.SimulatableActivityWrapper;
import jp.co.argo21.nautica.tool.wfd.sim.SimulationListener;
import jp.co.argo21.nautica.tool.wfd.sim.SimurateManager;

/**
 * t[`pr[
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessFlowView
extends JComponent
implements MouseListener, MouseMotionListener, DropTargetListener, SimulationListener
{
	/** ҏWpA_v^\萔 */
	static public final int POINT_CONTROLLER    = 0;
	/** ڑpA_v^\萔 */
	static public final int CONNECT_CONTROLLER  = 1;
	/** V~[gpA_v^\萔 */
	static public final int SIMULATE_CONTROLLER = 2;

	/** ڑ[h\萔 */
	static public final int CMODE_CONNECT    = 0;
	/** ڑ[h\萔 */
	static public final int CMODE_DISCONNECT = 1;

	/** Obh\萔 */
	static public final int GRID_SIZE     = 80;
	/** ACRTCY\萔 */
	static private final int MAX_ICON_SIZE = 48;
	/** @\萔 */
	static private final int INSET_SIZE    = 9;
	/** ŏ_Pʐ\萔 */
	static private final int MIN_LOGICAL_WIDTH  = 10;
	/** ŏ_Pʐ\萔 */
	static private final int MIN_LOGICAL_HEIGHT = 10;

	/** C[̔wiF */
	static private final Color LAYER_BACKGROUND = new Color(230, 255, 255, 64);
	/** ڑ[h̔wiF */
	static private final Color CONNECTION_BACKGROUND = new Color(255, 255, 230);
	/** V~[V[h̔wiF */
	static private final Color SIMULATION_BACKGROUND = new Color(230, 255, 255);

	/** `ɎgptHg */
	static private final Font VIEW_FONT
		= new Font("MonoSpaced", Font.PLAIN, 10);

	/** p`pX */
	static private GeneralPath ARROW_PATH;

	/** hbvgpƂĂ`W */
	private Rectangle dropRect;
	/** J[\ʒű`W */
	private Rectangle cursorRect;
	/** I𒆂̋`W */
	private Rectangle selectedRect;

	/** I𒆂ActivityElement */
	private ActivityElement selectedActivity;
	/** ڑActivityElement */
	private ActivityElement sourceActivity;
	/** ݃V~[gΏۂƂȂĂSimulatableActivityWrapper */
	private List simulatedActivities = new ArrayList();
	/** ݑҋ@ƂȂĂSimulatableActivityWrapper */
	private Map waitActivities = new Hashtable();

	/** r[p̃Rg[ */
	private ProcessFlowViewController[] controllers;

	/** IĂRg[CfNX */
	private int controllerID = POINT_CONTROLLER;
	/** ݂̐ڑ */
	private int connectingMode = CMODE_CONNECT;

	/** ΏۂƂȂvZX */
	private ProcessElement proc;

	/** KwǗ郊Xg */
	private ConcurrentLayerManager root;

	/** V~[^ */
	private SimurateManager simulator;

	/**
	 * p`pX̏
	 */
	static
	{
		// p`pX̏
		ARROW_PATH = new GeneralPath(GeneralPath.WIND_EVEN_ODD);
		ARROW_PATH.moveTo(0, 0);
		ARROW_PATH.lineTo(15, 5);
		ARROW_PATH.lineTo(15, -5);
		ARROW_PATH.closePath();
	}

	/**
	 * t[`p̃r[𐶐B
	 * 
	 */
	public ProcessFlowView(ProcessElement proc)
	{
		this.proc = proc;
		int w = proc.getLogicalWidth();
		int h = proc.getLogicalHeight();

		if (w < MIN_LOGICAL_WIDTH) {
			w = MIN_LOGICAL_WIDTH;
			proc.setLogicalWidth(MIN_LOGICAL_WIDTH);
		} 
		if (h < MIN_LOGICAL_HEIGHT) {
			h = MIN_LOGICAL_HEIGHT;
			proc.setLogicalHeight(MIN_LOGICAL_HEIGHT);
		} 
		
		Dimension size = new Dimension(GRID_SIZE * w + 1, GRID_SIZE * h + 1);
		
		root = new ConcurrentLayerManager();
		root.initConcurrentLayer(proc.getActivities());
		
		simulator = new SimurateManager();
		
		controllers = new ProcessFlowViewController[3];
		controllers[0] = new PointerModeFlowViewController();
		controllers[1] = new ConnectionModeFlowViewController();
		controllers[2] = new SimulationModeFlowViewController();
			
		DropTarget dt = new DropTarget(this, this);
		setPreferredSize(size);
		setMinimumSize(size);
		addMouseListener(this);
		addMouseMotionListener(this);
	}

	/**
	 * t[\GA`悷B
	 *
	 * @param g `ΏۃOtBbNX
	 */
	public void paintComponent(Graphics g)
	{
		Shape clip = g.getClip();

		Dimension size = this.getSize();

		//`͈͈ȊO̔wi̕`
		g.setColor(Color.gray);
		g.fillRect(0, 0, size.width, size.height);

		Dimension psize = this.getPreferredSize();

		//`͈͂̔wi̕`
		if (getControllerID() == CONNECT_CONTROLLER) {
			g.setColor(CONNECTION_BACKGROUND);
		} else if (getControllerID() == SIMULATE_CONTROLLER) {
			g.setColor(SIMULATION_BACKGROUND);
		} else {
			g.setColor(Color.white);
		}
		g.fillRect(0, 0, psize.width, psize.height);

		//C[̔wi`
		root.paintLayerBackgroud(g, LAYER_BACKGROUND, GRID_SIZE);


		//I𒆂̃ANeBreB̕`
		if (selectedActivity != null) {
			paintActivityBackground(g, Color.pink, selectedActivity);
		}
		
		//V~[gΏۂ̃ANeBreB̔wi`
		if (getControllerID() == SIMULATE_CONTROLLER) {
			Iterator sait = simulatedActivities.iterator();
			while (sait.hasNext()) {
				SimulatableActivityWrapper sa = (SimulatableActivityWrapper)sait.next();
				if (sa != null) {
					paintActivityBackground(g, Color.green, sa.getActivity());
				}
			}
		}

		//r[̕`
		paintView(g);
						
		//J[\`̕`
		if (cursorRect != null) {
			g.drawRect(cursorRect.x, cursorRect.y, cursorRect.width, cursorRect.height);
		}

		//C[̘g`
		root.paintLayerBorder(g, Color.blue, GRID_SIZE);

		//hbv`̕`
		g.setColor(Color.red);
		if (dropRect != null) {
			g.drawRect(dropRect.x, dropRect.y, dropRect.width, dropRect.height);
		}

		//I𒆂̃ANeBreB̕`
		if (selectedRect != null) {
			g.setColor(Color.red);
			g.drawRect(selectedRect.x, selectedRect.y, selectedRect.width, selectedRect.height);
		}

		//V~[gΏۂ̑Jڕ`
		if (getControllerID() == SIMULATE_CONTROLLER) {
			Iterator sait = simulatedActivities.iterator();
			while (sait.hasNext()) {
				SimulatableActivityWrapper sa = (SimulatableActivityWrapper)sait.next();
				TransitionElement tr = sa.getTransition();
				if (tr != null) {
					paintTransition(g, Color.blue, tr.getSource(), tr.getDestination());
				}
			}
		}
			
		//ڑ̕`
		if (getControllerID() == CONNECT_CONTROLLER) {
			if (sourceActivity != null) {
				paintConnecting(g);
			}
		}

		g.setClip(clip);
		g.dispose();
	}

	/**
	 * t[\GA`悷B
	 * ͈ɂgpB
	 *
	 * @param g `ΏۃOtBbNX
	 */
	public void paintView(Graphics g)
	{
		Shape clip = g.getClip();

		g.setFont(VIEW_FONT);

		Dimension psize = this.getPreferredSize();

		//`͈͂̃Obh̕`
		Grid.draw(new Rectangle(psize), g, GRID_SIZE);
		g.clipRect(0, 0, psize.width, psize.height);

		g.setColor(Color.black);
			
		//ANeBreB̕`
		List acts = proc.getActivities();
		Iterator ait = acts.iterator();
		while (ait.hasNext()) {
			ActivityElement act = (ActivityElement)ait.next();
			paintActivity(g, act);
		}
			
		//Jڂ̕`
		List trs = proc.getTransitions();
		Iterator tit = trs.iterator();
		while (tit.hasNext()) {
			TransitionElement tr = (TransitionElement)tit.next();
			paintTransition(g, Color.black, tr.getSource(), tr.getDestination());
		}

		g.setClip(clip);
	}

	/**
	 * w肳ꂽANeBreBwi`悷B
	 * 
	 * @param g   `ΏۃOtBbNX
	 * @param c   `F
	 * @param act ANeBreB
	 */
	private void paintActivityBackground(Graphics g, Color c, ActivityElement act)
	{
		if (act == null) return;

		int ax = act.getLogicalX();
		int ay = act.getLogicalY();

		int x = GRID_SIZE * ax;
		int y = GRID_SIZE * ay;
		int w = GRID_SIZE;
		int h = GRID_SIZE;

		g.setColor(c);
		g.fillRect(x, y, w, h);
	}

	/**
	 * w肳ꂽANeBreB`悷B
	 * 
	 * @param g  `ΏۃOtBbNX
	 * @param act ANeBreB
	 */
	private void paintActivity(Graphics g, ActivityElement act)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		String name = act.getName();
		if (StringUtils.checkNull(name)) {
			name = rm.getResource("ProcessFlowView.noname");
		} 

		//ANeBreBACR̕`
		String type = act.getActivityState().getIconName();
		Icon icon = IconManager.getIcon(type.toString());

		int ax = act.getLogicalX();
		int ay = act.getLogicalY();

		int x = GRID_SIZE * ax;
		int y = GRID_SIZE * ay;
		int w = GRID_SIZE;
		int h = GRID_SIZE;

		int iconW = icon.getIconWidth();
		int iconH = icon.getIconHeight();
		int iconX = x + ((w - iconW) / 2);
		int iconY = y + 9;
		icon.paintIcon(this, g, iconX, iconY);

		//ANeBreB̕`
		FontMetrics metrics = g.getFontMetrics();
		int fontH = metrics.getHeight();
		int descent = metrics.getDescent();
		int lineW = metrics.stringWidth(name);
		int dx = x + ((w - lineW) / 2);
		int dy = y + 9 + iconH;
		if (dx < 0) dx = 0;
		dy = dy + fontH - descent;
		g.setColor(SystemColor.textText);
		g.drawString(name, dx, dy);
	}

	/**
	 * w肳ꂽANeBreBԂ̑Jڂ`悷B
	 * 
	 * @param g   `ΏۃOtBbNX
	 * @param c   `F
	 * @param src JڌANeBreB
	 * @param dst JڐANeBreB
	 */
	private void paintTransition(Graphics g, Color c, ActivityElement src, ActivityElement dst)
	{
		if (src == null) return;
		if (dst == null) return;

		int sx = src.getLogicalX();
		int sy = src.getLogicalY();
		int dx = dst.getLogicalX();
		int dy = dst.getLogicalY();

		Point sp = getSourcePoint(sx, sy, dx, dy);
		Point dp = getDestinationPoint(sx, sy, dx, dy);

		//Jڐ̕`
		paintArrowLine(g, c, sp.x, sp.y, dp.x, dp.y);
	}

	/**
	 * ڑ`悷B
	 *
	 * @param	g		`ΏۃOtBbNX
	 */
	private void paintConnecting(Graphics g)
	{
		if (controllerID != CONNECT_CONTROLLER) return;
		if (sourceActivity == null) return;
		if (cursorRect == null) return;

		int sx = sourceActivity.getLogicalX();
		int sy = sourceActivity.getLogicalY();
		int dx = cursorRect.x / GRID_SIZE;
		int dy = cursorRect.y / GRID_SIZE;

		if (getConnectingMode() == CMODE_CONNECT) {
			Point sp = getSourcePoint(sx, sy, dx, dy);
			Point dp = getDestinationPoint(sx, sy, dx, dy);
			paintArrowLine(g, Color.gray, sp.x, sp.y, dp.x, dp.y);
		} else {
			Point sp = getSourcePoint(sx, sy, dx, dy);
			Point dp = getDestinationPoint(sx, sy, dx, dy);
			paintCrossLine(g, Color.gray, sp.x, sp.y, dp.x, dp.y);
		}
	}

	/**
	 * `悷B
	 *
	 * @param g  `ΏۃOtBbNX
	 * @param c  `F
	 * @param sx JnXW
	 * @param sy JnYW
	 * @param dx IXW
	 * @param dy IYW
	 */
	private void paintArrowLine(Graphics g, Color c, int sx, int sy, int dx, int dy)
	{
		Graphics2D g2 = (Graphics2D)g;

		//݂̍Wϊsۑ
		AffineTransform tr = g2.getTransform();

		g2.setColor(c);
		g2.drawLine(sx, sy, dx, dy);

		//`
		g2.translate(dx, dy);
		double theta = Math.atan2(((double)(sy - dy)), ((double)(sx - dx)));
		g2.rotate(theta);
		g2.fill(ARROW_PATH);
		g2.draw(ARROW_PATH);

		g2.setTransform(tr);
	}

	/**
	 * ~t`悷B
	 *
	 * @param g  `ΏۃOtBbNX
	 * @param c  `F
	 * @param sx JnXW
	 * @param sy JnYW
	 * @param dx IXW
	 * @param dy IYW
	 */
	private void paintCrossLine(Graphics g, Color c, int sx, int sy, int dx, int dy)
	{
		paintArrowLine(g, c, sx, sy, dx, dy);

		Graphics2D g2 = (Graphics2D)g;

		Stroke stroke = g2.getStroke();

		g2.setStroke(new BasicStroke(3));
		int x = sx + ((dx - sx) / 2);
		int y = sy + ((dy - sy) / 2);
		g2.setColor(Color.red);
		g2.drawLine(x - 7, y - 7, x + 7, y + 7);
		g2.drawLine(x + 7, y - 7, x - 7, y + 7);

		g2.setStroke(stroke);
	}

	/**
	 * ڑ[hԂB
	 *
	 * @return ڑ[h(CMODE_CONNECT/CMODE_DISCONNECT)
	 */
	private int getConnectingMode()
	{
		return connectingMode;
	}

	/**
	 * ڑ[hݒ肷B
	 *
	 * @param mode ڑ[h(CMODE_CONNECT/CMODE_DISCONNECT)
	 */
	private void setConnectingMode(int mode)
	{
		connectingMode = mode;
	}

	/**
	 * ڑ̕`Jn_ZoB
	 *
	 * @param sx JnXW
	 * @param sy JnYW
	 * @param dx IXW
	 * @param dy IYW
	 * @return `Jn_
	 */
	private Point getSourcePoint(int sx, int sy, int dx, int dy)
	{
		int x = (sx * GRID_SIZE) + (GRID_SIZE / 2);
		int y = (sy * GRID_SIZE) + (GRID_SIZE / 2);
		if (sx < dx) {
			x = (sx * GRID_SIZE) + (GRID_SIZE - ((GRID_SIZE - MAX_ICON_SIZE) / 2));
			y = (sy * GRID_SIZE) + INSET_SIZE + (MAX_ICON_SIZE / 2);
		} else if (sx > dx) {
			x = (sx * GRID_SIZE) + ((GRID_SIZE - MAX_ICON_SIZE) / 2);
			y = (sy * GRID_SIZE) + INSET_SIZE + (MAX_ICON_SIZE / 2);
		} else {
			if (sy < dy) {
				y = (sy * GRID_SIZE) + GRID_SIZE - INSET_SIZE;
			} else if (sy > dy) {
				y = (sy * GRID_SIZE) + INSET_SIZE;
			}
		}
		return new Point(x, y);
	}

	/**
	 * ڑ̕`I_ZoB
	 *
	 * @param sx JnXW
	 * @param sy JnYW
	 * @param dx IXW
	 * @param dy IYW
	 * @return `I_
	 */
	private Point getDestinationPoint(int sx, int sy, int dx, int dy)
	{
		int x = (dx * GRID_SIZE) + (GRID_SIZE / 2);
		int y = (dy * GRID_SIZE) + (GRID_SIZE / 2);
		if (sx < dx) {
			x = (dx * GRID_SIZE) + ((GRID_SIZE - MAX_ICON_SIZE) / 2);
			y = (dy * GRID_SIZE) + INSET_SIZE + (MAX_ICON_SIZE / 2);
		} else if (sx > dx) {
			x = (dx * GRID_SIZE) + (GRID_SIZE - ((GRID_SIZE - MAX_ICON_SIZE) / 2));
			y = (dy * GRID_SIZE) + INSET_SIZE + (MAX_ICON_SIZE / 2);
		} else {
			if (sy < dy) {
				y = (dy * GRID_SIZE) + INSET_SIZE;
			} else if (sy > dy) {
				y = (dy * GRID_SIZE) + GRID_SIZE - INSET_SIZE;
			}
		}
		return new Point(x, y);
	}
		
	/**
	 * }EXJ[\̍WANeBreB肷B
	 * 
	 * @param mx }EXXW
	 * @param my }EXYW
	 * @return ANeBreB
	 */
	private ActivityElement getActivity(int mx, int my)
	{
		int lx = mx / GRID_SIZE;
		int ly = my / GRID_SIZE;

		List acts = proc.getActivities();
		Iterator it = acts.iterator();
		while (it.hasNext()) {
			ActivityElement a = (ActivityElement)it.next();
			int x = a.getLogicalX();
			int y = a.getLogicalY();
			if (x == lx && y == ly) {
				return a;
			}
		}
		return null;
	}
	
	/**
	 * ANeBreB̃hbvsB
	 * 
	 * @param name hbvꂽANeBreBږ
	 * @param mx }EXXW
	 * @param my }EXYW
	 * @return hbv̐
	 */
	private boolean dropActivity(String name, int mx, int my)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		if (checkDroppingName(name) == false) {
			DialogUtilities.showError(rm.getResource("message.error.0021"));
			return false;
		}

		Dimension psize = this.getPreferredSize();

		if ((mx >= psize.width) || (my >= psize.height)) {
			DialogUtilities.showError(rm.getResource("message.error.0022"));
			return false;
		}
	
		if (getActivity(mx, my) != null) {
			DialogUtilities.showError(rm.getResource("message.error.0023"));
			return false;
		}

		boolean result = addActivity(name, mx, my);

		this.repaint();
		return result;
	}
	
	/**
	 * ANeBreBǉB
	 * 
	 * @param name ANeBreBږ
	 * @param mx }EXXW
	 * @param my }EXYW
	 */
	private boolean addActivity(String name, int mx, int my)
	{
		if (name.equals(WorkflowDesignerConstants.PAL_CONCURRENT)) {
			return addConcurrenceActivity(name, mx, my);
		} else {
			return addGeneralActivity(name, mx, my);
		}
	}
	
	/**
	 * spANeBreBǉB
	 * 
	 * @param name ANeBreBږ
	 * @param mx }EXXW
	 * @param my }EXYW
	 */
	private boolean addConcurrenceActivity(String name, int mx, int my)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		int mx2 = mx + GRID_SIZE;

		Dimension psize = this.getPreferredSize();

		if ((mx2 >= psize.width) || (my >= psize.height)) {
			DialogUtilities.showError(rm.getResource("message.error.0024"));
			return false;
		}

		if (getActivity(mx2, my) != null) {
			DialogUtilities.showError(rm.getResource("message.error.0025"));
			return false;
		}

		int x1 = mx / GRID_SIZE;
		int y1 = my / GRID_SIZE;
		int x2 = mx2 / GRID_SIZE;
		int y2 = my / GRID_SIZE;
		
		ConcurrentLayer layer1 = root.getReceivableLayer(x1, y1);
		ConcurrentLayer layer2 = root.getReceivableLayer(x2, y2);
		
		if (layer1 != layer2) {
			DialogUtilities.showError(rm.getResource("message.error.0024"));
			return false;
		}
		
		ActivityState state1 = ActivityStateFactory.getInstance().createElement(ActivityElement.CONCUR_START);
		ActivityState state2 = ActivityStateFactory.getInstance().createElement(ActivityElement.CONCUR_END);
		if (state1 == null || state2 == null) return false;
		
		ActivityElement act1 = new ActivityElementImpl(state1);
		ActivityElement act2 = new ActivityElementImpl(state2);
		String blockID = IDGenerator.generate(ActivityElement.BLOCK_ID_PREFIX);
		act1.setBlockID(blockID);
		act2.setBlockID(blockID);

		ConcurrentLayer newLayer = new ConcurrentLayer(layer1, act1, act2);
		if (layer1 == null) root.addLayer(newLayer);
		else layer1.addLayer(newLayer);

		act1.setLogicalX(x1);
		act1.setLogicalY(y1);
		act2.setLogicalX(x2);
		act2.setLogicalY(y2);

		proc.getActivities().add(act1);
		proc.getActivities().add(act2);
		
		
		return true;
	}
	
	/**
	 * ʏANeBreBǉB
	 * 
	 * @param name ANeBreBږ
	 * @param mx }EXXW
	 * @param my }EXYW
	 */
	private boolean addGeneralActivity(String name, int mx, int my)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		ActivityState state = ActivityStateFactory.getInstance().createElementByPalette(name);
		if (state == null) return false;

		int x = mx / GRID_SIZE;
		int y = my / GRID_SIZE;
		
		ConcurrentLayer layer = root.getReceivableLayer(x, y);
		
		ActivityElement act = new ActivityElementImpl(state);
		act.setLogicalX(x);
		act.setLogicalY(y);

		if (layer != null) layer.addLayerElement(act);
		proc.getActivities().add(act);

		return true;
	}

	/**
	 * ANeBreB폜B
	 * 
	 * @param act ANeBreB
	 */
	private void removeActivity(ActivityElement act)
	{
		if (act == null) return;

		//폜Ώۂ̃ANeBreBɊ֘AJڂB
		List trs = proc.getTransitions();
		List tempTrs = new ArrayList();		
		Iterator tit = trs.iterator();
		while (tit.hasNext()) {
			TransitionElement tr = (TransitionElement)tit.next();
			if (tr.getSource() == act || tr.getDestination() == act) {
				tempTrs.add(tr);
			}
		}

		//폜Ώۂ̃ANeBreBɊ֘AJڂ폜B
		Iterator tempit = tempTrs.iterator();
		while (tempit.hasNext()) {
			trs.remove((TransitionElement)tempit.next());
		}

		//폜Ώۂ̃ANeBreB폜B
		List acts = proc.getActivities();
		acts.remove(act);
		selectedActivity = null;
		inspectSelectedActivity(false);
		
		repaint();
	}
	
	/**
	 * JnANeBreBԂB
	 * 
	 * @return	JnANeBreB
	 */
	private ActivityElement getStartActivity()
	{
		if (proc != null) {
			Iterator it = proc.getActivities().iterator();
			while (it.hasNext()) {
				ActivityElement act = (ActivityElement)it.next();
				if (act.getType().equals(ActivityElement.START)) {
					return act;
				}
			}
		}
		return null;
	}
		
	/**
	 * hbvꂽANeBreB`FbNB
	 * 
	 * @param name ANeBreB
	 * @return 茋
	 */
	private boolean checkDroppingName(String name)
	{
		if (name == null) return false;
		for (int i = 0; i < WorkflowDesignerConstants.DROPPABLE_ITEMS.length; i++) {
			if (WorkflowDesignerConstants.DROPPABLE_ITEMS[i].equals(name)) {
				return true;
			}
		}
		return false;
	}
		
	/**
	 * JڂǉB
	 * 
	 * @param src Jڌ̃ANeBreB
	 * @param dst Jڐ̃ANeBreB
	 */
	private void addTransition(ActivityElement src, ActivityElement dst)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		if (src == dst) {
			//gɂ͑Jڂ͒ȂBLẐ߁A_CAO͕svB
			return;
		}

		if (dst.getType().equals(ActivityElement.START)) {
			DialogUtilities.showError(rm.getResource("message.error.0032"));
			return;
		}

		List acts = proc.getActivities();
		Iterator it = acts.iterator();
		boolean existSrc = false;
		boolean existDst = false;
		while (it.hasNext()) {
			ActivityElement a = (ActivityElement)it.next();
			if (a == src) existSrc = true;
			else if (a == dst) existDst = true;
		}
		if (existSrc == false || existDst == false) {
			DialogUtilities.showError(rm.getResource("message.error.0033"));
			return;
		}

		//Ώۂ̃ANeBreBɊ֘AJڂB
		List trs = proc.getTransitions();
		Iterator tit = trs.iterator();
		while (tit.hasNext()) {
			TransitionElement tr = (TransitionElement)tit.next();
			if (tr.getSource() == src && tr.getDestination() == dst) {
				DialogUtilities.showError(rm.getResource("message.error.0034"));
				return;
			}
		}
		
		if (checkTransitionLayer(src, dst)) {
			TransitionElement newTr = new TransitionElementImpl(src, dst);
			trs.add(newTr);
		}
	}

	/**
	 * KwƑJڂ̃`FbNsB
	 * 
	 * @param src	JڌANeBreB
	 * @param dst	JڐANeBreB
	 * @return	Jډ\Ȃtrue
	 */
	private boolean checkTransitionLayer(ActivityElement src, ActivityElement dst)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		ConcurrentLayer layer1 = root.getContainLayer(src);
		ConcurrentLayer layer2 = root.getContainLayer(dst);

		if (layer1 == null && layer2 == null) {
		} else if (layer1 == null) {
			if (dst.getType().equals(ActivityElement.CONCUR_START)) {
				ConcurrentLayer pl = layer2.getParentLayer();
				if (pl != null) {
					DialogUtilities.showError(rm.getResource("message.error.0037"));
					return false;
				}
			} else {
				DialogUtilities.showError(rm.getResource("message.error.0036"));
				return false;
			}
		} else if (layer2 == null) {
			if (src.getType().equals(ActivityElement.CONCUR_END)) {
				ConcurrentLayer pl = layer1.getParentLayer();
				if (pl != null) {
					DialogUtilities.showError(rm.getResource("message.error.0037"));
					return false;
				}
			} else {
				DialogUtilities.showError(rm.getResource("message.error.0036"));
				return false;
			}
		} else if (layer1 != layer2) {
			if (dst.getType().equals(ActivityElement.CONCUR_START)) {		
				ConcurrentLayer pl = layer2.getParentLayer();
				if (pl != layer1) {
					DialogUtilities.showError(rm.getResource("message.error.0037"));
					return false;
				}
			} else if (src.getType().equals(ActivityElement.CONCUR_END)) {
				ConcurrentLayer pl = layer1.getParentLayer();
				if (pl != layer2) {
					DialogUtilities.showError(rm.getResource("message.error.0037"));
					return false;
				}
			} else {
				DialogUtilities.showError(rm.getResource("message.error.0036"));
				return false;
			}
		} else {
			if (dst.getType().equals(ActivityElement.CONCUR_START)) {		
				DialogUtilities.showError(rm.getResource("message.error.0038"));
				return false;
			} else if (src.getType().equals(ActivityElement.CONCUR_END)) {
				DialogUtilities.showError(rm.getResource("message.error.0039"));
				return false;
			}
		}
		return true;
	}
		
	/**
	 * Jڂ폜B
	 * 
	 * @param src Jڌ̃ANeBreB
	 * @param dst Jڐ̃ANeBreB
	 */
	private void removeTransition(ActivityElement src, ActivityElement dst)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		//Ώۂ̃ANeBreBɊ֘AJڂB
		List trs = proc.getTransitions();
		Iterator tit = trs.iterator();
		TransitionElement rmTr = null;
		while (tit.hasNext()) {
			TransitionElement tr = (TransitionElement)tit.next();
			if (tr.getSource() == src && tr.getDestination() == dst) {
				rmTr = tr;
				break;
			}
		}
		if (rmTr == null) {
			DialogUtilities.showError(rm.getResource("message.error.0035"));
			return;
		}
		trs.remove(rmTr);
	}

	/**
	 * KwƔzuʒũ`FbNsB
	 * 
	 * @param l	Kw
	 * @param elem	vf
	 * @param lx	_XW
	 * @param ly	_YW
	 * @return	zu\Ȃtrue
	 */	
	private boolean checkLocation(ConcurrentLayer l, ActivityElement elem, int lx, int ly)
	{
		if (l == null) return true;
		ActivityElement start = l.getStartElement();
		ActivityElement end = l.getEndElement();
		ConcurrentLayer parentLayer = l.getParentLayer();
		int sx = start.getLogicalX();
		int sy = start.getLogicalY();
		int ex = end.getLogicalX();
		int ey = end.getLogicalY();
		Point mup = l.getMinimumUpperPoint();
		Point mlp = l.getMinimumLowerPoint();
		if (lx == sx && ly == sy) return false;
		if (lx == ex && ly == ey) return false;
		
		if (elem == start) {
			if (parentLayer != null) {
				int psx = parentLayer.getStartElement().getLogicalX();
				int psy = parentLayer.getStartElement().getLogicalY();
				int pex = parentLayer.getEndElement().getLogicalX();
				int pey = parentLayer.getEndElement().getLogicalY();
				if (lx == psx && ly == psy) return false;
				if (lx == pex && ly == pey) return false;
				if (lx < psx || lx > ex) return false;
				if (ly < psy || ly > ey) return false;
			}
			if (lx > mup.x || ly > mup.y) return false;
		} else if (elem == end) {
			if (parentLayer != null) {
				int psx = parentLayer.getStartElement().getLogicalX();
				int psy = parentLayer.getStartElement().getLogicalY();
				int pex = parentLayer.getEndElement().getLogicalX();
				int pey = parentLayer.getEndElement().getLogicalY();
				if (lx == psx && ly == psy) return false;
				if (lx == pex && ly == pey) return false;
				if (lx < sx || lx > pex) return false;
				if (ly < sy || ly > pey) return false;
			}
			if (lx < mlp.x || ly < mlp.y) return false;
		} else {
			if (lx < sx || lx > ex) return false;
			if (ly < sy || ly > ey) return false;
		}
		return true;
	}

	/**
	 * ŏ̃r[TCYԂB
	 * 
	 * @return	TCY
	 */	
	private Dimension getMinimumViewSize()
	{
		int lw = MIN_LOGICAL_WIDTH;
		int lh = MIN_LOGICAL_HEIGHT;
		if (proc != null) {
			Iterator it = proc.getActivities().iterator();
			while (it.hasNext()) {
				ActivityElement act = (ActivityElement)it.next();
				if (act.getLogicalX() >= lw) lw = act.getLogicalX() + 1;
				if (act.getLogicalY() >= lh) lh = act.getLogicalY() + 1;
			}
		}
		return new Dimension(GRID_SIZE * lw + 1, GRID_SIZE * lh + 1);
	}

	/**
	 * ݂̃r[Rg[IDԂB
	 * 
	 * @return	r[Rg[ID
	 */
	public int getControllerID()
	{
		return controllerID;
	}

	/**
	 * r[Rg[IDݒ肷B
	 * 
	 * @param i	r[Rg[ID
	 */
	public void setControllerID(int i)
	{
		controllerID = i;
		setSelectedActivity(null);
		sourceActivity = null;
		selectedRect = null;
		setToolTipText(null);
		inspectSelectedActivity(false);
		simulatedActivities.clear();
		waitActivities.clear();
		if (getControllerID() == SIMULATE_CONTROLLER) {
			ActivityElement act = getStartActivity();
			if (act != null) simulatedActivities.add(new SimulatableActivityWrapper(act, null));
		}
		
		repaint();
	}

	/**
	 * IĂANeBreBԂB
	 * 
	 * @return	ANeBreB
	 */
	public ActivityElement getSelectedActivity()
	{
		return selectedActivity;
	}

	/**
	 * w肳ꂽANeBreBIԂɂB
	 * 
	 * @param element	ANeBreB
	 */
	public void setSelectedActivity(ActivityElement element)
	{
		WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
		
		selectedActivity = element;
		if (selectedActivity == null) {
			frame.setEnableCopyAction(false);
			frame.setEnableDeleteAction(false);
			return;
		} 

		String type = selectedActivity.getType();
		if (type.equals(ActivityElement.START)) {
			frame.setEnableCopyAction(false);
			frame.setEnableDeleteAction(false);
		} else if (type.equals(ActivityElement.CONCUR_START)
			|| type.equals(ActivityElement.CONCUR_END)
			|| type.equals(ActivityElement.END)) {
				frame.setEnableCopyAction(false);
				frame.setEnableDeleteAction(true);
		} else {
			frame.setEnableCopyAction(true);
			frame.setEnableDeleteAction(true);
		}
	}

	/**
	 * IĂANeBreB̃CXyN^[hB
	 * 
	 * @param withShowing	[hƓɕ\sꍇtrue
	 */
	public void inspectSelectedActivity(boolean withShowing)
	{
		DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
		ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
		if (frame == null) return;
		frame.setInspector(selectedActivity);
		if (withShowing) frame.showInspector();
	}

	/**
	 * t[ꍇ̏B
	 */	
	public void notifyFrameIsActivated()
	{
		setSelectedActivity(selectedActivity);
	}

	/**
	 * t[񊈐ꍇ̏B
	 */	
	public void notifyFrameIsDeactivated()
	{
		sourceActivity = null;
	}

	/**
	 * ҏWGAɈPʍLB
	 */
	public void expandWidth()
	{
		Dimension d = getPreferredSize();
		int newWidth = d.width + GRID_SIZE;
		d.setSize(newWidth, d.height);
		setPreferredSize(d);
		setSize(d);
		proc.setLogicalWidth(newWidth / GRID_SIZE);
		updateUI();
	}

	/**
	 * ҏWGAcɈPʍLB
	 */
	public void expandHeight()
	{
		Dimension d = getPreferredSize();
		int newHeight = d.height + GRID_SIZE;
		d.setSize(d.width, newHeight);
		setPreferredSize(d);
		setSize(d);
		proc.setLogicalHeight(newHeight / GRID_SIZE);
		updateUI();
	}

	/**
	 * ҏWGAɈPʏk߂B
	 */
	public void reduceWidth()
	{
		Dimension d = getPreferredSize();
		Dimension md = getMinimumViewSize();
		
		int newWidth = d.width - GRID_SIZE;
		if (newWidth >= md.width) {
			d.setSize(newWidth, d.height);
			setPreferredSize(d);
			setSize(d);
			proc.setLogicalWidth(newWidth / GRID_SIZE);
			updateUI();
		}
	}

	/**
	 * ҏWGAcɈPʏk߂B
	 */
	public void reduceHeight()
	{
		Dimension d = getPreferredSize();
		Dimension md = getMinimumViewSize();
		int newHeight = d.height - GRID_SIZE;
		if (newHeight >= md.height) {
			d.setSize(d.width, newHeight);
			setPreferredSize(d);
			setSize(d);
			proc.setLogicalHeight(newHeight / GRID_SIZE);
			updateUI();
		}
	}

	/**
	 * ANeBreB؂菈B
	 */
	public void cut()
	{
		if (selectedActivity == null) return;
		
		WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
		if (frame.getEnableCopyAction() == false) return;

		frame.setPastable(selectedActivity);
		delete();
		repaint();
	}

	/**
	 * ANeBreBRs[B
	 */
	public void copy()
	{
		if (selectedActivity == null) return;

		WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
		if (frame.getEnableCopyAction() == false) return;

		Element pastable = selectedActivity.copy();
		frame.setPastable(pastable);
		repaint();
	}

	/**
	 * ANeBreBy[XgB
	 */
	public void paste()
	{
		if (selectedRect == null) return;

		WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
		if (frame.getEnablePasteAction() == false) return;

		Element pastable = frame.getPastable();
		
		if (pastable == null) return;
		
		if (pastable instanceof ActivityElement) {
			ActivityElement act = (ActivityElement)pastable;
			int lx = selectedRect.x / ProcessFlowView.GRID_SIZE;
			int ly = selectedRect.y / ProcessFlowView.GRID_SIZE;
			act.setLogicalX(lx);
			act.setLogicalY(ly);
			proc.addActivity(act);
			setSelectedActivity(act);
			ConcurrentLayer layer = root.getReceivableLayer(lx, ly);
			if (layer != null) layer.addLayerElement(act);
			frame.setPastable(null);
		}
		repaint();
	}

	/**
	 * ANeBreB폜B
	 */
	public void delete()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		WorkflowDesignerFrame frame = WorkflowDesignerManager.getMainFrame();
		if (frame.getEnableDeleteAction() == false) return;

		if (selectedActivity == null) return;
		
		String type = selectedActivity.getType();
		if (type.equals(ActivityElement.CONCUR_START)
			|| type.equals(ActivityElement.CONCUR_END)) {
				int result = DialogUtilities.showOkCancelConfirm(rm.getResource("message.confirm.0001"));
				if (result != JOptionPane.OK_OPTION) return;
				
				ConcurrentLayer l = root.getContainLayer(selectedActivity);
				List temp = new ArrayList();
				l.collectAllLayerElement(temp);
				Iterator tit = temp.iterator();
				while (tit.hasNext()) {
					ActivityElement e = (ActivityElement)tit.next();
					removeActivity(e);
				}
				root.removeLayer(l);
		} else {
			root.removeLayerElement(selectedActivity);
		}
		
		removeActivity(selectedActivity);
		setSelectedActivity(null);
		repaint();
	}

	/*
	 * C^tF[XSimulationListener
	 */
	/**
	 * V~[VJnꂽƂ𔽉fB
	 * 
	 * @param act	ANeBreBbp[
	 * @see jp.co.argo21.nautica.tool.wfd.sim.SimulationListener#simulationStarted(jp.co.argo21.nautica.tool.wfd.sim.SimulatableActivityWrapper)
	 */
	public void simulationStarted(SimulatableActivityWrapper act)
	{
		repaint();
	}

	/**
	 * V~[ViWƂ𔽉fB
	 * 
	 * @param sa	ANeBreBbp[
	 * @param trs	V~[ǧʁAFꂽJڈꗗ
	 * @see jp.co.argo21.nautica.tool.wfd.sim.SimulationListener#simulationProgressed(jp.co.argo21.nautica.tool.wfd.sim.SimulatableActivityWrapper, java.util.List)
	 */
	public void simulationProgressed(SimulatableActivityWrapper sa, List trs)
	{
		if (trs == null) return;

		simulatedActivities.remove(sa);
		Iterator tit = trs.iterator();
		while (tit.hasNext()) {
			TransitionElement tr = (TransitionElement)tit.next();
			ActivityElement act = tr.getDestination();
			
			boolean hasBlockElement = false;
			SimulatableActivityWrapper top = null;
			if (act.getType().equals(ActivityElement.CONCUR_END)) {
				top = sa.peekTopBlockWrapper();
				hasBlockElement = checkHasBlockElement(top);
			}
			
			SimulatableActivityWrapper newSimact
				= new SimulatableActivityWrapper(act, tr, sa.getBlockStack());
			if (hasBlockElement) {
				waitActivities.put(newSimact, top);
			}
			simulatedActivities.add(newSimact);
		}

		repaint();
	}

	/**
	 * ANeBreBbp[ubNĂ邩ǂԂB
	 * 
	 * @param sa	ANeBreBbp[
	 * @return	ꍇɂ́Atrue
	 */	
	private boolean checkHasBlockElement(SimulatableActivityWrapper sa)
	{
		Iterator sait = simulatedActivities.iterator();
		while (sait.hasNext()) {
			SimulatableActivityWrapper w = (SimulatableActivityWrapper)sait.next();
			if (w.searchBlockWrapper(sa) > -1) return true;
		}
		return false;
	}

	/**
	 * w肳ꂽANeBreBbp[ɑ΂ubN폜B
	 * 
	 * @param bk	ubNANeBreBbp[
	 * @param act	ANeBreBbp[
	 */	
	private void removeBlock(SimulatableActivityWrapper bk, SimulatableActivityWrapper act)
	{
		Set wset = waitActivities.entrySet();
		Iterator wit = wset.iterator();
		while (wit.hasNext()) {
			Map.Entry entry = (Map.Entry)wit.next();
			if (entry.getValue() == bk) {
				waitActivities.remove(entry.getKey());
			}
		}
		List temp = new ArrayList();
		Iterator sait = simulatedActivities.iterator();
		while (sait.hasNext()) {
			SimulatableActivityWrapper w = (SimulatableActivityWrapper)sait.next();
			if (w  == act) continue;
			else if (w.getActivity() == act.getActivity()) temp.add(w);
		}
		Iterator tempit = temp.iterator();
		while (tempit.hasNext()) {
			SimulatableActivityWrapper w = (SimulatableActivityWrapper)tempit.next();
			simulatedActivities.remove(w);
		}
		
	}

	/**
	 * V~[VƂ𔽉fB
	 * 
	 * @param act	ANeBreBbp[
	 * @see jp.co.argo21.nautica.tool.wfd.sim.SimulationListener#simulationFinished(jp.co.argo21.nautica.tool.wfd.sim.SimulatableActivityWrapper)
	 */
	public void simulationFinished(SimulatableActivityWrapper act)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		DialogUtilities.showInfo(rm.getResource("message.info.0001"));
		repaint();
	}

	/**
	 * V~[VfꂽƂ𔽉fB
	 * 
	 * @param act	ANeBreBbp[
	 * @see jp.co.argo21.nautica.tool.wfd.sim.SimulationListener#simulationTerminated(jp.co.argo21.nautica.tool.wfd.sim.SimulatableActivityWrapper)
	 */
	public void simulationTerminated(SimulatableActivityWrapper act)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		DialogUtilities.showInfo(rm.getResource("message.info.0002"));
		repaint();
	}

	/*
	 * C^tF[XMouseListener
	 */
	/**
	 * }EXNbN𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
	 */
	public void mouseClicked(MouseEvent e)
	{
		controllers[controllerID].mouseClicked(e);
	}

	/**
	 * }EX𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
	 */
	public void mousePressed(MouseEvent e)
	{
		controllers[controllerID].mousePressed(e);
	}

	/**
	 * }EX̉𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
	 */
	public void mouseReleased(MouseEvent e)
	{
		controllers[controllerID].mouseReleased(e);
	}

	/**
	 * }EX̐N𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseEntered(java.awt.event.MouseEvent)
	 */
	public void mouseEntered(MouseEvent e)
	{
		controllers[controllerID].mouseEntered(e);
	}

	/**
	 * }EX̒Eo𔻒肷B
	 *
	 * @param e }EXCxg
	 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
	 */
	public void mouseExited(MouseEvent e)
	{
		controllers[controllerID].mouseExited(e);
	}

	/**
	 * }EXhbO𔻒肷B
	 *
	 * @param	e		}EXCxg
	 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
	 */
	public void mouseDragged(MouseEvent e)
	{
		controllers[controllerID].mouseDragged(e);
	}

	/**
	 * }EXړ𔻒肷B
	 *
	 * @param	e		}EXCxg
	 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
	 */
	public void mouseMoved(MouseEvent e)
	{
		controllers[controllerID].mouseMoved(e);
	}

	/**
	 * hbOr[ɓꍇɌĂ΂B
	 * 
	 * @param e DropTargetDragEvent
	 * @see java.awt.dnd.DropTargetListener#dragEnter(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dragEnter(DropTargetDragEvent e)
	{
		e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);
	}

	/**
	 * hbOr[oꍇɌĂ΂B
	 * 
	 * @param e DropTargetEvent
	 * @see java.awt.dnd.DropTargetListener#dragExit(java.awt.dnd.DropTargetEvent)
	 */
	public void dragExit(DropTargetEvent e)
	{
		dropRect = null;
		repaint();
	}

	/**
	 * hbOr[ɂꍇɌĂ΂B
	 * 
	 * @param e DropTargetDragEvent
	 * @see java.awt.dnd.DropTargetListener#dragOver(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dragOver(DropTargetDragEvent e)
	{
		try {
			DataFlavor[] flavors = e.getCurrentDataFlavors();
			if (flavors == null) return;
			if (flavors.length != 1) return;
			DataFlavor df = flavors[0];
			if (df == null) return;

			if (df.getPrimaryType().equals(WorkflowDesignerConstants.PTYPE)
				&& df.getSubType().equals(WorkflowDesignerConstants.STYPE_ACTIVITY_ITEM)) {
				Point location = e.getLocation();
				Dimension psize = this.getPreferredSize();
				if ((location.x >= psize.width) || (location.y >= psize.height)) {
					dropRect = null;
					repaint();
					return;
				}
				int x = location.x / GRID_SIZE;
				int y = location.y / GRID_SIZE;
					
				if (dropRect == null) {
					dropRect = new Rectangle(GRID_SIZE, GRID_SIZE);
				} 
				dropRect.x = x * GRID_SIZE;
				dropRect.y = y * GRID_SIZE;
				repaint();
			}
		} catch (Exception ex) {
		}
	}

	/**
	 * hbvsꂽƂɌĂ΂B
	 * 
	 * @param e DropTargetDropEvent
	 * @see java.awt.dnd.DropTargetListener#drop(java.awt.dnd.DropTargetDropEvent)
	 */
	public void drop(DropTargetDropEvent e)
	{
		e.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);

		try {
			boolean invalid = false;
			Transferable t = e.getTransferable();
			if (t == null) invalid = true;
			DataFlavor[] flavors = t.getTransferDataFlavors();
			if (flavors == null) invalid = true;
			if (flavors.length != 1) invalid = true;
			DataFlavor df = flavors[0];
			if (df == null) invalid = true;
			if (df.getPrimaryType().equals(WorkflowDesignerConstants.PTYPE) == false
				|| df.getSubType().equals(WorkflowDesignerConstants.STYPE_ACTIVITY_ITEM) == false) {
				invalid = true;
			}

			if (invalid) {
				e.dropComplete(false);
				return;
			}

			String s = df.getHumanPresentableName();
			Point location = e.getLocation();
			dropActivity(s, location.x, location.y);

			e.dropComplete(true);
		} catch (Exception ex) {
			e.dropComplete(false);
		} finally {
			dropRect = null;
		}
	}

	/**
	 * hbvANV؂ւƂɌĂ΂B
	 * gp
	 * 
	 * @param e DropTargetDragEvent
	 * @see java.awt.dnd.DropTargetListener#dropActionChanged(java.awt.dnd.DropTargetDragEvent)
	 */
	public void dropActionChanged(DropTargetDragEvent e) { /* nop */ }

	/**
	 * r[Rg[̋ʃX[p[NXB
	 */
	class ProcessFlowViewController extends MouseAdapter
	implements MouseMotionListener
	{
		/**
		 * }EXhbOsꂽƂɌĂ΂B
		 * 
		 * @param e	}EXCxg
		 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
		 */
		public void mouseDragged(MouseEvent e) { /* NOP */ }
		
		/**
		 * }EXړsꂽƂɌĂ΂B
		 * 
		 * @param e	}EXCxg
		 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
		 */
		public void mouseMoved(MouseEvent e) { /* NOP */ }
	}

	/**
	 * ҏW[hp̃r[Rg[B
	 */
	public class PointerModeFlowViewController
	extends ProcessFlowViewController
	{
		/**
		 * }EXNbN𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
		 */
		public void mouseClicked(MouseEvent e)
		{
			if (e.getClickCount() >= 2) {
				inspectSelectedActivity(true);
			}
		}

		/**
		 * }EX𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mousePressed(java.awt.event.MouseEvent)
		 */
		public void mousePressed(MouseEvent e)
		{
			int mx = e.getX();
			int my = e.getY();
			int lx = mx / ProcessFlowView.GRID_SIZE;
			int ly = my / ProcessFlowView.GRID_SIZE;

			if (selectedRect == null) {
				selectedRect = new Rectangle(
							   ProcessFlowView.GRID_SIZE,
							   ProcessFlowView.GRID_SIZE
							   );
			} 
			selectedRect.x = lx * ProcessFlowView.GRID_SIZE;
			selectedRect.y = ly * ProcessFlowView.GRID_SIZE;

			setSelectedActivity(getActivity(mx, my));
		}

		/**
		 * }EX̉𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseReleased(java.awt.event.MouseEvent)
		 */
		public void mouseReleased(MouseEvent e)
		{
			int mx = e.getX();
			int my = e.getY();
			int lx = mx / ProcessFlowView.GRID_SIZE;
			int ly = my / ProcessFlowView.GRID_SIZE;

			if (selectedRect == null) {
				selectedRect = new Rectangle(
							   ProcessFlowView.GRID_SIZE,
							   ProcessFlowView.GRID_SIZE
							   );
			} 
			selectedRect.x = lx * ProcessFlowView.GRID_SIZE;
			selectedRect.y = ly * ProcessFlowView.GRID_SIZE;
			inspectSelectedActivity(false);
			repaint();
		}

		/**
		 * }EX̒Eo𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
		 */
		public void mouseExited(MouseEvent e)
		{
			cursorRect = null;
			repaint();
		}

		/**
		 * }EXhbO𔻒肷B
		 *
		 * @param	e		}EXCxg
		 * @see java.awt.event.MouseMotionListener#mouseDragged(java.awt.event.MouseEvent)
		 */
		public void mouseDragged(MouseEvent e)
		{
			if (selectedActivity == null) return;
			int mx = e.getX();
			int my = e.getY();
			int ax = selectedActivity.getLogicalX();
			int ay = selectedActivity.getLogicalY();
			Dimension psize = ProcessFlowView.this.getPreferredSize();

			if (mx < 0) mx = 0;
			if (my < 0) my = 0;
			if (mx >= psize.width) mx = psize.width - ProcessFlowView.GRID_SIZE;
			if (my >= psize.height) my = psize.height - ProcessFlowView.GRID_SIZE;
			int lx = mx / ProcessFlowView.GRID_SIZE;
			int ly = my / ProcessFlowView.GRID_SIZE;
			
			//ړꏊɃANeBreBꍇ́AړȂB
			ActivityElement elem = getActivity(mx, my);
			if (elem != null) return;
			
			ConcurrentLayer layer = root.getContainLayer(selectedActivity);
			
			
			if (checkLocation(layer, selectedActivity, lx, ly) == false) return;
			
			if (ax != lx) selectedActivity.setLogicalX(lx);
			if (ay != ly) selectedActivity.setLogicalY(ly);

			if (selectedRect == null) {
				selectedRect = new Rectangle(
							   ProcessFlowView.GRID_SIZE,
							   ProcessFlowView.GRID_SIZE
							   );
			} 
			selectedRect.x = lx * ProcessFlowView.GRID_SIZE;
			selectedRect.y = ly * ProcessFlowView.GRID_SIZE;

			if (cursorRect == null) {
				cursorRect = new Rectangle(
								 ProcessFlowView.GRID_SIZE,
								 ProcessFlowView.GRID_SIZE
								 );
			} 
			cursorRect.x = lx * ProcessFlowView.GRID_SIZE;
			cursorRect.y = ly * ProcessFlowView.GRID_SIZE;
			
			repaint();
		}

		/**
		 * }EXړ𔻒肷B
		 *
		 * @param	e		}EXCxg
		 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
		 */
		public void mouseMoved(MouseEvent e)
		{
			int mx = e.getX();
			int my = e.getY();
			Dimension psize = ProcessFlowView.this.getPreferredSize();

			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			Element elem = getActivity(mx, my);
			if (elem == null) {
				setToolTipText(null);
			} else {
				setToolTipText(elem.getTooltipText(rm));
			} 

			if ((mx >= psize.width) || (my >= psize.height)) {
				cursorRect = null;
				repaint();
				return;
			}
			int lx = mx / ProcessFlowView.GRID_SIZE;
			int ly = my / ProcessFlowView.GRID_SIZE;
					
			if (cursorRect == null) {
				cursorRect = new Rectangle(
								 ProcessFlowView.GRID_SIZE,
								 ProcessFlowView.GRID_SIZE
								 );
			} 
			cursorRect.x = lx * ProcessFlowView.GRID_SIZE;
			cursorRect.y = ly * ProcessFlowView.GRID_SIZE;
			repaint();
		}
	}

	/**
	 * ڑ[h̃r[Rg[B
	 */
	public class ConnectionModeFlowViewController
	extends ProcessFlowViewController
	{
		/**
		 * }EXNbN𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
		 */
		public void mouseClicked(MouseEvent e)
		{
			if (sourceActivity == null) {
				sourceActivity = getActivity(e.getX(), e.getY());
				if (sourceActivity == null) {
					// nop
				} else if (sourceActivity.getType().equals(ActivityElement.END)) {
					sourceActivity = null;
				} else {
					if (e.isControlDown()) {
						setConnectingMode(CMODE_DISCONNECT);
					} else {
						setConnectingMode(CMODE_CONNECT);
					}
				}
			} else {
				ActivityElement dst
					= getActivity(e.getX(), e.getY());
				if (dst != null) {
					dst.getID();
					if (connectingMode == CMODE_DISCONNECT) {
						removeTransition(sourceActivity, dst);
					} else {
						addTransition(sourceActivity, dst);
					}
				}
				sourceActivity = null;
			}
			repaint();
		}

		/**
		 * }EX̒Eo𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseExited(java.awt.event.MouseEvent)
		 */
		public void mouseExited(MouseEvent e)
		{
			cursorRect = null;
			dropRect = null;
			repaint();
		}

		/**
		 * }EXړ𔻒肷B
		 *
		 * @param	e		}EXCxg
		 * @see java.awt.event.MouseMotionListener#mouseMoved(java.awt.event.MouseEvent)
		 */
		public void mouseMoved(MouseEvent e)
		{
			int mx = e.getX();
			int my = e.getY();
			Dimension psize = ProcessFlowView.this.getPreferredSize();

			if ((mx >= psize.width) || (my >= psize.height)) {
				cursorRect = null;
				repaint();
				return;
			}
			int lx = mx / ProcessFlowView.GRID_SIZE;
			int ly = my / ProcessFlowView.GRID_SIZE;
					
			if (cursorRect == null) {
				cursorRect = new Rectangle(
								 ProcessFlowView.GRID_SIZE,
								 ProcessFlowView.GRID_SIZE
								 );
			} 
			cursorRect.x = lx * ProcessFlowView.GRID_SIZE;
			cursorRect.y = ly * ProcessFlowView.GRID_SIZE;
			repaint();
		}
	}

	/**
	 * V~[g[h̃r[Rg[B
	 */
	public class SimulationModeFlowViewController
	extends ProcessFlowViewController
	{
		/**
		 * }EXNbN𔻒肷B
		 *
		 * @param e }EXCxg
		 * @see java.awt.event.MouseListener#mouseClicked(java.awt.event.MouseEvent)
		 */
		public void mouseClicked(MouseEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			if (e.getClickCount() >= 2) {
				int mx = e.getX();
				int my = e.getY();
				ActivityElement act = getActivity(mx, my);
				if (act == null) return;
				
				SimulatableActivityWrapper simact = null;
				Iterator sait = simulatedActivities.iterator();
				while (sait.hasNext()) {
					SimulatableActivityWrapper sa = (SimulatableActivityWrapper)sait.next();
					if (sa.getActivity() == act) {
						simact = sa;
						break;
					}
				}
				if (simact != null) {
					if (waitActivities.containsKey(simact)) {
						SimulatableActivityWrapper top
							= (SimulatableActivityWrapper)waitActivities.get(simact);
						if (checkHasBlockElement(top)) {
							DialogUtilities.showWarning(rm.getResource("message.warn.0201"));
							return;
						}
						removeBlock(top, simact);
					}
					PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
					List vars = makeConditionalVariables(pkg.getVariables());
					if (act == getStartActivity()) {
						simulator.start(ProcessFlowView.this, vars, proc, simact);
					} else {
						simulator.simulate(simact);
					}
				}
			}
		}

		/**
		 * vZXϐϐ쐬B
		 * 
		 * @param vars	vZXϐꗗ
		 * @return	ϐꗗ
		 */			
		private List makeConditionalVariables(List vars)
		{
			List result = new ArrayList();
			Iterator it = vars.iterator();
			while (it.hasNext()) {
				VariableElement var = (VariableElement)it.next();
				ConditionalVariable cvar = new ConditionalVariable(var);
				result.add(cvar);
			}
			return result;
		}
	}
}

