/* $Id: ResizingCorner.java,v 1.3 2005/08/26 04:50:23 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

/**
 * R[i[̃TCY{^B
 * 傫ɉă{^C[WB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ResizingCorner extends JComponent
{
	/** 萔 */
	static public final int TOP    = SwingConstants.TOP;
	/** 萔 */
	static public final int LEFT   = SwingConstants.LEFT;
	/** E萔 */
	static public final int RIGHT  = SwingConstants.RIGHT;
	/** 萔 */
	static public final int BOTTOM = SwingConstants.BOTTOM;

	/** ̘g */
	static private final Border L_BORDER
		= BorderFactory.createBevelBorder(BevelBorder.LOWERED, Color.CYAN, Color.BLACK);
	/** ʏ펞̘g */
	static private final Border R_BORDER
		= BorderFactory.createBevelBorder(BevelBorder.RAISED, Color.CYAN, Color.BLACK);

	/** Xi[ꗗǗp */
	private List listeners = new ArrayList();
	/**  */
	private int orientation = RIGHT;
	/** Ă邩ǂ\tO */
	private boolean pushing;

	/**
	 * TCY{^𐶐B
	 * 
	 * @param orientation 
	 */
	public ResizingCorner(int orientation)
	{
		this.orientation = orientation;
		addMouseListener(
			new MouseAdapter() {
				public void mouseClicked(MouseEvent e) {
					ActionEvent event = new ActionEvent(e.getSource(), e.getID(), e.paramString());
					int count = listeners.size();
					for (int i = 0; i < count; i++) {
						ActionListener l = (ActionListener)listeners.get(i);
						l.actionPerformed(event);
					}
				}
				public void mousePressed(MouseEvent e) {
					pushing = true;
					repaint();
				}
				public void mouseReleased(MouseEvent e) {
					pushing = false;
					repaint();
				}
				public void mouseExited(MouseEvent e) {
					pushing = false;
					repaint();
				}
			}
		);
	}

	/**
	 * ACR\GA`悷B
	 *
	 * @param g `ΏۃOtBbNX
	 */
	public void paintComponent(Graphics g)
	{
		Dimension size = getSize();

		g.setColor(Color.BLUE);
		g.fillRect(0, 0, size.width, size.height);

		Border border;
		if (pushing) border = L_BORDER;
		else border = R_BORDER;
		border.paintBorder(this, g, 0, 0, size.width, size.height);

		Polygon polygon = null;
		int t = 3;
		int m = size.height / 2;
		int b = size.height - 4;
		int l = 3;
		int c = size.width / 2;
		int r = size.width - 4;
		
		if (orientation == TOP) {
			int[] x = {l, c, r, l};
			int[] y = {b, t, b, b};
			polygon = new Polygon(x, y, 4);
		} else if (orientation == LEFT) {
			int[] x = {r, l, r, r};
			int[] y = {t, m, b, t};
			polygon = new Polygon(x, y, 4);
		} else if (orientation == RIGHT) {
			int[] x = {l, r, l, l};
			int[] y = {t, m, b, t};
			polygon = new Polygon(x, y, 4);
		} else if (orientation == BOTTOM) {
			int[] x = {l, c, r, l};
			int[] y = {t, b, t, t};
			polygon = new Polygon(x, y, 4);
		}

		if (polygon != null) {
			g.setColor(Color.YELLOW);
			g.fillPolygon(polygon);
			g.setColor(Color.GREEN);
			g.drawPolygon(polygon);
		} 

		g.dispose();			
	}

	/**
	 * ANVXi[ǉB
	 * 
	 * @param l Xi[
	 */
	public void addActionListener(ActionListener l)
	{
		if (listeners.contains(l) == false) listeners.add(l);
	}

	/**
	 * ANVXi[폜B
	 * 
	 * @param l Xi[
	 */
	public void removeActionListener(ActionListener l)
	{
		if (listeners.contains(l)) listeners.remove(l);
	}
}
