/* $Id: Ruler.java,v 1.3 2005/08/26 04:50:21 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2004.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

/**
 * [\ʃR|[lgBc\Ɖ\\łB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class Ruler extends JComponent
{
	/** \w萔 */
	static public final int HORIZONTAL = SwingConstants.HORIZONTAL;
	/** c\w萔 */
	static public final int VERTICAL = SwingConstants.VERTICAL;

	/** l`ptHg */
	static private final Font NUM_FONT
		= new Font("MonoSpaced", Font.PLAIN, 10);

	/** g */
	static private final Border border = BorderFactory.createRaisedBevelBorder();

	/** ` */
	private int orientation = HORIZONTAL;
	/** [P */
	private int unit = 100;

	/**
	 * [𐶐B
	 * orientationɂ́AHORIZONTAL܂VERTICALw肷B
	 * ftHgHORIZONTALB
	 * unit̃ftHg100B
	 * 
	 * @param orientation 
	 * @param unit P
	 */
	public Ruler(int orientation, int unit)
	{
		this.orientation = orientation;
		this.unit = unit;
		setPreferredSize(new Dimension(15, 15));
	}

	/**
	 * [`悷B
	 * 
	 * @param g OtBbNX
	 */
	public void paintComponent(Graphics g)
	{
		Dimension size = getSize();

		g.setFont(NUM_FONT);
		FontMetrics metrics = g.getFontMetrics();
		int fontH = metrics.getHeight();
		int descent = metrics.getDescent();
		g.setColor(Color.black);

		if (orientation == VERTICAL) {
			for (int i = 0; i < size.height; i++) {
				int y = i * unit;
				border.paintBorder(this, g, 0, y, size.width, unit);

				String num = "" + (i + 1);
				int lineW = metrics.stringWidth(num);
				int dx = (size.width - lineW) / 2;
				int dy = y + ((unit - fontH) / 2) + fontH - descent;
				g.drawString(num, dx, dy);
			}
		} else {
			int dy = ((size.height - fontH) / 2) + fontH - descent;
			for (int i = 0; i < size.width; i++) {
				int x = i * unit;
				border.paintBorder(this, g, x, 0, unit, size.height);

				String num = "" + (i + 1);
				int lineW = metrics.stringWidth(num);
				int dx = x + ((unit - lineW) / 2);
				g.drawString(num, dx, dy);
			}
		}
		g.dispose();
	}
}
