/* $Id: TabbedToolBox.java,v 1.3 2005/08/26 04:50:14 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.util.ArrayList;

import javax.swing.JTabbedPane;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;

/**
 * c[{bNX
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class TabbedToolBox extends JTabbedPane 
{
	/** c[o[^u */
	static public final int TAB_TOOLBAR = 0;
	/** [Nt[Q҃^u */
	static public final int TAB_PARTICIPANT = 1;
	/** AvP[V^u */
	static public final int TAB_APPLICATION = 2;
	/** vZXϐ^u */
	static public final int TAB_VARIABLE = 3;
	/** vZX^u */
	static public final int TAB_PROCESS = 4;

	/** c[o[ */
	private FlowDesignToolBar toolBar;
	/** [Nt[Qҕ\Xg */
	private ElementList participantList;
	/** AvP[V\Xg */
	private ElementList applicationList;
	/** vZXϐ\Xg */
	private ElementList variableList;
	/** vZX\Xg */
	private ElementList processList;

	/**
	 * c[{bNX𐶐A
	 */
	public TabbedToolBox()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		toolBar = new FlowDesignToolBar();
		addTab(rm.getResource("TabbedToolBox.tab.0"), toolBar);
		participantList = new ElementList(new ArrayList(), WorkflowDesignerConstants.EL_PARTICIPANT);
		addTab(rm.getResource("TabbedToolBox.tab.1"), participantList);
		applicationList = new ElementList(new ArrayList(), WorkflowDesignerConstants.EL_APPLICATION);
		addTab(rm.getResource("TabbedToolBox.tab.2"), applicationList);
		variableList = new ElementList(new ArrayList(), WorkflowDesignerConstants.EL_VARIABLE);
		addTab(rm.getResource("TabbedToolBox.tab.3"), variableList);
		processList = new ElementList(new ArrayList(), WorkflowDesignerConstants.EL_PROCESS);
		addTab(rm.getResource("TabbedToolBox.tab.4"), processList);
	}
	
	/**
	 * c[o[ԂB
	 * 
	 * @return	c[o[
	 */
	public FlowDesignToolBar getToolBar()
	{
		return toolBar;
	}
	
	/**
	 * pbP[W[hB
	 * 
	 * @param pkg	pbP[W
	 */
	public void loadElements(PackageElement pkg)
	{
		toolBar.init();
		participantList.setElements(pkg.getParticipants());
		applicationList.setElements(pkg.getApplications());
		variableList.setElements(pkg.getVariables());
		processList.setElements(pkg.getProcesses());
	}

}
