/* $Id: ValidationDialog.java,v 1.3 2005/08/26 04:50:17 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.*;

import jp.co.argo21.commons.util.ResourceManager;

/**
 * ،ʕ\p̃_CAO񋟂B
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ValidationDialog extends JDialog
{
	/** `ptHg */
	static private final Font FONT = new Font("SansSerif", Font.PLAIN, 24);

	/** ʃr[ */
	static private ValidationResultView resultView;
	/** G[Ȃr[ */
	static private JLabel noResultView;

	/**
	 * r[̏
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		resultView = new ValidationResultView();

		noResultView = new JLabel(rm.getResource("ValidationDialog.label.0"));
		noResultView.setPreferredSize(new Dimension(400, 200));
		noResultView.setFont(FONT);
		noResultView.setHorizontalAlignment(JLabel.CENTER);
		noResultView.setForeground(Color.gray);
	}

	/**
	 * ،ʕ\p̃_CAO\B
	 * 
	 * @param c	eR|[lg
	 * @param results	ʓe
	 */
	public static void showDialog(Component c, List results)
	{
		Frame frame = JOptionPane.getFrameForComponent(c);
		ValidationDialog dialog = new ValidationDialog(frame, results);
		dialog.setVisible(true);
		dialog.dispose();
	}

	/**
	 * ،ʕ\p̃_CAO𐶐B
	 * 
	 * @param frame	et[
	 * @param results	ʓe
	 */
	private ValidationDialog(Frame frame, List results)
	{
		super(frame, true);

		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		setTitle(rm.getResource("ValidationDialog.title"));
		
		JScrollPane scroll = new JScrollPane();
		if (results == null) {
			scroll.setViewportView(noResultView);
		} else {
			resultView.setResults(results);
			scroll.setViewportView(resultView);
		}

		JPanel buttonPane = new JPanel();
		buttonPane.setLayout(new FlowLayout(FlowLayout.RIGHT, 10, 10));

		ActionListener listener = new CloseAction();
		JButton closeButton = new JButton(rm.getResource("JButton.label.close"));
		closeButton.addActionListener(listener);
		getRootPane().setDefaultButton(closeButton);
		buttonPane.add(closeButton);

		Container contentPane = getContentPane();
		contentPane.add(scroll, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.PAGE_END);

		pack();

		setLocationRelativeTo(frame);
	}

	/**
	 * {^
	 */
	private class CloseAction implements ActionListener
	{
		/**
		 * _CAOB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setVisible(false);
		}
	}
}
