/* $Id: ValidationResultView.java,v 1.3 2005/08/26 04:50:06 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

/**
 * ،ʕ\pr[
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ValidationResultView extends JTabbedPane
{
	/** ، */
	private List results;
	/** e[u̗ */
	static private String[] columnNames;
	/** e[u̗ */
	static private int[] columnWidths;
	/** ʂ̎ޖ */
	static private String[] resultKinds;
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();
	/** ،ʃXg */
	private JTable resultTable;
	
	/**
	 * 萔̏
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		columnNames = new String[3];
		columnNames[0] = rm.getResource("ValidationResultTableModel.columnName.0");
		columnNames[1] = rm.getResource("ValidationResultTableModel.columnName.1");
		columnNames[2] = rm.getResource("ValidationResultTableModel.columnName.2");

		columnWidths = new int[3];
		columnWidths[0] = 50;
		columnWidths[1] = 150;
		columnWidths[2] = 400;

		resultKinds = new String[2];
		resultKinds[0] = rm.getResource("ValidationResultTableModel.resultKind.0");
		resultKinds[1] = rm.getResource("ValidationResultTableModel.resultKind.1");
	}

	/**
	 * ،ʕ\pr[𐶐B
	 */
	public ValidationResultView()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel1 = createResultPanel(rm);
		addTab(rm.getResource("ValidationResultView.tab.0"), panel1);

		validate();
	}
	
	
	/**
	 * p[^̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createResultPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.setBorder(border);
		Dimension size = new Dimension(420, 250);
		panel.setSize(size);
		panel.setPreferredSize(size);

		resultTable = new JTable(new ResultTableModel());
		resultTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		resultTable.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
		resultTable.setRowHeight(35);
		TableColumn column = null;
		for (int i = 0; i < columnWidths.length; i++) {
			column = resultTable.getColumnModel().getColumn(i);
			if (i == 1) column.setCellRenderer(new ElementRenderer());
			column.setPreferredWidth(columnWidths[i]);
		}
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(resultTable);

		panel.add(sp, CENTER);

		validate();
		
		return panel;
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	protected Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}
	
	/**
	 * ،ʂݒ肷B
	 * 
	 * @param list	،
	 */
	public void setResults(List list)
	{
		results = list;
	}

	/**
	 * p[^e[u䃂f
	 */
	class ResultTableModel extends AbstractTableModel
	{
		/**
		 * p[^e[u䃂f𐶐B
		 */
		ResultTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return columnNames.length;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			if (results == null) return 0;
			
			return results.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * Z̓eԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			if (results == null) return "";
			ValidationResult result = (ValidationResult)results.get(row);

			if (col == 0) {
				return resultKinds[result.getKind()];
			} else if (col == 1) {
				return result.getElement();
			} else if (col == 2) {
				return result.getMessage();
			}
			return "";
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			if (col == 1) return Element.class;
			else return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}

	/**
	 * vfZ̃_[
	 */
	public class ElementRenderer extends DefaultTableCellRenderer
	{
		/**
		 * Z̃_OsB
		 * 
		 * @param table	e[u
		 * @param o	Ze
		 * @param isSelected	I
		 * @param hasFocus	tH[JX
		 * @param row	s
		 * @param column	
		 * @return	_OꂽZ
		 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
		 */
		public Component getTableCellRendererComponent(
		JTable table,
		Object o,
		boolean isSelected,
		boolean hasFocus,
		int row,
		int column)
		{
			super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);

			Element elem = (Element)o;
			setText(getName(elem));
			Icon icon = getIcon(elem);
			if (icon != null) setIcon(icon);
			setToolTipText(getTooltipText(elem));
			return this;
		}

		/**
		 * vfԂB
		 * 
		 * @param e	vf
		 * @return	vf
		 */		
		private String getName(Element e)
		{
			String name = null;
			if (e instanceof TransitionElement) {
				return ((TransitionElement)e).getSource().getName();
			} else {
				return e.getName();
			}
		}
		
		/**
		 * c[`bvԂB
		 * 
		 * @param e	vf
		 * @return	c[`bv
		 */
		private String getTooltipText(Element e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			String name = null;
			if (e instanceof TransitionElement) {
				return ((TransitionElement)e).getSource().getTooltipText(rm);
			} else {
				return e.getTooltipText(rm);
			}
		}

		/**
		 * ACRԂB
		 * 
		 * @param e	vf
		 * @return	ACR
		 */		
		private Icon getIcon(Element e)
		{
			String name = null;
			if (e instanceof PackageElement) {
				name = WorkflowDesignerConstants.EL_PACKAGE + "-cur";
			} else if (e instanceof ParticipantElement) {
				name = WorkflowDesignerConstants.EL_PARTICIPANT + "-cur";
			} else if (e instanceof ApplicationElement) {
				name = WorkflowDesignerConstants.EL_APPLICATION + "-cur";
			} else if (e instanceof VariableElement) {
				name = WorkflowDesignerConstants.EL_VARIABLE + "-cur";
			} else if (e instanceof ProcessElement) {
				name = WorkflowDesignerConstants.EL_PROCESS + "-cur";
			} else if (e instanceof ParameterElement) {
				name = WorkflowDesignerConstants.EL_PARAMETER + "-cur";
			} else if (e instanceof ActivityElement) {
				name = ((ActivityElement)e).getActivityState().getIconName() + "-cur";
			} else if (e instanceof TransitionElement) {
				name = ((TransitionElement)e).getSource().getActivityState().getIconName() + "-cur";
			}
			
			if (name != null) return IconManager.getIcon(name);
			else return null;
		}
	}
}
