/* $Id: WorkflowDesignerFrame.java,v 1.3 2005/08/26 04:50:27 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.List;

import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

import org.wfmc.x2002.xpdl10.PackageDocument;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.action.ActionNames;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.impl.PackageElementImpl;
import jp.co.argo21.nautica.tool.wfd.xpdl.XPDLFileFilter;

/**
 * Nautica WorkflowDesigner̃CʂłB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowDesignerFrame extends JFrame
{
	/** j[o[ */
	private MenuBar menuBar;
	/** c[{bNX */
	private TabbedToolBox toolbox;
	/** fXNgbv */
	private DesktopPane desktop;
	/** Xe[^Xo[ */
	private DesignerStatusBar statusBar;
	
	/** ҏWΏۂ̃pbP[W */
	private PackageElement pkg;
	
	/** y[Xg\ȗvfꎞێGA */
	private Element pastable;
	
	/**
	 * Cʂ𐶐B
	 * 
	 * @throws java.awt.HeadlessException	j^[Ȃꍇ
	 */
	public WorkflowDesignerFrame() throws HeadlessException
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		initInputMap();

		Toolkit toolkit = Toolkit.getDefaultToolkit();
		Dimension screen = toolkit.getScreenSize();
		int sw = screen.width;
		int sh = screen.height;
		
		menuBar = new MenuBar();

		toolbox = new TabbedToolBox();
		desktop = new DesktopPane();
		statusBar = new DesignerStatusBar();

		setTitle(rm.getResource("WorkflowDesignerFrame.title"));
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		setDefaultCloseOperation(DO_NOTHING_ON_CLOSE);
		setJMenuBar(menuBar);

		Container contentPane = getContentPane();
		BorderLayout layout = new BorderLayout();
		contentPane.setLayout(layout);
		contentPane.add(toolbox, BorderLayout.NORTH);
		contentPane.add(desktop, BorderLayout.CENTER);
		contentPane.add(statusBar, BorderLayout.SOUTH);

		//EBhE𒆉ɔzu
		int fw = (int)(sw * 0.95);
		int fh = (int)(sh * 0.95);
		setSize(new Dimension(fw, fh));
		setLocation((sw - fw) / 2, 0);
		setIconImage(((ImageIcon)IconManager.getIcon("application")).getImage());

		this.validate();
	}

	/**
	 * EBhECxg𐧌䂷B
	 *
	 * @param	e		WindowEvent
	 */
	protected void processWindowEvent(WindowEvent e)
	{
		super.processWindowEvent(e);

		if (e.getID() == WindowEvent.WINDOW_CLOSING) {
			notifyApplicationWillExit();
		} else {
			repaint();
		}
	}

	/**
	 * I
	 */
	public void notifyApplicationWillExit()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		if (isNeedSaved()) {
			int result = DialogUtilities.showYesNoConfirm(rm.getResource("message.confirm.0002"));
			if (result == JOptionPane.YES_OPTION) {
				save();
			}
		}
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	/**
	 * V[gJbgL[̃}bsOsB
	 */
	private void initInputMap()
	{
		JComponent c = (JComponent)this.getContentPane();
		
		//ANV}bvo^
		ActionMap am = WorkflowDesignerManager.getActionMap();
		c.setActionMap(am);
		
		//Cvbg}bvo^
		InputMap inputmap = c.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
		inputmap.put(KeyStroke.getKeyStroke('N', Event.CTRL_MASK), ActionNames.NEW_PACKAGE);
		inputmap.put(KeyStroke.getKeyStroke('O', Event.CTRL_MASK), ActionNames.OPEN_PACKAGE);
		inputmap.put(KeyStroke.getKeyStroke('S', Event.CTRL_MASK), ActionNames.SAVE_PACKAGE);
		inputmap.put(KeyStroke.getKeyStroke('P', Event.CTRL_MASK), ActionNames.PRINT_PACKAGE);
		inputmap.put(KeyStroke.getKeyStroke('Q', Event.CTRL_MASK), ActionNames.EXIT);
		inputmap.put(KeyStroke.getKeyStroke('X', Event.CTRL_MASK), ActionNames.CUT_ACTIVITY);
		inputmap.put(KeyStroke.getKeyStroke('C', Event.CTRL_MASK), ActionNames.COPY_ACTIVITY);
		inputmap.put(KeyStroke.getKeyStroke('V', Event.CTRL_MASK), ActionNames.PASTE_ACTIVITY);
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_DELETE, 0), ActionNames.DELETE_ACTIVITY);
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_F11, 0), ActionNames.EXCEPTION_VIEWER);
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_F1, 0), ActionNames.HELP);
		inputmap.put(KeyStroke.getKeyStroke('H', Event.CTRL_MASK), ActionNames.HELP);

		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_UP, Event.ALT_MASK), ActionNames.REDUCE_HEIGHT);
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, Event.ALT_MASK), ActionNames.EXPAND_HEIGHT);
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, Event.ALT_MASK), ActionNames.REDUCE_WIDTH);
		inputmap.put(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, Event.ALT_MASK), ActionNames.EXPAND_WIDTH);
	}

	/**
	 * pbP[W[hB
	 */	
	void load()
	{
		FileManager fileManager = WorkflowDesignerManager.getFileManager();
		try {
			PackageDocument doc = fileManager.getDocument();
			PackageElement p = new PackageElementImpl(doc);
			PackageConverter conv = PackageConverter.getInstance();
			fileManager.setDocument(conv.convert(p));
			desktop.closeAllFrame();
			setPackage(p);
			toolbox.setSelectedIndex(TabbedToolBox.TAB_PROCESS);
		} catch (Exception ex) {
			//ꂪG[ɂȂȂoO
			ex.printStackTrace();
		}
	}
	
	/**
	 * ۑĂȂύX邩ǂԂB
	 * 
	 * @return	ۑKvȂtrue
	 */
	boolean isNeedSaved()
	{
		FileManager fileManager = WorkflowDesignerManager.getFileManager();
		try {
			PackageDocument doc = fileManager.getDocument();
			PackageConverter conv = PackageConverter.getInstance();
			PackageDocument converted = conv.convert(pkg);
			if (doc == null) return false;
			if (converted == null) return false;
			
			if (doc.toString().equals(converted.toString())) return false;
			else return true;
		} catch (Exception ex) {
			return true;
		}
	}
	
	/**
	 * VKpbP[WB
	 */
	public void newPackage()
	{
		FileManager fileManager = WorkflowDesignerManager.getFileManager();
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		try {
			if (isNeedSaved()) {
				int result = DialogUtilities.showYesNoConfirm(rm.getResource("message.confirm.0002"));
				if (result == JOptionPane.YES_OPTION) {
					save();
				}
			}
			fileManager.initDocument();
			load();
		} catch (Exception ex) {
			WorkflowDesignerManager.getExceptionViewer().setThrowable(ex);
			DialogUtilities.showError(rm.getResource("message.error.0011"));
		}
	}

	/**
	 * pbP[WJB
	 */	
	public void open()
	{
		FileManager fileManager = WorkflowDesignerManager.getFileManager();
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		try {
			if (isNeedSaved()) {
				int result = DialogUtilities.showYesNoConfirm(rm.getResource("message.confirm.0002"));
				if (result == JOptionPane.YES_OPTION) {
					save();
				}
			}
			JFileChooser fileChooser = new JFileChooser();
			fileChooser.setAcceptAllFileFilterUsed(false);
			fileChooser.setFileFilter(new XPDLFileFilter(rm.getResource("XPDLFileFilter.description")));
			fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);

			int selected = fileChooser.showOpenDialog(this);
			if (selected == JFileChooser.CANCEL_OPTION) return;

			File file = fileChooser.getSelectedFile();
			if (file == null) return;

			String path = file.getAbsolutePath();
			if (! path.endsWith(XPDLFileFilter.EXTENSION)) {
				path = path + "." + XPDLFileFilter.EXTENSION;
			}
			fileManager.loadDocument(path);
			load();
		} catch (Exception ex) {
			WorkflowDesignerManager.getExceptionViewer().setThrowable(ex);
			DialogUtilities.showError(rm.getResource("message.error.0012"));
		}
	}
	
	/**
	 * ۑB
	 */
	public void save()
	{
		FileManager fileManager = WorkflowDesignerManager.getFileManager();
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		String fn = fileManager.getFilename();

		//܂xۑĂȂꍇ́Aʖۑ̃WbNgpB
		if (fn == null) {
			saveTo();
			return;
		}

		try {
			PackageConverter conv = PackageConverter.getInstance();
			fileManager.setDocument(conv.convert(pkg));
			fileManager.saveDocument();
		} catch (Exception ex) {
			WorkflowDesignerManager.getExceptionViewer().setThrowable(ex);
			DialogUtilities.showError(rm.getResource("message.error.0013"));
		}
	}

	/**
	 * ʖŕۑB
	 */	
	public void saveTo()
	{
		FileManager fileManager = WorkflowDesignerManager.getFileManager();
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		JFileChooser fileChooser = null;
		File selectedFile = new File(System.getProperty("user.home", ".")
			+ System.getProperty("file.separator", "/")
			+ pkg.getName() + "." + XPDLFileFilter.EXTENSION
			);

		fileChooser = new JFileChooser(selectedFile);
		fileChooser.setAcceptAllFileFilterUsed(false);
		fileChooser.setFileFilter(new XPDLFileFilter(rm.getResource("XPDLFileFilter.description")));
		fileChooser.setFileSelectionMode(JFileChooser.FILES_ONLY);

		int selected = fileChooser.showSaveDialog(this);
		if (selected == JFileChooser.CANCEL_OPTION) return;

		File file = fileChooser.getSelectedFile();
		if (file == null) return;

		String path = file.getAbsolutePath();
		if (! path.endsWith(XPDLFileFilter.EXTENSION)) {
			path = path + "." + XPDLFileFilter.EXTENSION;
		}

		try {
			PackageConverter conv = PackageConverter.getInstance();
			fileManager.setDocument(conv.convert(pkg));
			fileManager.saveDocument(path);
		} catch (Exception ex) {
			WorkflowDesignerManager.getExceptionViewer().setThrowable(ex);
			DialogUtilities.showError(rm.getResource("message.error.0013"));
		}
	}

	/**
	 * pbP[W̌؏B
	 */	
	public void validatePackage()
	{
		List results = PackageValidator.getInstance().validate(pkg);
		ValidationDialog.showDialog(this, results);
	}

	/**
	 * pbP[W̃CXyN^\B
	 */	
	public void showPackageInspector()
	{
		InspectorDialog.showDialog(this, pkg);
	}

	/**
	 * j[o[ԂB
	 * 
	 * @return	j[o[
	 */
	public MenuBar getFrameMemuBar()
	{
		return menuBar;
	}

	/**
	 * fXNgbvԂB
	 * 
	 * @return	fXNgbv
	 */
	public DesktopPane getDesktop()
	{
		return desktop;
	}

	/**
	 * Xe[^Xo[ԂB
	 * 
	 * @return	Xe[^Xo[
	 */
	public DesignerStatusBar getStatusBar()
	{
		return statusBar;
	}

	/**
	 * c[{bNXԂB
	 * 
	 * @return	c[{bNX
	 */
	public TabbedToolBox getToolbox()
	{
		return toolbox;
	}
	/**
	 * pbP[WԂB
	 * 
	 * @return	pbP[W
	 */
	public PackageElement getPackage()
	{
		return pkg;
	}

	/**
	 * pbP[Wݒ肷B
	 * 
	 * @param elem	pbP[W
	 */
	public void setPackage(PackageElement elem)
	{
		pkg = elem;
		toolbox.loadElements(elem);
	}

	/**
	 * Rs[̉ۂԂB
	 * 
	 * @return	Rs[\Ȃtrue
	 */	
	public boolean getEnableCopyAction()
	{
		return menuBar.getEnableCopyAction();
	}

	/**
	 * Rs[̉ۂݒ肷B
	 * 
	 * @param f	Rs[̉
	 */	
	public void setEnableCopyAction(boolean f)
	{
		menuBar.setEnableCopyAction(f);
	}
	
	/**
	 * y[Xg̉ۂԂB
	 * 
	 * @return	y[Xg\Ȃtrue
	 */
	public boolean getEnablePasteAction()
	{
		return menuBar.getEnablePasteAction();
	}
	
	/**
	 * y[Xg̉ۂݒ肷B
	 * 
	 * @param f	y[Xg̉
	 */
	public void setEnablePasteAction(boolean f)
	{
		menuBar.setEnablePasteAction(f);
	}
	
	/**
	 * 폜̉ۂԂB
	 * 
	 * @return	폜\Ȃtrue
	 */
	public boolean getEnableDeleteAction()
	{
		return menuBar.getEnableDeleteAction();
	}
	
	/**
	 * 폜̉ۂݒ肷B
	 * 
	 * @param f	폜̉
	 */
	public void setEnableDeleteAction(boolean f)
	{
		menuBar.setEnableDeleteAction(f);
	}

	/**
	 * y[Xg\ȗvfԂB
	 * 
	 * @return	vf
	 */
	public Element getPastable()
	{
		return pastable;
	}

	/**
	 * y[Xg\ȗvfݒ肷B
	 * 
	 * @param element	vf
	 */
	public void setPastable(Element element)
	{
		pastable = element;
		menuBar.setEnablePasteAction(pastable != null);
	}
}
