/* $Id: WorkflowDesignerManager.java,v 1.3 2005/08/26 04:50:18 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd;

import javax.swing.ActionMap;

import jp.co.argo21.commons.swing.ExceptionViewer;
import jp.co.argo21.commons.swing.HelpViewer;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.action.ActionNames;
import jp.co.argo21.nautica.tool.wfd.action.CopyActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.CutActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.DeleteActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.ExceptionViewerAction;
import jp.co.argo21.nautica.tool.wfd.action.ExitAction;
import jp.co.argo21.nautica.tool.wfd.action.ExpandFlowViewHeightAction;
import jp.co.argo21.nautica.tool.wfd.action.ExpandFlowViewWidthAction;
import jp.co.argo21.nautica.tool.wfd.action.HelpAction;
import jp.co.argo21.nautica.tool.wfd.action.NewPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.OpenPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.PasteActivityAction;
import jp.co.argo21.nautica.tool.wfd.action.PreferencesAction;
import jp.co.argo21.nautica.tool.wfd.action.PrintAction;
import jp.co.argo21.nautica.tool.wfd.action.ReduceFlowViewHeightAction;
import jp.co.argo21.nautica.tool.wfd.action.ReduceFlowViewWidthAction;
import jp.co.argo21.nautica.tool.wfd.action.SavePackageAction;
import jp.co.argo21.nautica.tool.wfd.action.SaveToPackageAction;
import jp.co.argo21.nautica.tool.wfd.action.VersionAction;

/**
 * Nautica WorkflowDesignerSʂ̊ǗsB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class WorkflowDesignerManager
{
	/** ohpX */
	static private final String BUNDLE_PATH
		= "jp.co.argo21.nautica.tool.wfd.resources.messages";

	/** \[X}l[W */
	static private ResourceManager resourceManager;
	/** C */
	static private WorkflowDesignerFrame mainFrame;
	/** Or[A */
	static private ExceptionViewer exceptionViewer;
	/** o[W */
	static private VersionWindow versionWindow;
	/** wv */
	static private HelpViewer helpViewer;

	/** ANV}bv */
	static private ActionMap actionMap;
	
	/** t@C}l[W */
	static private FileManager fileManager;

	/**
	 * NsB
	 */
	public static void boot() throws Exception
	{
		resourceManager = new ResourceManager(BUNDLE_PATH);

		crerateActionMap();
		
		fileManager = new FileManager();

		versionWindow = new VersionWindow();
		versionWindow.setVisible(true);
		
		//XvbV\̂߂1.5bԂ̖ʏ
		//long t = System.currentTimeMillis() + 500;
		//while (System.currentTimeMillis() < t) { /* NOP */ }

		mainFrame = new WorkflowDesignerFrame();
		exceptionViewer = new ExceptionViewer(mainFrame, false);
		helpViewer = new HelpViewer();
		mainFrame.newPackage();
		mainFrame.setVisible(true);

		versionWindow.setVisible(false);
	}

	/**
	 * \[X}l[WԂB
	 *
	 * @return	\[X}l[W
	 */
	static public ResourceManager getResourceManager()
	{
		return resourceManager;
	}

	/**
	 * Or[AɗOݒ肷B
	 * 
	 * @param ex	Cӂ̗O
	 */
	static public void setException(Exception ex)
	{
		exceptionViewer.setThrowable(ex);
	}

	/**
	 * Or[AԂB
	 * 
	 * @return Or[A
	 */
	static public ExceptionViewer getExceptionViewer()
	{
		return exceptionViewer;
	}

	/**
	 * wvʂԂB
	 * 
	 * @return wv
	 */
	static public HelpViewer getHelpViewer()
	{
		return helpViewer;
	}

	/**
	 * CʂԂB
	 * 
	 * @return C
	 */
	static public WorkflowDesignerFrame getMainFrame()
	{
		return mainFrame;
	}

	/**
	 * o[WʂԂB
	 * 
	 * @return o[W
	 */
	static public VersionWindow getVersionWindow()
	{
		return versionWindow;
	}

	/**
	 * ANV}bvԂB
	 * 
	 * @return	ANV}bv
	 */
	static public ActionMap getActionMap()
	{
		return actionMap;
	}

	/**
	 * t@C}l[WԂB
	 * 
	 * @return	t@C}l[W
	 */
	static public FileManager getFileManager()
	{
		return fileManager;
	}

	/**
	 * ANV}bv쐬B
	 */
	static private void crerateActionMap()
	{
		actionMap = new ActionMap();

		actionMap.put(ActionNames.NEW_PACKAGE,      new NewPackageAction());
		actionMap.put(ActionNames.OPEN_PACKAGE,     new OpenPackageAction());
		actionMap.put(ActionNames.SAVE_PACKAGE,     new SavePackageAction());
		actionMap.put(ActionNames.SAVE_TO_PACKAGE,  new SaveToPackageAction());
		actionMap.put(ActionNames.PRINT_PACKAGE,    new PrintAction());
		actionMap.put(ActionNames.EXIT,             new ExitAction());

		actionMap.put(ActionNames.CUT_ACTIVITY,     new CutActivityAction());
		actionMap.put(ActionNames.COPY_ACTIVITY,    new CopyActivityAction());
		actionMap.put(ActionNames.PASTE_ACTIVITY,   new PasteActivityAction());
		actionMap.put(ActionNames.DELETE_ACTIVITY,  new DeleteActivityAction());

		actionMap.put(ActionNames.EXCEPTION_VIEWER, new ExceptionViewerAction());
		actionMap.put(ActionNames.PREFERENCES,      new PreferencesAction());

		actionMap.put(ActionNames.HELP,             new HelpAction());
		actionMap.put(ActionNames.ABOUT,            new VersionAction());

		actionMap.put(ActionNames.REDUCE_WIDTH,     new ReduceFlowViewWidthAction());
		actionMap.put(ActionNames.REDUCE_HEIGHT,    new ReduceFlowViewHeightAction());
		actionMap.put(ActionNames.EXPAND_WIDTH,     new ExpandFlowViewWidthAction());
		actionMap.put(ActionNames.EXPAND_HEIGHT,    new ExpandFlowViewHeightAction());
	}
}
