/* $Id: ElementContext.java,v 1.3 2005/08/26 04:50:56 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;

import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * vf̃hbOhbvpReLXg
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ElementContext implements Transferable
{
	/** MIME^Cv */
	static public final String MIME_TYPE
		= WorkflowDesignerConstants.PTYPE
		+ "/"
		+ WorkflowDesignerConstants.STYPE_ELEMENT;

	/** f[^t[o[ */
	private DataFlavor[] flavors;
	/** vf */
	private Element element;

	/**
	 * ReLXg𐶐B
	 * 
	 * @param elem	vf
	 * @param type	^
	 */		
	public ElementContext(Element elem, String type)
	{
		DataFlavor flavor
			= new DataFlavor(MIME_TYPE, "");
		flavors = new DataFlavor[1];
		flavor.setHumanPresentableName(type);
		flavors[0] = flavor;
		element = elem;
	}
	
	/**
	 * ]f[^łvfԂB
	 * 
	 * @param flavor	f[^t[o[
	 * @return	]f[^
	 * @see java.awt.datatransfer.Transferable#getTransferData(java.awt.datatransfer.DataFlavor)
	 */	
	public Object getTransferData(DataFlavor flavor)
	{
		if (isDataFlavorSupported(flavor)) {
			return element;
		} else {
			return null;
		}
	}

	/**
	 * f[^t[o[ԂB
	 * 
	 * @return	f[^t[o[
	 * @see java.awt.datatransfer.Transferable#getTransferDataFlavors()
	 */
	public DataFlavor[] getTransferDataFlavors()
	{
		return flavors;
	}

	/**
	 * w肳ꂽf[^t[o[T|[g邩ǂԂB
	 * 
	 * @param flavor	f[^t[o[B
	 * @return	T|[g̐
	 * @see java.awt.datatransfer.Transferable#isDataFlavorSupported(java.awt.datatransfer.DataFlavor)
	 */
	public boolean isDataFlavorSupported(DataFlavor flavor)
	{
		if (flavor.getSubType().equals(WorkflowDesignerConstants.STYPE_ELEMENT)) {
			return true;
		} else {
			return false;
		}
	}
}
