/* $Id: ActivityElement.java,v 1.4 2005/08/26 04:51:13 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import java.util.List;

import org.wfmc.x2002.xpdl10.SubFlowDocument;

/**
 * ANeBreB`pC^tF[X
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public interface ActivityElement extends Element
{
	/** ANeBreBIDpړ */
	static public final String ID_PREFIX       = "AC";
	/** ubNIDpړ */
	static public final String BLOCK_ID_PREFIX = "BK";

	/** ANeBreB^擾L[ */
	static public final String ACTIVITY_TYPE = "ACTIVITY_TYPE";
	/** _XW擾L[ */
	static public final String LOGICAL_X     = "LOGICAL_X";
	/** _YW擾L[ */
	static public final String LOGICAL_Y     = "LOGICAL_Y";
	/** ubNID擾L[ */
	static public final String AFFILIATE_BID = "AFFILIATE_BID";
	/** eubNID擾L[ */
	static public final String PARENT_BID    = "PARENT_BID";
	/** GW */
	static public final String ENGINE_NANE   = "ENGINE_NANE";

	/** JnANeBreB^ */
	static public final String START        = "START";
	/** Θb^ANeBreB^ */
	static public final String INTERACTIVE  = "INTERACTIVE";
	/** sANeBreB^ */
	static public final String AUTOMATIC    = "AUTOMATIC";
	/** TuvZXANeBreB^ */
	static public final String SUBPROCESS   = "SUBPROCESS";
	/** sANeBreB^ */
	static public final String CONCURRENT   = "CONCURRENT";
	/** sJnANeBreB^ */
	static public final String CONCUR_START = "CONCUR_START";
	/** sIANeBreB^ */
	static public final String CONCUR_END   = "CONCUR_END";
	/** IANeBreB^ */
	static public final String END          = "END";

	/** 񓯊 */
	static public final int ASYNCHR = SubFlowDocument.SubFlow.Execution.INT_ASYNCHR;
	/**  */
	static public final int SYNCHR  = SubFlowDocument.SubFlow.Execution.INT_SYNCHR;

	/**
	 * ANeBreB^ԂB
	 * 
	 * @return	ANeBreB^
	 */
	public String getType();

	/**
	 * sԂB
	 * 
	 * @return	s
	 */
	public int getLimit();

	/**
	 * _XWԂB
	 * 
	 * @return	_XW
	 */
	public int getLogicalX();

	/**
	 * _YWԂB
	 * 
	 * @return	_YW
	 */
	public int getLogicalY();

	/**
	 * ubNIDԂB
	 * 
	 * @return	ubNID
	 */
	public String getBlockID();

	/**
	 * ubNIDԂB
	 * 
	 * @return	ubNID
	 */
	public String getAffiliateBID();

	/**
	 * eubNIDԂB
	 * 
	 * @return	eubNID
	 */
	public String getParentBID();

	/**
	 * TuvZXs̓ԂԂB
	 * 
	 * @return	TuvZXs̓
	 */
	public int getExecution();

	/**
	 * ANeBreBԂԂB
	 * 
	 * @return	ANeBreB
	 */
	public ActivityState getActivityState();

	/**
	 * AvP[VIDԂB
	 * 
	 * @return	AvP[VID
	 */
	public String getApplicationID();

	/**
	 * TuvZXIDԂB
	 * 
	 * @return	TuvZXID
	 */
	public String getSubprocessID();

	/**
	 * sIDԂB
	 * 
	 * @return	sID
	 */
	public String getPerformerID();

	/**
	 * AvP[Vp[^ꗗԂB
	 * 
	 * @return	AvP[Vp[^ꗗ
	 */
	public List getApplicationParameters();

	/**
	 * TuvZXp[^ꗗԂB
	 * 
	 * @return	TuvZXp[^ꗗ
	 */
	public List getSubprocessParameters();

	/**
	 * GWԂB
	 * 
	 * @return	GW
	 */
	public String getEngineName();

	/**
	 * sݒ肷B
	 * 
	 * @param limit	s
	 */
	public void setLimit(int limit);

	/**
	 * _XWݒ肷B
	 * 
	 * @param x	_XW
	 */
	public void setLogicalX(int x);
	
	/**
	 * _YWݒ肷B
	 * 
	 * @param y	_YW
	 */
	public void setLogicalY(int y);
	
	/**
	 * ubNIDݒ肷B
	 * 
	 * @param id	ubNID
	 */
	public void setBlockID(String id);
	
	/**
	 * ubNIDݒ肷B
	 * 
	 * @param id	ubNID
	 */
	public void setAffiliateBID(String id);
	
	/**
	 * eubNIDݒ肷B
	 * 
	 * @param id	eubNID
	 */
	public void setParentBID(String id);
	
	/**
	 * TuvZXs̓Ԃݒ肷B
	 * 
	 * @param sync	TuvZXs̓
	 */
	public void setExecution(int sync);
	
	/**
	 * sIDݒ肷B
	 * 
	 * @param id	sID
	 */
	public void setPerformerID(String id);
	
	/**
	 * AvP[VIDݒ肷B
	 * 
	 * @param id	AvP[VID
	 */
	public void setApplicationID(String id);
	
	/**
	 * TuvZXIDݒ肷B
	 * 
	 * @param id	TuvZXID
	 */
	public void setSubprocessID(String id);
	
	/**
	 * GWݒ肷B
	 * 
	 * @param engineName	GW
	 */
	public void setEngineName(String engineName);

	/**
	 * AvP[Vp[^ǉB
	 * 
	 * @param id	AvP[Vp[^
	 */
	public void addApplicationParameterID(String id);
	
	/**
	 * TuvZXp[^ǉB
	 * 
	 * @param id	TuvZXp[^
	 */
	public void addSubprocessParameterID(String id);

	/**
	 * AvP[Vp[^폜B
	 * 
	 * @param id	AvP[Vp[^
	 */
	public void removeApplicationParameterID(String id);
	
	/**
	 * TuvZXp[^폜B
	 * 
	 * @param id	TuvZXp[^
	 */
	public void removeSubprocessParameterID(String id);

	/**
	 * B
	 * 
	 * @return	ANeBreB
	 */	
	public ActivityElement copy();
}
