/* $Id: PackageElement.java,v 1.3 2005/08/26 04:51:10 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import java.util.List;

/**
 * pbP[W`pC^tF[X
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public interface PackageElement extends Element
{
	/** pbP[WIDړ */
	static public final String ID_PREFIX  = "PK";

	/**
	 * 쐬ԂB
	 * 
	 * @return	쐬
	 */
	public String getCreatedDate();
	
	/**
	 * `҂ԂB
	 * 
	 * @return	`
	 */
	public String getAuthor();
	
	/**
	 * o[WԂB
	 * 
	 * @return	o[W
	 */
	public String getVersion();
	
	/**
	 * [Nt[Q҈ꗗԂB
	 * 
	 * @return	[Nt[Q҈ꗗ
	 */
	public List getParticipants();
	
	/**
	 * AvP[VꗗԂB
	 * 
	 * @return	AvP[Vꗗ
	 */
	public List getApplications();
	
	/**
	 * vZXϐꗗԂB
	 * 
	 * @return	vZXϐꗗ
	 */
	public List getVariables();
	
	/**
	 * vZXꗗԂB
	 * 
	 * @return	vZXꗗ
	 */
	public List getProcesses();

	/**
	 * 쐬ݒ肷B
	 * 
	 * @param s	쐬
	 */
	public void setCreatedDate(String s);	

	/**
	 * `҂ݒ肷B
	 * 
	 * @param s	`
	 */
	public void setAuthor(String s);

	/**
	 * o[Wݒ肷B
	 * 
	 * @param s	o[W
	 */
	public void setVersion(String s);

	/**
	 * [Nt[Q҂ǉB
	 * 
	 * @param part	[Nt[Q
	 */
	public void addParticipant(ParticipantElement part);
	
	/**
	 * AvP[VǉB
	 * 
	 * @param app	AvP[V
	 */
	public void addApplication(ApplicationElement app);
	
	/**
	 * vZXϐǉB
	 * 
	 * @param var	vZXϐ
	 */
	public void addVariable(VariableElement var);
	
	/**
	 * vZXǉB
	 * 
	 * @param proc	vZX
	 */
	public void addProcess(ProcessElement proc);

	/**
	 * [Nt[Q҂폜B
	 * 
	 * @param part	[Nt[Q
	 */
	public void removeParticipant(ParticipantElement part);
	
	/**
	 * AvP[V폜B
	 * 
	 * @param app	AvP[V
	 */
	public void removeApplication(ApplicationElement app);
	
	/**
	 * vZXϐ폜B
	 * 
	 * @param var	vZXϐ
	 */
	public void removeVariable(VariableElement var);
	
	/**
	 * vZX폜B
	 * 
	 * @param proc	vZX
	 */
	public void removeProcess(ProcessElement proc);
}
