/* $Id: ParameterElement.java,v 1.3 2005/08/26 04:51:11 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import org.wfmc.x2002.xpdl10.BasicTypeDocument;
import org.wfmc.x2002.xpdl10.FormalParameterDocument;

/**
 * p[^`pC^tF[X
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public interface ParameterElement extends Element
{
	/** p[^IDړ */
	static public final String ID_PREFIX  = "PM";

	/**  */
	static public final int IN    = FormalParameterDocument.FormalParameter.Mode.INT_IN;
	/** o */
	static public final int OUT   = FormalParameterDocument.FormalParameter.Mode.INT_OUT;
	/** o */
	static public final int INOUT = FormalParameterDocument.FormalParameter.Mode.INT_INOUT;

	/**  */
	static public final int STRING    = BasicTypeDocument.BasicType.Type.INT_STRING;
	/**  */
	static public final int FLOAT     = BasicTypeDocument.BasicType.Type.INT_FLOAT;
	/**  */
	static public final int INTEGER   = BasicTypeDocument.BasicType.Type.INT_INTEGER;
	/**  */
	static public final int DATETIME  = BasicTypeDocument.BasicType.Type.INT_DATETIME;
	/** ^l */
	static public final int BOOLEAN   = BasicTypeDocument.BasicType.Type.INT_BOOLEAN;

	/**
	 * p[^^ԂB
	 * 
	 * @return	p[^^
	 */
	public int getType();

	/**
	 * o̓[hԂB
	 * 
	 * @return	o̓[h
	 */
	public int getMode();

	/**
	 * p[^^ݒ肷B
	 * 
	 * @param type	p[^^
	 */	
	public void setType(int type);

	/**
	 * o̓[hݒ肷B
	 * 
	 * @param mode	o̓[h
	 */
	public void setMode(int mode);
}
