/* $Id: ProcessElement.java,v 1.3 2005/08/26 04:51:09 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import java.util.List;

import org.wfmc.x2002.xpdl10.ProcessHeaderDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;

/**
 * vZX`pC^tF[X
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public interface ProcessElement extends Element
{
	/** vZXIDړ */
	static public final String ID_PREFIX  = "PS";

	/** _W擾L[ */
	static public final String LOGICAL_WIDTH  = "LOGICAL_WIDTH";
	/** _W擾L[ */
	static public final String LOGICAL_HEIGHT = "LOGICAL_HEIGHT";

	/** [gvZX */
	static public final int PUBLIC  = WorkflowProcessDocument.WorkflowProcess.AccessLevel.INT_PUBLIC;
	/** TuvZX */
	static public final int PRIVATE = WorkflowProcessDocument.WorkflowProcess.AccessLevel.INT_PRIVATE;

	/** N */
	static public final int YEAR   = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_Y;
	/**  */
	static public final int MONTH  = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_M;
	/**  */
	static public final int DAY    = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_D;
	/**  */
	static public final int HOUR   = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_H;
	/**  */
	static public final int MINUTE = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_M_2;
	/** b */
	static public final int SECOND = ProcessHeaderDocument.ProcessHeader.DurationUnit.INT_S;

	/**
	 * ԒPʂԂB
	 * 
	 * @return	ԒP
	 */
	public int getDurationUnit();

	/**
	 * sԂB
	 * 
	 * @return	s
	 */
	public int getLimit();

	/**
	 * ANZXxԂB
	 * 
	 * @return	ANZXx
	 */
	public int getAccessLevel();

	/**
	 * _WԂB
	 * 
	 * @return	_W
	 */
	public int getLogicalWidth();

	/**
	 * _WԂB
	 * 
	 * @return	_W
	 */
	public int getLogicalHeight();

	/**
	 * ʒm҈ꗗԂB
	 * 
	 * @return	ʒm҈ꗗ
	 */
	public List getResponsibles();

	/**
	 * p[^ꗗԂB
	 * 
	 * @return	p[^ꗗ
	 */
	public List getParameters();

	/**
	 * ANeBreBꗗԂB
	 * 
	 * @return	ANeBreBꗗ
	 */
	public List getActivities();

	/**
	 * JڈꗗԂB
	 * 
	 * @return	Jڈꗗ
	 */
	public List getTransitions();

	/**
	 * ԒPʂݒ肷B
	 * 
	 * @param unit	ԒP
	 */
	public void setDurationUnit(int unit);
	
	/**
	 * sݒ肷B
	 * 
	 * @param limit	s
	 */
	public void setLimit(int limit);
	
	/**
	 * _Wݒ肷B
	 * 
	 * @param w	_W
	 */
	public void setLogicalWidth(int w);
	
	/**
	 * _Wݒ肷B
	 * 
	 * @param h	_W
	 */
	public void setLogicalHeight(int h);

	/**
	 * ʒm҂ǉB
	 * 
	 * @param r	ʒm
	 */
	public void addResponsible(String r);
	
	/**
	 * p[^ǉB
	 * 
	 * @param param	p[^
	 */
	public void addParameter(ParameterElement param);
	
	/**
	 * ANeBreBǉB
	 * 
	 * @param act	ANeBreB
	 */
	public void addActivity(ActivityElement act);
	
	/**
	 * JڂǉB
	 * 
	 * @param tr	J
	 */
	public void addTransition(TransitionElement tr);

	/**
	 * ʒm҂폜B
	 * 
	 * @param r	ʒm
	 */
	public void removeResponsible(String r);
	
	/**
	 * p[^폜B
	 * 
	 * @param param	p[^
	 */
	public void removeParameter(ParameterElement param);
	
	/**
	 * ANeBreB폜B
	 * 
	 * @param act	ANeBreB
	 */
	public void removeActivity(ActivityElement act);
	
	/**
	 * Jڂ폜B
	 * 
	 * @param tr	J
	 */
	public void removeTransition(TransitionElement tr);
}
