/* $Id: TransitionElement.java,v 1.3 2005/08/26 04:51:12 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element;

import jp.co.argo21.nautica.tool.wfd.expression.Expression;

import org.wfmc.x2002.xpdl10.ConditionDocument;

/**
 * Jڒ`pC^tF[X
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public interface TransitionElement extends Element
{
	/** JIDړ */
	static public final String ID_PREFIX  = "TR";

	/**  */
	static public final int CONDITION        = ConditionDocument.Condition.Type.INT_CONDITION;
	/** ̑ */
	static public final int OTHERWISE        = ConditionDocument.Condition.Type.INT_OTHERWISE;
	/** O */
	static public final int EXCEPTION        = ConditionDocument.Condition.Type.INT_EXCEPTION;
	/** ftHgO */
	static public final int DEFAULTEXCEPTION = ConditionDocument.Condition.Type.INT_DEFAULTEXCEPTION;

	/**
	 * JڌANeBreBԂB
	 * 
	 * @return	JڌANeBreB
	 */
	public ActivityElement getSource();

	/**
	 * JڐANeBreBԂB
	 * 
	 * @return	JڐANeBreB
	 */
	public ActivityElement getDestination();

	/**
	 * JڏԂB
	 * 
	 * @return	Jڏ
	 */
	public Expression getCondition();

	/**
	 * Jڌ^ԂB
	 * 
	 * @return	Jڌ^
	 */
	public int getType();

	/**
	 * Jڏݒ肷B
	 * 
	 * @param cond	Jڏ
	 */	
	public void setCondition(Expression cond);

	/**
	 * Jڌ^ݒ肷B
	 * 
	 * @param type	Jڌ^
	 */
	public void setType(int type);	
}
