/* $Id: ActivityElementImpl.java,v 1.5 2005/08/26 04:50:59 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.wfmc.x2002.xpdl10.ActivityDocument;
import org.wfmc.x2002.xpdl10.ActualParametersDocument;
import org.wfmc.x2002.xpdl10.BlockActivityDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributeDocument;
import org.wfmc.x2002.xpdl10.ExtendedAttributesDocument;
import org.wfmc.x2002.xpdl10.ImplementationDocument;
import org.wfmc.x2002.xpdl10.SubFlowDocument;
import org.wfmc.x2002.xpdl10.ToolDocument;

import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.ActivityStateFactory;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ActivityState;
import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * ANeBreB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class ActivityElementImpl implements ActivityElement
{
	/** ̉ID */
	static private final String UNINITIALIZED_ID = "--UNINITIALIZED--"; 

	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** s */
	private int limit;
	/** _XW */
	private int logicalX;
	/** _YW */
	private int logicalY;
	/** ubNID */
	private String blockID;
	/** ubNID */
	private String affiliateBID;
	/** eubNID */
	private String parentBID;
	/** AvP[VID */
	private String applicationID;
	/** TuvZXID */
	private String subprocessID;
	/** sID */
	private String performerID;
	/** TuvZXs̓ */
	private int sync;
	/** AvP[Vp[^ꗗ */
	private List applicationParameters = new ArrayList();
	/** TuvZXp[^ꗗ */
	private List subprocessParameters = new ArrayList();
	/** GW */
	private String engineName;
	/** ANeBreB */
	private ActivityState state;

	/**
	 * ANeBreB𐶐B
	 * 
	 * @param state	ANeBreB
	 */
	public ActivityElementImpl(ActivityState state)
	{
		setID(IDGenerator.generate(ID_PREFIX));
		setName(getID());
		setDescription("");
		setLimit(0);
		setLogicalX(0);
		setLogicalY(0);
		setExecution(SYNCHR);
		setActivityState(state);
	}

	/**
	 * ANeBreB𐶐B
	 * 
	 * @param act	XmlObject
	 */
	public ActivityElementImpl(ActivityDocument.Activity act)
	{
		String id = act.getId();
		if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(act.getName());
		setDescription(act.getDescription());

		try {
			setLimit(Integer.parseInt(act.getLimit()));
		} catch (Exception ex) {
			setLimit(0);
		}
	
		if (act.isSetBlockActivity()) {
			BlockActivityDocument.BlockActivity ba = act.getBlockActivity();
			setBlockID(ba.getBlockId());
		}
		
		if (act.isSetPerformer()) {
			setPerformerID(act.getPerformer());
		}
		
		if (act.isSetImplementation()) {
			ImplementationDocument.Implementation imp = act.getImplementation();
			if (imp.isSetSubFlow()) {
				SubFlowDocument.SubFlow sf = imp.getSubFlow();
				setSubprocessID(sf.getId());
				setExecution(sf.getExecution().intValue());
				if (sf.isSetActualParameters()) {
					ActualParametersDocument.ActualParameters aps = sf.getActualParameters();
					int count = aps.sizeOfActualParameterArray();
					for (int i = 0; i < count; i++) {
						String pid = aps.getActualParameterArray(i);
						addSubprocessParameterID(pid);
					}
				}
			}

			if (imp.sizeOfToolArray() == 1) {
				ToolDocument.Tool tool = imp.getToolArray(0);
				setApplicationID(tool.getId());
				if (tool.isSetActualParameters()) {
					ActualParametersDocument.ActualParameters aps = tool.getActualParameters();
					int count = aps.sizeOfActualParameterArray();
					for (int i = 0; i < count; i++) {
						String aid = aps.getActualParameterArray(i);
						addApplicationParameterID(aid);
					}
				}
			}
		}

		if (act.isSetExtendedAttributes()) {
			ExtendedAttributesDocument.ExtendedAttributes eas = act.getExtendedAttributes();
			int count = eas.sizeOfExtendedAttributeArray();
			for (int i = 0; i < count; i++) {
				ExtendedAttributeDocument.ExtendedAttribute ea = eas.getExtendedAttributeArray(i);
				String n = ea.getName();
				String v = ea.getValue();
				if (n.equals(LOGICAL_X)) {
					setLogicalX(Integer.parseInt(v));
				} else if (n.equals(LOGICAL_Y)) {
					setLogicalY(Integer.parseInt(v));
				} else if (n.equals(AFFILIATE_BID)) {
					setAffiliateBID(v);
				} else if (n.equals(PARENT_BID)) {
					setParentBID(v);
				} else if (n.equals(ACTIVITY_TYPE)) {
					ActivityStateFactory factory = ActivityStateFactory.getInstance();
					state = factory.createElement(v);
				} else if (n.equals(ENGINE_NANE)) {
					setEngineName(v);
				}
			}
		}
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * ANeBreBԂݒ肷B
	 * 
	 * @param state	ANeBreB
	 */
	private void setActivityState(ActivityState state)
	{
		this.state = state;
	}


	/**
	 * ANeBreBԂԂB
	 * 
	 * @return	ANeBreB
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getActivityState()
	 */
	public ActivityState getActivityState()
	{
		return state;
	}

	/**
	 * ubNIDԂB
	 * 
	 * @return ubNID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getBlockID()
	 */
	public String getBlockID()
	{
		return blockID;
	}

	/**
	 * sԂB
	 * 
	 * @return	s
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getLimit()
	 */
	public int getLimit()
	{
		return limit;
	}

	/**
	 * _XWԂB
	 * 
	 * @return _XW
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getLogicalX()
	 */
	public int getLogicalX()
	{
		return logicalX;
	}

	/**
	 * _YWԂB
	 * 
	 * @return _YW
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getLogicalY()
	 */
	public int getLogicalY()
	{
		return logicalY;
	}

	/**
	 * ANeBreB^ԂB
	 * 
	 * @return	ANeBreB^
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getType()
	 */
	public String getType()
	{
		return state.getType();
	}

	/**
	 * ubNIDݒ肷B
	 * 
	 * @param id ubNID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setBlockID(java.lang.String)
	 */
	public void setBlockID(String id)
	{
		this.blockID = id;
	}

	/**
	 * sݒ肷BPʂ͏vZXDurationUnitgpB
	 * 
	 * @param limit ҋ@Ԃ̏l
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setLimit(int)
	 */
	public void setLimit(int limit)
	{
		this.limit = limit;
	}

	/**
	 * _XWݒ肷B
	 * 
	 * @param x _XW
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setLogicalX(int)
	 */
	public void setLogicalX(int x)
	{
		this.logicalX = x;
	}

	/**
	 * _YWݒ肷B
	 * 
	 * @param y _YW
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setLogicalY(int)
	 */
	public void setLogicalY(int y)
	{
		this.logicalY = y;
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ANeBreB̂ԂB
	 * 
	 * @return ANeBreB
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setDescription(java.lang.String)
	 */
	public void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ANeBreB̂ݒ肷B
	 * 
	 * @param name ANeBreB
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setName(java.lang.String)
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * AvP[Vp[^ǉB
	 * 
	 * @param id	AvP[Vp[^
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#addApplicationParameterID(java.lang.String)
	 */
	public void addApplicationParameterID(String id)
	{
		this.applicationParameters.add(id);
	}

	/**
	 * TuvZXp[^ǉB
	 * 
	 * @param id	TuvZXp[^
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#addSubprocessParameterID(java.lang.String)
	 */
	public void addSubprocessParameterID(String id)
	{
		this.subprocessParameters.add(id);
	}

	/**
	 * AvP[VIDԂB
	 * 
	 * @return	AvP[VID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getApplicationID()
	 */
	public String getApplicationID()
	{
		return applicationID;
	}

	/**
	 * AvP[Vp[^ꗗԂB
	 * 
	 * @return	AvP[Vp[^ꗗ
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getApplicationParameters()
	 */
	public List getApplicationParameters()
	{
		return applicationParameters;
	}

	/**
	 * TuvZXIDԂB
	 * 
	 * @return	TuvZXID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getSubprocessID()
	 */
	public String getSubprocessID()
	{
		return subprocessID;
	}

	/**
	 * TuvZXp[^ꗗԂB
	 * 
	 * @return	TuvZXp[^ꗗ
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getSubprocessParameters()
	 */
	public List getSubprocessParameters()
	{
		return subprocessParameters;
	}

	/**
	 * AvP[Vp[^폜B
	 * 
	 * @param id	AvP[Vp[^
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#removeApplicationParameterID(java.lang.String)
	 */
	public void removeApplicationParameterID(String id)
	{
		this.applicationParameters.remove(id);
	}

	/**
	 * TuvZXp[^폜B
	 * 
	 * @param id	TuvZXp[^
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#removeSubprocessParameterID(java.lang.String)
	 */
	public void removeSubprocessParameterID(String id)
	{
		this.subprocessParameters.remove(id);
	}

	/**
	 * AvP[VIDݒ肷B
	 * 
	 * @param id	AvP[VID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setApplicationID(java.lang.String)
	 */
	public void setApplicationID(String id)
	{
		this.applicationID = id;
	}

	/**
	 * TuvZXIDݒ肷B
	 * 
	 * @param id	TuvZXID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setSubprocessID(java.lang.String)
	 */
	public void setSubprocessID(String id)
	{
		this.subprocessID = id;
	}

	/**
	 * TuvZXs̓ԂԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getExecution()
	 */
	public int getExecution()
	{
		return sync;
	}

	/**
	 * TuvZXs̓Ԃݒ肷B
	 * 
	 * @param sync 
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setExecution(int)
	 */
	public void setExecution(int sync)
	{
		this.sync = sync;
	}
	
	/**
	 * B
	 * 
	 * @return	ANeBreB
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#copy()
	 */
	public ActivityElement copy()
	{
		ActivityElement copy = new ActivityElementImpl(getActivityState());
		copy.setName(getName());
		copy.setDescription(getDescription());
		copy.setLimit(getLimit());
		copy.setLogicalX(getLogicalX());
		copy.setLogicalY(getLogicalY());
		copy.setExecution(getExecution());
		return copy;
	}

	/**
	 * ubNIDԂB
	 * 
	 * @return	ubNID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getAffiliateBID()
	 */
	public String getAffiliateBID()
	{
		return affiliateBID;
	}

	/**
	 * eubNIDԂB
	 * 
	 * @return	eubNID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getParentBID()
	 */
	public String getParentBID()
	{
		return parentBID;
	}

	/**
	 * ubNIDݒ肷B
	 * 
	 * @param id	ubNID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setAffiliateBID(java.lang.String)
	 */
	public void setAffiliateBID(String id)
	{
		affiliateBID = id;
	}

	/**
	 * eubNIDݒ肷B
	 * 
	 * @param id	eubNID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setParentBID(java.lang.String)
	 */
	public void setParentBID(String id)
	{
		parentBID = id;
	}

	/**
	 * sIDԂB
	 * 
	 * @return	sID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getPerformerID()
	 */
	public String getPerformerID()
	{
		return performerID;
	}

	/**
	 * sIDݒ肷B
	 * 
	 * @param id	sID
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setPerformerID(java.lang.String)
	 */
	public void setPerformerID(String id)
	{
		performerID = id;
	}

	/**
	 * GWԂB
	 *
	 * @return GW
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#getEngineName()
	 */
	public String getEngineName()
	{
		return engineName;
	}

	/**
	 * GWݒ肷B
	 * 
	 * @param engineName GW
	 * @see jp.co.argo21.nautica.tool.wfd.element.ActivityElement#setEngineName(java.lang.String)
	 */
	public void setEngineName(String engineName)
	{
		this.engineName = engineName;
	}

	/**
	 * c[{bNXԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getTooltipText(jp.co.argo21.commons.util.ResourceManager)
	 */
	public String getTooltipText(ResourceManager rm)
	{
		StringBuffer s = new StringBuffer();
		s = s.append("<html>");
		s = s.append("<b>").append(getName()).append("</b>");
		s = s.append("<table border>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ActivityElement.label.0"))
			.append("</td><td width=150>")
			.append(getID())
			.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ActivityElement.label.4"))
			.append("</td><td width=150>")
			.append(getDescription())
			.append("</td></tr>");
		s = s.append("</table>");
		s = s.append("</html>");
		return s.toString();
	}

	/**
	 * pԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getPrintText(jp.co.argo21.commons.util.ResourceManager)
	 */
	public String getPrintText(ResourceManager rm)
	{	
		StringBuffer s = new StringBuffer();
		return s.toString();
	}

	/**
	 * w肳ꂽvfgpǂԂB
	 *
	 * @param elem vf
	 * @return gpȂtrue
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#isUsed(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public boolean isUsed(Element elem)
	{
		if (elem == null) return false;
		
		String eid = elem.getID();
		ActivityState as = getActivityState();
		if (as instanceof InteractiveActivityState) {
			if (performerID != null) {
				if (performerID.equals(eid)) return true;
			}
		} else if (as instanceof AutomaticActivityState) {
			if (performerID != null) {
				if (performerID.equals(eid)) return true;
			}
			if (applicationID != null) {
				if (applicationID.equals(eid)) return true;
				
				Iterator tit = applicationParameters.iterator();
				while (tit.hasNext()) {
					String id = (String)tit.next();
					if (id != null) {
						if (id.equals(eid)) return true;
					}
				}
			}
		} else if (as instanceof SubprocessActivityState) {
			if (subprocessID != null) {
				if (subprocessID.equals(eid)) return true;

				Iterator tit = subprocessParameters.iterator();
				while (tit.hasNext()) {
					String id = (String)tit.next();
					if (id != null) {
						if (id.equals(eid)) return true;
					}
				}
			}
		}
		return false;
	}
}
