/* $Id: PackageElementImpl.java,v 1.4 2005/08/26 04:50:56 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.wfmc.x2002.xpdl10.ApplicationDocument;
import org.wfmc.x2002.xpdl10.ApplicationsDocument;
import org.wfmc.x2002.xpdl10.DataFieldDocument;
import org.wfmc.x2002.xpdl10.DataFieldsDocument;
import org.wfmc.x2002.xpdl10.PackageDocument;
import org.wfmc.x2002.xpdl10.PackageHeaderDocument;
import org.wfmc.x2002.xpdl10.ParticipantDocument;
import org.wfmc.x2002.xpdl10.ParticipantsDocument;
import org.wfmc.x2002.xpdl10.RedefinableHeaderDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessDocument;
import org.wfmc.x2002.xpdl10.WorkflowProcessesDocument;

import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

/**
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class PackageElementImpl implements PackageElement
{
	/** ̉ID */
	static private final String UNINITIALIZED_ID = "--UNINITIALIZED--"; 

	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** 쐬 */
	private String createdDate;
	/** o[W */
	private String version;
	/** ` */
	private String author;
	/** [Nt[Q҈ꗗ */
	private List participants = new ArrayList();
	/** AvP[Vꗗ */
	private List applications = new ArrayList();
	/** vZXϐꗗ */
	private List variables = new ArrayList();
	/** vZXꗗ */
	private List processes = new ArrayList();

	/**
	 * pbP[W𐶐B
	 * 
	 * @param n	
	 */
	public PackageElementImpl(String n)
	{
		setID(IDGenerator.generate(ID_PREFIX));
		setName(n);
		setDescription("");
		setCreatedDate("");
		setVersion("1.0");
		setAuthor(System.getProperty("user.name"));
	}

	/**
	 * pbP[W𐶐B
	 * 
	 * @param doc	XmlObject
	 */
	public PackageElementImpl(PackageDocument doc)
	{
		PackageDocument.Package p = doc.getPackage();
		String id = p.getId();
		if (StringUtils.checkNull(id) || id.equals(UNINITIALIZED_ID)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(p.getName());
		
		PackageHeaderDocument.PackageHeader phd = p.getPackageHeader();
		setDescription(phd.getDescription());
		setCreatedDate(phd.getCreated());
		
		if (p.isSetRedefinableHeader()) {
			RedefinableHeaderDocument.RedefinableHeader rhd
				= p.getRedefinableHeader();
			setAuthor(rhd.getAuthor());
			setVersion(rhd.getVersion());
		}
		
		if (p.isSetApplications()) {
			ApplicationsDocument.Applications apps = p.getApplications();
			int count = apps.sizeOfApplicationArray();
			for (int i = 0; i < count; i++) {
				ApplicationDocument.Application app = apps.getApplicationArray(i);
				ApplicationElement e = new ApplicationElementImpl(app);
				addApplication(e);
			}
		}
		
		if (p.isSetParticipants()) {
			ParticipantsDocument.Participants pts = p.getParticipants();
			int count = pts.sizeOfParticipantArray();
			for (int i = 0; i < count; i++) {
				ParticipantDocument.Participant pt = pts.getParticipantArray(i);
				ParticipantElement e = new ParticipantElementImpl(pt);
				addParticipant(e);
			}
		}
		
		if (p.isSetDataFields()) {
			DataFieldsDocument.DataFields dfs = p.getDataFields();
			int count = dfs.sizeOfDataFieldArray();
			for (int i = 0; i < count; i++) {
				DataFieldDocument.DataField df = dfs.getDataFieldArray(i);
				VariableElement e = new VariableElementImpl(df);
				addVariable(e);
			}
		}
		
		if (p.isSetWorkflowProcesses()) {
			WorkflowProcessesDocument.WorkflowProcesses wps = p.getWorkflowProcesses();
			int count = wps.sizeOfWorkflowProcessArray();
			for (int i = 0; i < count; i++) {
				WorkflowProcessDocument.WorkflowProcess proc = wps.getWorkflowProcessArray(i);
				ProcessElement e = new ProcessElementImpl(proc);
				addProcess(e);
			}
		}
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * AvP[VǉB
	 * 
	 * @param app	AvP[V
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#addApplication(jp.co.argo21.nautica.tool.wfd.element.ApplicationElement)
	 */
	public void addApplication(ApplicationElement app)
	{
		this.applications.add(app);
	}

	/**
	 * [Nt[Q҂ǉB
	 * 
	 * @param part	[Nt[Q
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#addParticipant(jp.co.argo21.nautica.tool.wfd.element.ParticipantElement)
	 */
	public void addParticipant(ParticipantElement part)
	{
		this.participants.add(part);
	}

	/**
	 * vZXǉB
	 * 
	 * @param proc	vZX
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#addProcess(jp.co.argo21.nautica.tool.wfd.element.ProcessElement)
	 */
	public void addProcess(ProcessElement proc)
	{
		this.processes.add(proc);
	}

	/**
	 * vZXϐǉB
	 * 
	 * @param var	vZXϐ
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#addVariable(jp.co.argo21.nautica.tool.wfd.element.VariableElement)
	 */
	public void addVariable(VariableElement var)
	{
		this.variables.add(var);
	}

	/**
	 * AvP[V폜B
	 * 
	 * @param app	AvP[V
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#removeApplication(jp.co.argo21.nautica.tool.wfd.element.ApplicationElement)
	 */
	public void removeApplication(ApplicationElement app)
	{
		this.applications.remove(app);
	}

	/**
	 * [Nt[Q҂폜B
	 * 
	 * @param part	[Nt[Q
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#removeParticipant(jp.co.argo21.nautica.tool.wfd.element.ParticipantElement)
	 */
	public void removeParticipant(ParticipantElement part)
	{
		this.participants.remove(part);
	}

	/**
	 * vZX폜B
	 * 
	 * @param proc	vZX
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#removeProcess(jp.co.argo21.nautica.tool.wfd.element.ProcessElement)
	 */
	public void removeProcess(ProcessElement proc)
	{
		this.processes.remove(proc);
	}

	/**
	 * vZXϐ폜B
	 * 
	 * @param var	vZXϐ
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#removeVariable(jp.co.argo21.nautica.tool.wfd.element.VariableElement)
	 */
	public void removeVariable(VariableElement var)
	{
		this.variables.remove(var);
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setDescription(java.lang.String)
	 */
	public void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ̂ݒ肷B
	 * 
	 * @param name 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setName(java.lang.String)
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * AvP[VꗗԂB
	 * 
	 * @return	AvP[Vꗗ
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#getApplications()
	 */
	public List getApplications()
	{
		return applications;
	}

	/**
	 * 쐬ԂB
	 * 
	 * @return	쐬
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#getCreatedDate()
	 */
	public String getCreatedDate()
	{
		return createdDate;
	}

	/**
	 * [Nt[Q҈ꗗԂB
	 * 
	 * @return	[Nt[Q҈ꗗ
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#getParticipants()
	 */
	public List getParticipants()
	{
		return participants;
	}

	/**
	 * vZXꗗԂB
	 * 
	 * @return	vZXꗗ
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#getProcesses()
	 */
	public List getProcesses()
	{
		return processes;
	}

	/**
	 * vZXϐꗗԂB
	 * 
	 * @return	vZXϐꗗ
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#getVariables()
	 */
	public List getVariables()
	{
		return variables;
	}

	/**
	 * o[WԂB
	 * 
	 * @return	o[W
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#getVersion()
	 */
	public String getVersion()
	{
		return version;
	}

	/**
	 * 쐬ݒ肷B
	 * 
	 * @param s	쐬
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#setCreatedDate(java.lang.String)
	 */
	public void setCreatedDate(String s)
	{
		createdDate = s;
	}

	/**
	 * o[Wݒ肷B
	 * 
	 * @param s	o[W
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#setVersion(java.lang.String)
	 */
	public void setVersion(String s)
	{
		version = s;
	}

	/**
	 * `҂ԂB
	 * 
	 * @return	`
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#getAuthor()
	 */
	public String getAuthor()
	{
		return author;
	}

	/**
	 * `҂ݒ肷B
	 * 
	 * @param s	`
	 * @see jp.co.argo21.nautica.tool.wfd.element.PackageElement#setAuthor(java.lang.String)
	 */
	public void setAuthor(String s)
	{
		author = s;
	}

	/**
	 * c[{bNXԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getTooltipText(jp.co.argo21.commons.util.ResourceManager)
	 */
	public String getTooltipText(ResourceManager rm)
	{
		StringBuffer s = new StringBuffer();
		s = s.append("<html>");
		s = s.append("<b>").append(getName()).append("</b>");
		s = s.append("<table border>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("PackageElement.label.0"))
			.append("</td><td width=150>")
			.append(getID())
			.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("PackageElement.label.5"))
			.append("</td><td width=150>")
			.append(getDescription())
			.append("</td></tr>");
		s = s.append("</table>");
		s = s.append("</html>");
		return s.toString();
	}

	/**
	 * pԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getPrintText(jp.co.argo21.commons.util.ResourceManager)
	 */
	public String getPrintText(ResourceManager rm)
	{	
		StringBuffer s = new StringBuffer();
		return s.toString();
	}

	/**
	 * w肳ꂽvfgpǂԂB
	 *
	 * @param elem vf
	 * @return gpȂtrue
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#isUsed(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public boolean isUsed(Element elem)
	{
		if (elem == null) return false;
		
		Iterator it = processes.iterator();
		
		while (it.hasNext()) {
			Element e = (Element)it.next();
			boolean isUsed = e.isUsed(elem);
			if (isUsed) return true;
		}
		return false;
	}
}
