/* $Id: ParticipantElementImpl.java,v 1.4 2005/08/26 04:51:00 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import org.wfmc.x2002.xpdl10.ParticipantDocument;
import org.wfmc.x2002.xpdl10.ParticipantTypeDocument;

import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;

/**
 * [Nt[Q
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class ParticipantElementImpl implements ParticipantElement
{
	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** QҌ^ */
	private int type;
	
	/**
	 * [Nt[Q҂𐶐B
	 * 
	 * @param n	
	 */
	public ParticipantElementImpl(String n)
	{
		setID(IDGenerator.generate(ID_PREFIX));
		setName(n);
		setDescription("");
		setType(SYSTEM);
	}
	
	/**
	 * [Nt[Q҂𐶐B
	 * 
	 * @param pt	XmlObject
	 */
	public ParticipantElementImpl(ParticipantDocument.Participant pt)
	{
		String id = pt.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(pt.getName());
		setDescription(pt.getDescription());
		
		ParticipantTypeDocument.ParticipantType ptype = pt.getParticipantType();
		ParticipantTypeDocument.ParticipantType.Type.Enum type = ptype.getType();
		setType(type.intValue());
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * QҌ^ԂB
	 * 
	 * @return	QҌ^
	 * @see jp.co.argo21.nautica.tool.wfd.element.ParticipantElement#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * QҌ^ݒ肷B
	 * 
	 * @param type	QҌ^
	 * @see jp.co.argo21.nautica.tool.wfd.element.ParticipantElement#setType(int)
	 */
	public void setType(int type)
	{
		this.type = type;
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setDescription(java.lang.String)
	 */
	public void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ̂ݒ肷B
	 * 
	 * @param name 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setName(java.lang.String)
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * c[{bNXԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getTooltipText(jp.co.argo21.commons.util.ResourceManager)
	 */
	public String getTooltipText(ResourceManager rm)
	{
		StringBuffer s = new StringBuffer();
		s = s.append("<html>");
		s = s.append("<b>").append(getName()).append("</b>");
		s = s.append("<table border>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ParticipantElement.label.0"))
			.append("</td><td width=150>")
			.append(getID())
			.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ParticipantElement.label.2"))
			.append("</td><td width=150>");
		int t = getType();
		if (t == ParticipantElement.ROLE) {
			s = s.append(rm.getResource("ParticipantElement.type.0"));
		} else if (t == ParticipantElement.ORGANIZATIONAL_UNIT) {
			s = s.append(rm.getResource("ParticipantElement.type.1"));
		} else if (t == ParticipantElement.HUMAN) {
			s = s.append(rm.getResource("ParticipantElement.type.2"));
		} else if (t == ParticipantElement.SYSTEM) {
			s = s.append(rm.getResource("ParticipantElement.type.3"));
		} else {
			s = s.append(rm.getResource("ParticipantElement.type.3"));
		}
		s = s.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("ParticipantElement.label.3"))
			.append("</td><td width=150>")
			.append(getDescription())
			.append("</td></tr>");
		s = s.append("</table>");
		s = s.append("</html>");
		return s.toString();
	}

	/**
	 * pԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getPrintText(jp.co.argo21.commons.util.ResourceManager)
	 */
	public String getPrintText(ResourceManager rm)
	{	
		StringBuffer s = new StringBuffer();
		return s.toString();
	}

	/**
	 * w肳ꂽvfgpǂԂB
	 *
	 * @param elem vf
	 * @return gpȂtrue
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#isUsed(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public boolean isUsed(Element elem)
	{
		return false;
	}
}
