/* $Id: TransitionElementImpl.java,v 1.7 2005/08/26 04:51:05 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2002.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.element.impl;

import java.util.Iterator;
import java.util.List;

import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.wfmc.x2002.xpdl10.ConditionDocument;
import org.wfmc.x2002.xpdl10.TransitionDocument;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.expression.ExceptionExpression;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.tool.wfd.expression.LogicalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.OtherwiseExpression;
import jp.co.argo21.nautica.tool.wfd.expression.RelationalExpression;
import jp.co.argo21.nautica.tool.wfd.expression.UnaryExpression;
import jp.co.argo21.nautica.workflow.xpdl.ConditionalExpressionDocument;
import jp.co.argo21.commons.util.IDGenerator;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;

/**
 * J
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.7 $
 * @since   Nautica Workflow 0.9
 */
public class TransitionElementImpl implements TransitionElement
{
	/** ID */
	private String id;
	/**  */
	private String name;
	/** l */
	private String description;
	/** JڌANeBreB */
	private ActivityElement source;
	/** JڐANeBreB */
	private ActivityElement destination;
	/** Jڏ */
	private Expression condition;
	/** Jڌ^ */
	private int type;

	/**
	 * Jڂ𐶐B
	 * 
	 * @param s	JڌANeBreB
	 * @param d	JڐANeBreB
	 */
	public TransitionElementImpl(ActivityElement s, ActivityElement d)
	{
		setID(IDGenerator.generate(ID_PREFIX));
		setName("");
		setDescription("");
		setSource(s);
		setDestination(d);
		setType(CONDITION);
		setCondition(null);
	}

	/**
	 * Jڂ𐶐B
	 * 
	 * @param tr	XmlObject
	 * @param acts	ANeBreBꗗ
	 */
	public TransitionElementImpl(TransitionDocument.Transition tr, List acts)
	{
		String id = tr.getId();
		if (StringUtils.checkNull(id)) {
			setID(IDGenerator.generate(ID_PREFIX));
		} else {
			setID(id);
		}
		setName(tr.getName());
		setDescription(tr.getDescription());
		
		String sid = tr.getFrom();
		setSource(getActivityElement(acts, sid));
		
		String did = tr.getTo();
		setDestination(getActivityElement(acts, did));
		
		if (tr.isSetCondition()) {
			ConditionDocument.Condition c = tr.getCondition();
			int type = c.getType().intValue();
			try {
				if (type == CONDITION) {
					XmlObject obj = XmlObject.Factory.parse(c.toString());
					//lݒ肳Ăꍇ̂ConditionalExpressionDocument^
					//IuWFNgԂĂB
					if (obj == null) {
						setCondition(null);
					} else if (obj instanceof ConditionalExpressionDocument) {
						ConditionalExpressionDocument ceDoc
							= (ConditionalExpressionDocument)obj;
						ConditionalExpressionDocument.ConditionalExpression ce
							= ceDoc.getConditionalExpression();
						if (ce.isSetRelationalExpression()) {
							setCondition(new RelationalExpression(ce.getRelationalExpression()));
						} else if (ce.isSetUnaryExpression()) {
							setCondition(new UnaryExpression(ce.getUnaryExpression()));
						} else if (ce.isSetLogicalExpression()) {
							setCondition(new LogicalExpression(ce.getLogicalExpression()));
						}
					} else {
						setCondition(null);
					}
				} else if (type == OTHERWISE) {
					setCondition(new OtherwiseExpression());
				} else if (type == EXCEPTION) {
					setCondition(new ExceptionExpression());
				}
			} catch (XmlException ex) {
				//NOP
			}
		} else {
			setCondition(null);
		}
	}

	/**
	 * IDݒ肷B
	 * 
	 * @param id	ID
	 */	
	private void setID(String id)
	{
		this.id = id;
	}

	/**
	 * JڌANeBreBݒ肷B
	 * 
	 * @param act	JڌANeBreB
	 */
	private void setSource(ActivityElement act)
	{
		this.source = act;
	}

	/**
	 * JڐANeBreBݒ肷B
	 * 
	 * @param act	JڐANeBreB
	 */
	private void setDestination(ActivityElement act)
	{
		this.destination = act;
	}

	/**
	 * w肳ꂽIDANeBreBԂB
	 * 
	 * @param acts	ANeBreBꗗ
	 * @param id	ANeBreBID
	 * @return	ANeBreB
	 */
	private ActivityElement getActivityElement(List acts, String id)
	{
		Iterator it = acts.iterator();
		while (it.hasNext()) {
			ActivityElement act = (ActivityElement)it.next();
			String aid = act.getID();
			if (id.equals(aid)) return act;
		}
		return null;
	}

	/**
	 * ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getDescription()
	 */
	public String getDescription()
	{
		return description;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getID()
	 */
	public String getID()
	{
		return id;
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getName()
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * ݒ肷B
	 * 
	 * @param desc 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setDescription(java.lang.String)
	 */
	public void setDescription(String desc)
	{
		this.description = desc;
	}

	/**
	 * ̂ݒ肷B
	 * 
	 * @param name 
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#setName(java.lang.String)
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * JڏԂB
	 * 
	 * @return	Jڏ
	 * @see jp.co.argo21.nautica.tool.wfd.element.TransitionElement#getCondition()
	 */
	public Expression getCondition()
	{
		return condition;
	}

	/**
	 * JڐANeBreBԂB
	 * 
	 * @return	JڐANeBreB
	 * @see jp.co.argo21.nautica.tool.wfd.element.TransitionElement#getDestination()
	 */
	public ActivityElement getDestination()
	{
		return destination;
	}

	/**
	 * JڌANeBreBԂB
	 * 
	 * @return	JڌANeBreB
	 * @see jp.co.argo21.nautica.tool.wfd.element.TransitionElement#getSource()
	 */
	public ActivityElement getSource()
	{
		return source;
	}

	/**
	 * Jڌ^ԂB
	 * 
	 * @return	Jڌ^
	 * @see jp.co.argo21.nautica.tool.wfd.element.TransitionElement#getType()
	 */
	public int getType()
	{
		return type;
	}

	/**
	 * Jڏݒ肷B
	 * 
	 * @param cond	Jڏ
	 * @see jp.co.argo21.nautica.tool.wfd.element.TransitionElement#setCondition(jp.co.argo21.nautica.tool.wfd.expression.Expression)
	 */
	public void setCondition(Expression cond)
	{
		if (cond == null) {
			type = CONDITION;
		} else if (cond instanceof OtherwiseExpression) {
			type = OTHERWISE;
		} else if (cond instanceof ExceptionExpression) {
			type = EXCEPTION;
		} else {
			type = CONDITION;
		}
		condition = cond;
	}

	/**
	 * Jڌ^ݒ肷B
	 * 
	 * @param i	Jڌ^
	 * @see jp.co.argo21.nautica.tool.wfd.element.TransitionElement#setType(int)
	 */
	public void setType(int i)
	{
		type = i;
	}

	/**
	 * c[{bNXԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getTooltipText(jp.co.argo21.commons.util.ResourceManager)
	 */
	public String getTooltipText(ResourceManager rm)
	{
		StringBuffer s = new StringBuffer();
		s = s.append("<html>");
		s = s.append("<b>").append(getName()).append("</b>");
		s = s.append("<table border>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("TransitionElement.label.0"))
			.append("</td><td width=150>")
			.append(getID())
			.append("</td></tr>");
		s = s.append("<tr><td width=100>")
			.append(rm.getResource("TransitionElement.label.3"))
			.append("</td><td width=150>")
			.append(getDescription())
			.append("</td></tr>");
		s = s.append("</table>");
		s = s.append("</html>");
		return s.toString();
	}

	/**
	 * pԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#getPrintText(jp.co.argo21.commons.util.ResourceManager)
	 */
	public String getPrintText(ResourceManager rm)
	{	
		StringBuffer s = new StringBuffer();
		return s.toString();
	}

	/**
	 * w肳ꂽvfgpǂԂB
	 *
	 * @param elem vf
	 * @return gpȂtrue
	 * @see jp.co.argo21.nautica.tool.wfd.element.Element#isUsed(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public boolean isUsed(Element elem)
	{
		if (elem == null) return false;
		if (elem == source) return true;
		if (elem == destination) return true;
		return false;
	}
}
