/* $Id: ConditionalVariable.java,v 1.3 2005/08/26 04:51:18 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.expression;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

/**
 * ]ɗpϐ̊i[pB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ConditionalVariable
{
	/** STRING */
	static public final int STRING  = VariableElement.STRING;
	/** INTEGER */
	static public final int INTEGER = VariableElement.INTEGER;
	/** BOOLEAN */
	static public final int BOOLEAN = VariableElement.BOOLEAN;

	/** ϐ */
	private VariableElement var;
	/** l */
	private String value;

	/**
	 * ]ɗpϐ̊i[pꎞϐ𐶐B
	 * 
	 * @param var	ƂȂϐ
	 */
	public ConditionalVariable(VariableElement var)
	{
		this.var = var;
		this.value = var.getInitialValue();
	}

	/**
	 * ]ɗpϐ̊i[pꎞϐ𐶐B
	 * 
	 * @param var	ƂȂϐ
	 * @param value	l
	 */
	public ConditionalVariable(VariableElement var, String value)
	{
		this.var = var;
		this.value = value;
	}

	/**
	 * IDԂB
	 * 
	 * @return ID
	 */
	public String getID()
	{
		return var.getID();
	}

	/**
	 * ̂ԂB
	 * 
	 * @return 
	 */
	public String getName()
	{
		return var.getName();
	}

	/**
	 * ^ԂB
	 * 
	 * @return	^
	 */
	public int getType()
	{
		return var.getType();
	}

	/**
	 * c[`bvԂB
	 * 
	 * @param rm	\[X}l[W
	 * @return	c[`bv
	 */
	public String getTooltipText(ResourceManager rm)
	{
		return var.getTooltipText(rm);
	}

	/**
	 * lԂB
	 * 
	 * @return l
	 */
	public String getValue()
	{
		return value;
	}

	/**
	 * lݒ肷B
	 * 
	 * @return l
	 */
	public void setValue(String v)
	{
		value = v;
	}
}

