/* $Id: AbstractElementInspector.java,v 1.3 2005/08/26 04:50:36 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.JTabbedPane;

import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * vfpCXyN^̂߂̒ۃNX
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public abstract class AbstractElementInspector extends JTabbedPane implements Inspector
{
	/** Xi[ */
	private List listeners = new ArrayList();

	/** Ώۗvf */
	private Element inspectable;

	/**
	 * ΏۗvfԂB
	 * 
	 * @return	vf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#getInspectable()
	 */
	public Element getInspectable()
	{
		return inspectable;
	}
	
	/**
	 * CXyNgΏۂݒ肷B
	 * 
	 * @param elem	Ώۗvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public void setInspectable(Element elem)
	{
		inspectable = elem;
	}

	/**
	 * CXyN^R~bg邩ǂԂB
	 * 
	 * @return	R~bg̏ꍇɂtrue
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#isAutoCommit()
	 */
	public boolean isAutoCommit()
	{
		return false;
	}

	/**
	 * Xi[ǉB
	 * 
	 * @param l Xi[
	 */
	public void addChangeElementListener(ChangeElementListener l)
	{
		if (listeners.contains(l) == false) listeners.add(l);
	}

	/**
	 * Xi[폜B
	 * 
	 * @param l Xi[
	 */
	public void removeChangeElementListener(ChangeElementListener l)
	{
		if (listeners.contains(l)) listeners.remove(l);
	}

	/**
	 * Xi[ɗvf̕ύX𓯕񂷂B
	 */
	protected void fireElementChanged()
	{
		Iterator it = listeners.iterator();
		while (it.hasNext()) {
			ChangeElementListener l = (ChangeElementListener)it.next();
			l.elementChanged(inspectable);
		}
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		//NOP
	}

	/**
	 * CXyN^̃A[hsB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#unload()
	 */
	public void unload()
	{
		//NOP
	}
}
