/* $Id: ApplicationInspector.java,v 1.4 2005/08/26 04:50:30 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;

import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ApplicationElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;

/**
 * AvP[VpCXyN^
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class ApplicationInspector extends AbstractElementInspector
{
	/** e[u̗ */
	static private String[] columnNames;

	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();


	/** ACR\GA */
	private IconView iconView;
	/** ID\GA */
	private JLabel idField;
	/** ̕\GA */
	private JTextField nameField;
	/** l\GA */
	private JTextField descriptionField;
	/** p[^Xg */
	private JTable paramTable;
	/** p[^ǉ{^ */
	private JButton addParamButton;
	/** p[^ҏW{^ */
	private JButton editParamButton;
	/** p[^폜{^ */
	private JButton delParamButton;
	
	/**
	 * 萔
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		columnNames = new String[3];
		columnNames[0] = rm.getResource("ParamTableModel.columnName.0");
		columnNames[1] = rm.getResource("ParamTableModel.columnName.1");
		columnNames[2] = rm.getResource("ParamTableModel.columnName.2");
	}

	/**
	 * AvP[VpCXyN^𐶐B
	 */
	public ApplicationInspector()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel0 = createBasicInfoPanel(rm);
		addTab(rm.getResource("ApplicationInspector.tab.0"), panel0);

		JPanel panel1 = createParamInfoPanel(rm);
		addTab(rm.getResource("ApplicationInspector.tab.1"), panel1);

		validate();
	}
	
	/**
	 * {̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createBasicInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 110);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ApplicationInspector.label.0"));
		JLabel l1 = new JLabel(rm.getResource("ApplicationInspector.label.1"));
		JLabel l2 = new JLabel(rm.getResource("ApplicationInspector.label.2"));

		iconView = new IconView();
		iconView.setIconName(WorkflowDesignerConstants.EL_APPLICATION);
		idField = new JLabel();
		idField.setBorder(border);
		nameField = new JTextField();
		nameField.setDocument(new ByteLimitedDocument(64));
		descriptionField = new JTextField();
		descriptionField.setDocument(new ByteLimitedDocument(128));

		panel.add(locate(iconView,          10,  10,  60,  60));
		panel.add(locate(l0,                80,  10, 100,  25));
		panel.add(locate(l1,                80,  40, 100,  25));
		panel.add(locate(l2,                80,  70, 100,  25));
		panel.add(locate(idField,          180,  10, 190,  25));
		panel.add(locate(nameField,        180,  40, 190,  25));
		panel.add(locate(descriptionField, 180,  70, 190,  25));

		validate();
		
		return panel;
	}
	
	/**
	 * p[^̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createParamInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 200);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ApplicationInspector.label.3"));

		paramTable = new JTable(new ParamTableModel());
		paramTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(paramTable);
		addParamButton = new JButton(rm.getResource("JButton.label.add"));
		addParamButton.addActionListener(new AddParamAction());
		editParamButton = new JButton(rm.getResource("JButton.label.edit"));
		editParamButton.addActionListener(new EditParamAction());
		delParamButton = new JButton(rm.getResource("JButton.label.delete"));
		delParamButton.addActionListener(new DeleteParamAction());

		panel.add(locate(l0,                10,  10, 100,  25));
		panel.add(locate(sp,                10,  40, 270, 145));
		panel.add(locate(addParamButton,   290,  40,  80,  25));
		panel.add(locate(editParamButton,  290,  70,  80,  25));
		panel.add(locate(delParamButton,   290, 100,  80,  25));

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		super.init();

		nameField.setText("");
		descriptionField.setText("");
		paramTable.clearSelection();
	}

	/**
	 * CXyNgΏۂݒ肷B
	 * 
	 * @param elem	Ώۗvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */	
	public void setInspectable(Element elem)
	{
		super.setInspectable(elem);

		if (elem != null) {
			if (elem instanceof ApplicationElement) {
				ApplicationElement app = (ApplicationElement)elem;
				idField.setText(app.getID());
				nameField.setText(app.getName());
				descriptionField.setText(app.getDescription());
			}
		}
		setSelectedIndex(0);
	}

	/**
	 * ݒl`FbNB
	 * 
	 * @return	`FbN
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#check()
	 */	
	public boolean check()
	{
		return true;
	}

	/**
	 * ݒlR~bgB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */	
	public void commit()
	{
		Element e = getInspectable();
		if (e != null) {
			if (e instanceof ApplicationElement) {
				ApplicationElement app = (ApplicationElement)e;
				app.setName(nameField.getText());
				app.setDescription(descriptionField.getText());
				fireElementChanged();
			}
		}		
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	protected Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}

	/**
	 * p[^ǉ
	 */	
	class AddParamAction extends AbstractAction
	{
		/**
		 * p[^ǉ
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			Element newElem = InspectorDialog.showDialog(ApplicationInspector.this, WorkflowDesignerConstants.EL_PARAMETER);
			if (newElem == null) return;
			
			Element app = getInspectable();
			if (app == null) return;

			((ApplicationElement)app).addParameter((ParameterElement)newElem);
			paramTable.clearSelection();
			paramTable.updateUI();
		}
	}

	/**
	 * p[^ҏW
	 */
	class EditParamAction extends AbstractAction
	{
		/**
		 * p[^ҏW
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = paramTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
				return;
			}
			Element app = getInspectable();
			if (app == null) return;

			List list = ((ApplicationElement)app).getParameters();
			ParameterElement p = (ParameterElement)list.get(selected);
			InspectorDialog.showDialog(ApplicationInspector.this, p);
			paramTable.clearSelection();
			paramTable.updateUI();
		}
	}

	/**
	 * p[^폜
	 */	
	class DeleteParamAction extends AbstractAction
	{
		/**
		 * p[^폜
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = paramTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
				return;
			}
			Element app = getInspectable();
			if (app == null) return;

			List list = ((ApplicationElement)app).getParameters();
			ParameterElement p = (ParameterElement)list.remove(selected);
			paramTable.clearSelection();
			paramTable.updateUI();
		}
	}
	
	/**
	 * p[^e[u䃂f
	 */
	class ParamTableModel extends AbstractTableModel
	{
		/**
		 * p[^e[u䃂f𐶐B
		 */
		ParamTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return 3;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			Element e = getInspectable();
			if (e == null) return 0;
			
			return ((ApplicationElement)e).getParameters().size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * Z̓eԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			Element e = getInspectable();
			if (e == null) return "";

			List list = ((ApplicationElement)e).getParameters();
			ParameterElement p = (ParameterElement)list.get(row);
			if (col == 0) {
				int m = p.getMode();
				if (m == ParameterElement.IN) {
					return ParameterInspector.PARAM_MODES[0];
				} else if (m == ParameterElement.OUT) {
					return ParameterInspector.PARAM_MODES[1];
				} else if (m == ParameterElement.INOUT) {
					return ParameterInspector.PARAM_MODES[2];
				}
			} else if (col == 1) {
				int t = p.getType();
				if (t == ParameterElement.STRING) {
					return ParameterInspector.PARAM_TYPES[0];
				} else if (t == ParameterElement.INTEGER) {
					return ParameterInspector.PARAM_TYPES[1];
				} else if (t == ParameterElement.BOOLEAN) {
					return ParameterInspector.PARAM_TYPES[2];
				}
			} else if (col == 2) {
				return p.getDescription();
			}
			return "";
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}
}
