/* $Id: ConcurrentActivityInspector.java,v 1.3 2005/08/26 04:50:40 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * sANeBreBp̃CXyN^
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ConcurrentActivityInspector extends TransitionalActivityInspector
{
	/** ubNID\GA */
	private JLabel blockIDField;

	/**
	 * sANeBreBp̃CXyN^ʂ𐶐B
	 */
	public ConcurrentActivityInspector()
	{
		super();
		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel = createConcurrentInfoPanel(rm);
		addTab(rm.getResource("ConcurrentActivityInspector.tab.0"), panel);

		validate();
	}
	
	/**
	 * {̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createConcurrentInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
		Dimension size = new Dimension(380, 50);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ConcurrentActivityInspector.label.0"));

		blockIDField = new JLabel();
		blockIDField.setBorder(border);

		panel.add(locate(l0,            10,  10, 100, 25));
		panel.add(locate(blockIDField, 110,  10, 260, 25));

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		super.init();

		blockIDField.setText("");
	}
	
	/**
	 * ҏWꂽANeBreBvfɔfB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */
	public void commit()
	{
		super.commit();
		Element e = getInspectable();
		if (e != null) {
			if (e instanceof ActivityElement) {
				ActivityElement act = (ActivityElement)e;
			}
		}		
	}
	
	/**
	 * ANeBreBvf̏CXyN^ɔfB
	 * 
	 * @param elem ANeBreBvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public final void setInspectable(Element elem)
	{
		super.setInspectable(elem);
		if (elem != null) {
			if (elem instanceof ActivityElement) {
				ActivityElement act = (ActivityElement)elem;
				blockIDField.setText(act.getBlockID());
			}
		}
	}
}
