/* $Id: InteractiveActivityInspector.java,v 1.3 2005/08/26 04:50:38 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Dimension;
import java.util.Iterator;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.border.EtchedBorder;

import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.ElementReceivableView;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;

/**
 * Θb^ANeBreBp̃CXyN^
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class InteractiveActivityInspector extends TransitionalActivityInspector
{
	/** s\GA */
	private JTextField limitField;
	/** Pʕ\GA */
	private JLabel unitField;
	/** s\GA */
	private ElementReceivableView performerIconField;
	/** sID\GA */
	private JLabel performerIDField;
	/** s\GA */
	private JLabel performerNameField;
	
	/** vZXύX */
	private ChangeProcessElementAction changeProcAction;
	/** sҕύX */
	private ChangeParticipantElementAction changePartAction;

	/** s */
	private ParticipantElement performer;

	/**
	 * Θb^ANeBreBp̃CXyN^ʂ𐶐B
	 */
	public InteractiveActivityInspector()
	{
		super();
		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		changeProcAction = new ChangeProcessElementAction();
		changePartAction = new ChangeParticipantElementAction();

		JPanel panel = createInteractiveInfoPanel(rm);
		addTab(rm.getResource("InteractiveActivityInspector.tab.0"), panel);

		validate();
	}
	
	/**
	 * {̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createInteractiveInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
		Dimension size = new Dimension(380, 210);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("InteractiveActivityInspector.label.0"));
		JLabel l1 = new JLabel(rm.getResource("InteractiveActivityInspector.label.1"));
		JLabel l2 = new JLabel(rm.getResource("InteractiveActivityInspector.label.2"));
		JLabel l3 = new JLabel(rm.getResource("InteractiveActivityInspector.label.3"));

		limitField = new JTextField();
		limitField.setHorizontalAlignment(SwingConstants.RIGHT);
		limitField.setDocument(new NumericDocument(3, true, true));
		unitField = new JLabel();
		performerIconField = new ElementReceivableView(WorkflowDesignerConstants.EL_PARTICIPANT);
		performerIconField.addChangeElementListener(changePartAction);
		performerIDField = new JLabel();
		performerIDField.setBorder(border);
		performerNameField = new JLabel();
		performerNameField.setBorder(border);

		panel.add(locate(l0,                  10,  10, 100, 25));
		panel.add(locate(limitField,         110,  10,  70, 25));
		panel.add(locate(unitField,          180,  10,  70, 25));
		panel.add(locate(l1,                  10,  40, 100, 25));
		panel.add(locate(performerIconField,  10,  70,  60, 60));
		panel.add(locate(l2,                  80,  72, 100, 25));
		panel.add(locate(l3,                  80, 102, 100, 25));
		panel.add(locate(performerIDField,   180,  72, 190, 25));
		panel.add(locate(performerNameField, 180, 102, 190, 25));

		validate();
		
		return panel;
	}
	
	/**
	 * ҏWꂽANeBreBvfɔfB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */
	public void commit()
	{
		super.commit();
		Element e = getInspectable();
		if (e != null) {
			if (e instanceof ActivityElement) {
				ActivityElement act = (ActivityElement)e;
				try {
					int limit = Integer.parseInt(limitField.getText());
					act.setLimit(limit);
				} catch (Exception ex) {
					act.setLimit(0);
				}
				if (performer != null) {
					act.setPerformerID(performer.getID());
				} else {
					act.setPerformerID(null);
				}
			}
		}		
	}
	
	/**
	 * ANeBreBvf̏CXyN^ɔfB
	 * 
	 * @param elem ANeBreBvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public final void setInspectable(Element elem)
	{
		super.setInspectable(elem);
		if (elem != null) {
			if (elem instanceof ActivityElement) {
				PackageElement pkg = WorkflowDesignerManager.getMainFrame().getPackage();
				updateDurationUnit(null);
				ActivityElement act = (ActivityElement)elem;
				limitField.setText("" + act.getLimit());
				String pfid = act.getPerformerID();
				if (StringUtils.checkNull(pfid) == false) {
					Iterator it = pkg.getParticipants().iterator();
					while (it.hasNext()) {
						ParticipantElement e = (ParticipantElement)it.next();
						if (pfid.equals(e.getID())) {
							performer = e;
							break;
						} 
					}
					performerIconField.setElement(performer);
					updatePerformerInfo();
				}
			}
		}
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		super.init();

		unitField.setText("");
		performerIDField.setText("");
		performerNameField.setText("");
		limitField.setText("0");
		performerIconField.setElement(null);
		performer = null;

		InspectorDialog.addChangeElementListener(WorkflowDesignerConstants.EL_PROCESS, changeProcAction);
		InspectorDialog.addChangeElementListener(WorkflowDesignerConstants.EL_PARTICIPANT, changePartAction);
	}

	/**
	 * CXyN^̃A[hsB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#unload()
	 */
	public void unload()
	{
		InspectorDialog.removeChangeElementListener(WorkflowDesignerConstants.EL_PROCESS, changeProcAction);
		InspectorDialog.removeChangeElementListener(WorkflowDesignerConstants.EL_PARTICIPANT, changePartAction);
	}
	
	/**
	 * s҂XVB
	 */
	private void updatePerformerInfo()
	{
		if (performer != null) {
			performerIDField.setText(performer.getID());
			performerNameField.setText(performer.getName());
		}
	}
	
	/**
	 * ԒPʂXVB
	 * 
	 * @param p	vZX
	 */
	private void updateDurationUnit(ProcessElement p)
	{
		ProcessElement proc = p;
		if (proc == null) {
			DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
			ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
		
			if (frame == null) return;
		
			proc = frame.getProcess();
		}
		int u = proc.getDurationUnit();
		if (u == ProcessElement.YEAR) {
			unitField.setText(ProcessInspector.DURATION_UNITS[0]);
		} else if (u == ProcessElement.MONTH) {
			unitField.setText(ProcessInspector.DURATION_UNITS[1]);
		} else if (u == ProcessElement.DAY) {
			unitField.setText(ProcessInspector.DURATION_UNITS[2]);
		} else if (u == ProcessElement.HOUR) {
			unitField.setText(ProcessInspector.DURATION_UNITS[3]);
		} else if (u == ProcessElement.MINUTE) {
			unitField.setText(ProcessInspector.DURATION_UNITS[4]);
		} else if (u == ProcessElement.SECOND) {
			unitField.setText(ProcessInspector.DURATION_UNITS[5]);
		} else {
			unitField.setText(ProcessInspector.DURATION_UNITS[2]);
		}
	}

	/**
	 * vZXύX
	 */
	class ChangeProcessElementAction implements ChangeElementListener
	{
		/**
		 * vZX̕ύX𔽉fB
		 * 
		 * @param elem	vZX
		 * @see jp.co.argo21.nautica.tool.wfd.dnd.DropElementListener#elementDropped(jp.co.argo21.nautica.tool.wfd.element.Element)
		 */
		public void elementChanged(Element elem)
		{
			updateDurationUnit((ProcessElement)elem);
		}

		/**
		 * vZX̃hbv𔽉fB
		 * 
		 * @param elem	vZX
		 * @see jp.co.argo21.nautica.tool.wfd.dnd.DropElementListener#elementDropped(jp.co.argo21.nautica.tool.wfd.element.Element)
		 */
		public void elementDropped(Element elem)
		{
		}
	}

	/**
	 * sҕύX
	 */
	class ChangeParticipantElementAction implements ChangeElementListener
	{
		/**
		 * s҂̕ύX𔽉fB
		 * 
		 * @param elem	s
		 * @see jp.co.argo21.nautica.tool.wfd.dnd.DropElementListener#elementDropped(jp.co.argo21.nautica.tool.wfd.element.Element)
		 */
		public void elementChanged(Element elem)
		{
			updatePerformerInfo();
		}

		/**
		 * s҂̃hbv𔽉fB
		 * 
		 * @param elem	s
		 * @see jp.co.argo21.nautica.tool.wfd.dnd.DropElementListener#elementDropped(jp.co.argo21.nautica.tool.wfd.element.Element)
		 */
		public void elementDropped(Element elem)
		{
			if (elem instanceof ParticipantElement) {
				performer = (ParticipantElement)elem;
				updatePerformerInfo();
			}
		}
	}
}
