/* $Id: NoInspectableInspector.java,v 1.3 2005/08/26 04:50:33 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.LayoutManager;

import javax.swing.JLabel;
import javax.swing.JPanel;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;

/**
 * Ĩ_~[CXyN^
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class NoInspectableInspector extends JPanel implements Inspector
{
	/** R~bgp̃tO */
	private boolean isAutoCommit;
	
	/** bZ[WptHg */
	static private final Font FONT = new Font("SansSerif", Font.PLAIN, 24);

	/**
	 * _~[CXyN^𐶐B
	 */
	public NoInspectableInspector()
	{
		isAutoCommit = true;
		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JLabel label = new JLabel(rm.getResource("NoInspectableInspector.label"));
		label.setFont(NoInspectableInspector.FONT);
		label.setHorizontalAlignment(JLabel.CENTER);
		label.setForeground(Color.gray);

		LayoutManager layout = new BorderLayout();
		setLayout(layout);

		add(label, BorderLayout.CENTER);	
	}

	/**
	 * CXyNgΏۂԂB
	 * 
	 * @return	CXyNgΏ
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#getInspectable()
	 */	
	public final Element getInspectable()
	{
		return null;
	}

	/**
	 * CXyNgΏۂݒ肷B
	 * 
	 * @param r	Ώۗvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */	
	public final void setInspectable(Element r)
	{
		//Ȃ
	}

	/**
	 * CXyN^R~bg邩ǂԂB
	 * 
	 * @return	R~bg̏ꍇɂtrue
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#isAutoCommit()
	 */	
	public boolean isAutoCommit()
	{
		return this.isAutoCommit;
	}

	/**
	 * ݒl`FbNB
	 * 
	 * @return	`FbN
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#check()
	 */	
	public boolean check()
	{
		return true;
	}

	/**
	 * ݒlR~bgB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */	
	public void commit()
	{
		//NOP
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		//NOP
	}

	/**
	 * CXyN^̃A[hsB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#unload()
	 */
	public void unload()
	{
		//NOP
	}
}
