/* $Id: PackageInspector.java,v 1.3 2005/08/26 04:50:29 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.PackageElement;

/**
 * pbP[WpCXyN^
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class PackageInspector extends AbstractElementInspector
{
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** ACR\GA */
	private IconView iconView;
	/** ID\GA */
	private JLabel idField;
	/** ̕\GA */
	private JTextField nameField;
	/** `ҕ\GA */
	private JTextField authorField;
	/** 쐬\GA */
	private JTextField createField;
	/** o[W\GA */
	private JTextField versionField;
	/** l\GA */
	private JTextField descriptionField;
	
	/**
	 * pbP[WpCXyN^𐶐B
	 */
	public PackageInspector()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel = createBasicInfoPanel(rm);
		addTab(rm.getResource("PackageInspector.tab.0"), panel);

		validate();
	}
	
	/**
	 * {̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createBasicInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 200);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("PackageInspector.label.0"));
		JLabel l1 = new JLabel(rm.getResource("PackageInspector.label.1"));
		JLabel l2 = new JLabel(rm.getResource("PackageInspector.label.2"));
		JLabel l3 = new JLabel(rm.getResource("PackageInspector.label.3"));
		JLabel l4 = new JLabel(rm.getResource("PackageInspector.label.4"));
		JLabel l5 = new JLabel(rm.getResource("PackageInspector.label.5"));

		iconView = new IconView();
		iconView.setIconName(WorkflowDesignerConstants.EL_PACKAGE);
		idField = new JLabel();
		idField.setBorder(border);
		nameField = new JTextField();
		nameField.setDocument(new ByteLimitedDocument(64));
		authorField = new JTextField();
		authorField.setDocument(new ByteLimitedDocument(64));
		versionField = new JTextField();
		versionField.setDocument(new ByteLimitedDocument(20));
		createField = new JTextField();
		createField.setDocument(new ByteLimitedDocument(20));
		descriptionField = new JTextField();
		descriptionField.setDocument(new ByteLimitedDocument(128));

		panel.add(locate(iconView,          10,  10,  60, 60));
		panel.add(locate(l0,                80,  10, 100, 25));
		panel.add(locate(l1,                80,  40, 100, 25));
		panel.add(locate(l2,                80,  70, 100, 25));
		panel.add(locate(l3,                80, 100, 100, 25));
		panel.add(locate(l4,                80, 130, 100, 25));
		panel.add(locate(l5,                80, 160, 100, 25));
		panel.add(locate(idField,          180,  10, 190, 25));
		panel.add(locate(nameField,        180,  40, 190, 25));
		panel.add(locate(authorField,      180,  70, 190, 25));
		panel.add(locate(createField,      180, 100, 190, 25));
		panel.add(locate(versionField,     180, 130, 190, 25));
		panel.add(locate(descriptionField, 180, 160, 190, 25));

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		super.init();

		nameField.setText("");
		descriptionField.setText("");
	}

	/**
	 * CXyNgΏۂݒ肷B
	 * 
	 * @param elem	Ώۗvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */	
	public void setInspectable(Element elem)
	{
		super.setInspectable(elem);

		if (elem != null) {
			if (elem instanceof PackageElement) {
				PackageElement act = (PackageElement)elem;
				idField.setText(act.getID());
				nameField.setText(act.getName());
				authorField.setText(act.getAuthor());
				createField.setText(act.getCreatedDate());
				versionField.setText(act.getVersion());
				descriptionField.setText(act.getDescription());
			}
		}
		setSelectedIndex(0);
	}
	
	/**
	 * ݒl`FbNB
	 * 
	 * @return	`FbN
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#check()
	 */
	public boolean check()
	{
		return true;
	}

	/**
	 * ݒlR~bgB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */	
	public void commit()
	{
		Element e = getInspectable();
		if (e != null) {
			if (e instanceof PackageElement) {
				PackageElement pkg = (PackageElement)e;
				pkg.setName(nameField.getText());
				pkg.setAuthor(authorField.getText());
				pkg.setCreatedDate(createField.getText());
				pkg.setVersion(versionField.getText());
				pkg.setDescription(descriptionField.getText());
				fireElementChanged();
			}
		}		
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	protected Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}
}
