/* $Id: ParamMappingTableModel.java,v 1.3 2005/08/26 04:50:34 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.VariableElement;

/**
 * p[^̊tǗe[up䃂f
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
class ParamMappingTableModel extends AbstractTableModel
{
	/** e[u̗ */
	static private String[] columnNames;
	
	/** p[^ */
	private List params = new ArrayList();

	/**
	 * 萔
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		columnNames = new String[3];
		columnNames[0] = rm.getResource("ActualParamTableModel.columnName.0");
		columnNames[1] = rm.getResource("ActualParamTableModel.columnName.1");
		columnNames[2] = rm.getResource("ActualParamTableModel.columnName.2");
	}


	/**
	 * p[^e[u䃂f𐶐B
	 */
	ParamMappingTableModel()
	{
	}

	/**
	 * f[^\[XIuWFNgǗ񐔂ԂB
	 * JTable͂̃\bhgāAɍ쐬ѕ\
	 * Kv̂񐔂𔻒fB
	 *
	 * @return	f̗
	 */
	public int getColumnCount()
	{
		return 3;
	}

	/**
	 * f[^\[XIuWFNgǗ郌R[hԂB
	 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
	 *
	 * @return	f̍s
	 */
	public int getRowCount()
	{
		return params.size();
	}

	/**
	 * colɂ̖OԂB
	 * ̃\bh́Ae[u̗wb_邽߂ɎgB
	 *
	 * @param	col		̃CfbNX
	 * @return	wb_
	 */
	public String getColumnName(int col)
	{
		return columnNames[col];
	}

	/**
	 * Z̒lԂB
	 *
	 * @param	row		lQƂs
	 * @param	col		lQƂ
	 * @return	w肳ꂽZɂl
	 */
	public Object getValueAt(int row, int col)
	{
		MappedParam p = (MappedParam)params.get(row);
		if (col == 0) {
			int m = p.getParam().getMode();
			if (m == ParameterElement.IN) {
				return ParameterInspector.PARAM_MODES[0];
			} else if (m == ParameterElement.OUT) {
				return ParameterInspector.PARAM_MODES[1];
			} else if (m == ParameterElement.INOUT) {
				return ParameterInspector.PARAM_MODES[2];
			}
		} else if (col == 1) {
			int t = p.getParam().getType();
			if (t == ParameterElement.STRING) {
				return ParameterInspector.PARAM_TYPES[0];
			} else if (t == ParameterElement.INTEGER) {
				return ParameterInspector.PARAM_TYPES[1];
			} else if (t == ParameterElement.BOOLEAN) {
				return ParameterInspector.PARAM_TYPES[2];
			}
		} else if (col == 2) {
			VariableElement ap = p.getActualParam();
			if (ap != null) return ap.getName();
		}
		return "";
	}

	/**
	 * ClassԂB
	 *
	 * @param	col		
	 * @return	f̃IuWFNgl̋ʂ̏ʃNX
	 */
	public Class getColumnClass(int col)
	{
		return String.class;
	}

	/**
	 * rowcolɂZҏW\ȏꍇtrueԂB
	 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
	 *
	 * @param	row		lQƂs
	 * @param	col		lQƂ
	 * @return	ZҏW\ȏꍇtrue
	 */
	public boolean isCellEditable(int row, int col)
	{
		return false;
	}
	
	/**
	 * p[^ǉB
	 * 
	 * @param p	p[^
	 */
	public void addMappedParam(MappedParam p)
	{
		if (p == null) return;

		params.add(p);
		fireTableDataChanged();
	}

	/**
	 * }bsO폜B
	 * 
	 * @param ix	CfNX
	 */	
	public void removeMapping(int ix)
	{
		if (ix < 0 || ix >= params.size()) return;
		
		MappedParam mp = (MappedParam)params.get(ix);
		mp.setActualParam(null);
		fireTableDataChanged();
	}

	/**
	 * }bsOXV
	 * 
	 * @param ix	CfNX
	 * @param actual	p[^
	 */	
	public void updateMapping(int ix, VariableElement actual)
	{
		if (ix < 0 || ix >= params.size()) return;
		
		MappedParam mp = (MappedParam)params.get(ix);
		mp.setActualParam(actual);
		fireTableDataChanged();
	}

	/**
	 * p[^NAB
	 */	
	public void clearAllParams()
	{
		params.clear();
		fireTableDataChanged();
	}

	/**
	 * XgB
	 * 
	 * @param parameters	p[^ꗗ
	 */	
	void initParams(List parameters)
	{
		clearAllParams();
		
		if (parameters == null) return;
		
		Iterator it = parameters.iterator();
		while (it.hasNext()) {
			Object o = it.next();
			if (o == null) continue;
			
			if (o instanceof ParameterElement) {
				MappedParam mp = new MappedParam((ParameterElement)o);
				addMappedParam(mp);
			}
		}
		fireTableDataChanged();
	}

	/**
	 * CfNXɑΉp[^ԂB
	 * 
	 * @param ix	CfNX
	 * @return	p[^
	 */	
	MappedParam getMappedParam(int ix)
	{
		if (ix < 0 || ix >= params.size()) return null;
		
		return (MappedParam)params.get(ix);
	}

	/**
	 * ׂẴp[^ԂB
	 * 
	 * @return	p[^ꗗ
	 */	
	List getAllMappedParams()
	{
		return params;
	}
}
