/* $Id: ParameterInspector.java,v 1.4 2005/08/26 04:50:38 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ElementFactory;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;

/**
 * p[^pCXyN^
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.4 $
 * @since   Nautica Workflow 0.9
 */
public class ParameterInspector extends AbstractElementInspector
{
	/** p[^^ */
	static public String[] PARAM_TYPES;
	/** p[^[h */
	static public String[] PARAM_MODES;

	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** ID\GA */
	private JLabel idField;
	/** ^Cv */
	private JComboBox typeBox;
	/** o̓[h */
	private JComboBox modeBox;
	/** l\GA */
	private JTextField descriptionField;
	
	/**
	 * 萔
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		PARAM_TYPES = new String[3];
		PARAM_TYPES[0] = rm.getResource("ParameterInspector.type.0");
		PARAM_TYPES[1] = rm.getResource("ParameterInspector.type.1");
		PARAM_TYPES[2] = rm.getResource("ParameterInspector.type.2");

		PARAM_MODES = new String[3];
		PARAM_MODES[0] = rm.getResource("ParameterInspector.mode.0");
		PARAM_MODES[1] = rm.getResource("ParameterInspector.mode.1");
		PARAM_MODES[2] = rm.getResource("ParameterInspector.mode.2");
	}

	/**
	 * p[^pCXyN^𐶐B
	 */
	public ParameterInspector()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel = createBasicInfoPanel(rm);
		addTab(rm.getResource("ParameterInspector.tab.0"), panel);

		validate();
	}
	
	/**
	 * {̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createBasicInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 200);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ParameterInspector.label.0"));
		JLabel l1 = new JLabel(rm.getResource("ParameterInspector.label.1"));
		JLabel l2 = new JLabel(rm.getResource("ParameterInspector.label.2"));
		JLabel l3 = new JLabel(rm.getResource("ParameterInspector.label.3"));

		idField = new JLabel();
		idField.setBorder(border);
		descriptionField = new JTextField();
		descriptionField.setDocument(new ByteLimitedDocument(128));
		typeBox = new JComboBox(PARAM_TYPES);
		modeBox = new JComboBox(PARAM_MODES);

		panel.add(locate(l0,                10,  10, 100, 25));
		panel.add(locate(l1,                10,  40, 100, 25));
		panel.add(locate(l2,                10,  70, 100, 25));
		panel.add(locate(l3,                10, 100, 100, 25));
		panel.add(locate(idField,          110,  10, 190, 25));
		panel.add(locate(typeBox,          110,  40, 190, 25));
		panel.add(locate(modeBox,          110,  70, 190, 25));
		panel.add(locate(descriptionField, 110, 100, 190, 25));

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		super.init();

		idField.setText("");
		descriptionField.setText("");
		typeBox.setSelectedIndex(0);
		modeBox.setSelectedIndex(0);
	}

	/**
	 * CXyNgΏۂݒ肷B
	 * 
	 * @param elem	Ώۗvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */	
	public void setInspectable(Element elem)
	{
		super.setInspectable(elem);

		if (elem != null) {
			if (elem instanceof ParameterElement) {
				ParameterElement param = (ParameterElement)elem;
				idField.setText(param.getID());
				int t = param.getType();
				if (t == ParameterElement.STRING) {
					typeBox.setSelectedIndex(0);
				} else if (t == ParameterElement.INTEGER) {
					typeBox.setSelectedIndex(1);
				} else if (t == ParameterElement.BOOLEAN) {
					typeBox.setSelectedIndex(2);
				} else {
					typeBox.setSelectedIndex(0);
				}

				int m = param.getMode();
				if (m == ParameterElement.IN) {
					modeBox.setSelectedIndex(0);
				} else if (m == ParameterElement.OUT) {
					modeBox.setSelectedIndex(1);
				} else if (m == ParameterElement.INOUT) {
					modeBox.setSelectedIndex(2);
				} else {
					modeBox.setSelectedIndex(2);
				}
				descriptionField.setText(param.getDescription());
			}
		}
		setSelectedIndex(0);
		repaint();
	}

	/**
	 * ݒl`FbNB
	 * 
	 * @return	`FbN
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#check()
	 */	
	public boolean check()
	{
		return true;
	}

	/**
	 * ݒlR~bgB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */	
	public void commit()
	{
		if (getInspectable() == null) {
			super.setInspectable(ElementFactory.getInstance().createElement(WorkflowDesignerConstants.EL_PARAMETER));
		}

		if (getInspectable() instanceof ParameterElement) {
			ParameterElement param = (ParameterElement)getInspectable();
			
			int t = typeBox.getSelectedIndex();
			if (t == 0) {
				param.setType(ParameterElement.STRING);
			} else if (t == 1) {
				param.setType(ParameterElement.INTEGER);
			} else if (t == 2) {
				param.setType(ParameterElement.BOOLEAN);
			}
			
			int m = modeBox.getSelectedIndex();
			if (m == 0) {
				param.setMode(ParameterElement.IN);
			} else if (m == 1) {
				param.setMode(ParameterElement.OUT);
			} else if (m == 2) {
				param.setMode(ParameterElement.INOUT);
			}
			param.setDescription(descriptionField.getText());

			fireElementChanged();
		}
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	protected Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}
}
