/* $Id: ParticipantInspector.java,v 1.3 2005/08/26 04:50:32 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParticipantElement;

/**
 * [Nt[QҗpCXyN^
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class ParticipantInspector extends AbstractElementInspector
{
	/** ^ */
	static private String[] types;
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** ACR\GA */
	private IconView iconView;
	/** ID\GA */
	private JLabel idField;
	/** ̕\GA */
	private JTextField nameField;
	/** ^Cv */
	private JComboBox typeBox;
	/** l\GA */
	private JTextField descriptionField;
	
	/**
	 * 萔
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		types = new String[4];
		types[0] = rm.getResource("ParticipantInspector.type.0");
		types[1] = rm.getResource("ParticipantInspector.type.1");
		types[2] = rm.getResource("ParticipantInspector.type.2");
		types[3] = rm.getResource("ParticipantInspector.type.3");
	}

	/**
	 * [Nt[QҗpCXyN^𐶐B
	 */
	public ParticipantInspector()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel = createBasicInfoPanel(rm);
		addTab(rm.getResource("ParticipantInspector.tab.0"), panel);

		validate();
	}
	
	/**
	 * {̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createBasicInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 200);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ParticipantInspector.label.0"));
		JLabel l1 = new JLabel(rm.getResource("ParticipantInspector.label.1"));
		JLabel l2 = new JLabel(rm.getResource("ParticipantInspector.label.2"));
		JLabel l3 = new JLabel(rm.getResource("ParticipantInspector.label.3"));

		iconView = new IconView();
		iconView.setIconName(WorkflowDesignerConstants.EL_PARTICIPANT);
		idField = new JLabel();
		idField.setBorder(border);
		nameField = new JTextField();
		nameField.setDocument(new ByteLimitedDocument(64));
		descriptionField = new JTextField();
		descriptionField.setDocument(new ByteLimitedDocument(128));
		typeBox = new JComboBox(types);

		panel.add(locate(iconView,          10,  10,  60, 60));
		panel.add(locate(l0,                80,  10, 100, 25));
		panel.add(locate(l1,                80,  40, 100, 25));
		panel.add(locate(l2,                80,  70, 100, 25));
		panel.add(locate(l3,                80, 100, 100, 25));
		panel.add(locate(idField,          180,  10, 190, 25));
		panel.add(locate(nameField,        180,  40, 190, 25));
		panel.add(locate(typeBox,          180,  70, 190, 25));
		panel.add(locate(descriptionField, 180, 100, 190, 25));

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		super.init();

		nameField.setText("");
		descriptionField.setText("");
		typeBox.setSelectedIndex(0);
	}

	/**
	 * CXyNgΏۂݒ肷B
	 * 
	 * @param elem	Ώۗvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */	
	public void setInspectable(Element elem)
	{
		super.setInspectable(elem);

		if (elem != null) {
			if (elem instanceof ParticipantElement) {
				ParticipantElement part = (ParticipantElement)elem;
				idField.setText(part.getID());
				nameField.setText(part.getName());
				int t = part.getType();
				if (t == ParticipantElement.ROLE) {
					typeBox.setSelectedIndex(0);
				} else if (t == ParticipantElement.ORGANIZATIONAL_UNIT) {
					typeBox.setSelectedIndex(1);
				} else if (t == ParticipantElement.HUMAN) {
					typeBox.setSelectedIndex(2);
				} else if (t == ParticipantElement.SYSTEM) {
					typeBox.setSelectedIndex(3);
				} else {
					typeBox.setSelectedIndex(3);
				}
				descriptionField.setText(part.getDescription());
			}
		}
		setSelectedIndex(0);
	}

	/**
	 * ݒl`FbNB
	 * 
	 * @return	`FbN
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#check()
	 */	
	public boolean check()
	{
		return true;
	}

	/**
	 * ݒlR~bgB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */	
	public void commit()
	{
		Element e = getInspectable();
		if (e != null) {
			if (e instanceof ParticipantElement) {
				ParticipantElement part = (ParticipantElement)e;
				part.setName(nameField.getText());
				
				int t = typeBox.getSelectedIndex();
				if (t == 0) {
					part.setType(ParticipantElement.ROLE);
				} else if (t == 1) {
					part.setType(ParticipantElement.ORGANIZATIONAL_UNIT);
				} else if (t == 2) {
					part.setType(ParticipantElement.HUMAN);
				} else if (t == 3) {
					part.setType(ParticipantElement.SYSTEM);
				}
				part.setDescription(descriptionField.getText());

				fireElementChanged();
			}
		}		
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	protected Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}
}
