/* $Id: ProcessInspector.java,v 1.5 2005/08/26 04:50:32 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.commons.util.StringUtils;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.InspectorDialog;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ParameterElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;

/**
 * vZXpCXyN^
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class ProcessInspector extends AbstractElementInspector
{
	/** e[u̗ */
	static private String[] columnNames;
	/** ʒm҃e[u̗ */
	static private String rspColumnName;

	/** P */
	static public String[] DURATION_UNITS;
	/** ANZXx */
	static private String[] accessLevels;
	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** ACR\GA */
	private IconView iconView;
	/** ID\GA */
	private JLabel idField;
	/** ̕\GA */
	private JTextField nameField;
	/** sGA */
	private JTextField limitField;
	/** sP */
	private JComboBox unitBox;
	/** ANZXx\GA */
	private JLabel accessField;
	/** l\GA */
	private JTextField descriptionField;

	/** p[^Xg */
	private JTable paramTable;
	/** p[^ǉ{^ */
	private JButton addParamButton;
	/** p[^ҏW{^ */
	private JButton editParamButton;
	/** p[^폜{^ */
	private JButton delParamButton;

	/** ʒm҃Xg */
	private JTable rspTable;
	/** ʒmҒǉ{^ */
	private JButton addRspButton;
	/** ʒmҍXV{^ */
	private JButton updRspButton;
	/** ʒmҍ폜{^ */
	private JButton delRspButton;
	/** ʒmғ̓GA */
	private JTextField rspField;
	
	/** ʒm҈ꗗ */
	private List responsibles = new ArrayList();
	
	/**
	 * 萔̏
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		DURATION_UNITS = new String[6];
		DURATION_UNITS[0] = rm.getResource("ProcessInspector.unit.0");
		DURATION_UNITS[1] = rm.getResource("ProcessInspector.unit.1");
		DURATION_UNITS[2] = rm.getResource("ProcessInspector.unit.2");
		DURATION_UNITS[3] = rm.getResource("ProcessInspector.unit.3");
		DURATION_UNITS[4] = rm.getResource("ProcessInspector.unit.4");
		DURATION_UNITS[5] = rm.getResource("ProcessInspector.unit.5");
		
		accessLevels = new String[2];
		accessLevels[0] = rm.getResource("ProcessInspector.access.0");
		accessLevels[1] = rm.getResource("ProcessInspector.access.1");

		columnNames = new String[3];
		columnNames[0] = rm.getResource("ParamTableModel.columnName.0");
		columnNames[1] = rm.getResource("ParamTableModel.columnName.1");
		columnNames[2] = rm.getResource("ParamTableModel.columnName.2");

		rspColumnName = rm.getResource("ResponsibleTableModel.columnName.0");
	}

	/**
	 * CXyN^𐶐B
	 */
	public ProcessInspector()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel0 = createBasicInfoPanel(rm);
		addTab(rm.getResource("ProcessInspector.tab.0"), panel0);

		JPanel panel1 = createParamInfoPanel(rm);
		addTab(rm.getResource("ProcessInspector.tab.1"), panel1);

		JPanel panel2 = createResponsibleInfoPanel(rm);
		addTab(rm.getResource("ProcessInspector.tab.2"), panel2);

		validate();
	}
	
	/**
	 * {̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createBasicInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 170);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ProcessInspector.label.0"));
		JLabel l1 = new JLabel(rm.getResource("ProcessInspector.label.1"));
		JLabel l2 = new JLabel(rm.getResource("ProcessInspector.label.2"));
		JLabel l3 = new JLabel(rm.getResource("ProcessInspector.label.3"));
		JLabel l4 = new JLabel(rm.getResource("ProcessInspector.label.4"));

		iconView = new IconView();
		iconView.setIconName(WorkflowDesignerConstants.EL_PROCESS);
		idField = new JLabel();
		idField.setBorder(border);
		nameField = new JTextField();
		nameField.setDocument(new ByteLimitedDocument(64));
		descriptionField = new JTextField();
		descriptionField.setDocument(new ByteLimitedDocument(128));
		limitField = new JTextField();
		limitField.setHorizontalAlignment(SwingConstants.RIGHT);
		limitField.setDocument(new NumericDocument(3, true, true));
		unitBox = new JComboBox(DURATION_UNITS);
		accessField = new JLabel();
		accessField.setBorder(border);

		panel.add(locate(iconView,          10,  10,  60, 60));
		panel.add(locate(l0,                80,  10, 100, 25));
		panel.add(locate(l1,                80,  40, 100, 25));
		panel.add(locate(l2,                80,  70, 100, 25));
		panel.add(locate(l3,                80, 100, 100, 25));
		panel.add(locate(l4,                80, 130, 100, 25));
		panel.add(locate(idField,          180,  10, 190, 25));
		panel.add(locate(nameField,        180,  40, 190, 25));
		panel.add(locate(limitField,       180,  70, 110, 25));
		panel.add(locate(unitBox,          290,  70,  80, 25));
		panel.add(locate(accessField,      180, 100, 190, 25));
		panel.add(locate(descriptionField, 180, 130, 190, 25));

		validate();
		
		return panel;
	}
	
	/**
	 * p[^̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createParamInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 200);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ProcessInspector.label.5"));

		paramTable = new JTable(new ParamTableModel());
		paramTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(paramTable);
		addParamButton = new JButton(rm.getResource("JButton.label.add"));
		addParamButton.addActionListener(new AddParamAction());
		editParamButton = new JButton(rm.getResource("JButton.label.edit"));
		editParamButton.addActionListener(new EditParamAction());
		delParamButton = new JButton(rm.getResource("JButton.label.delete"));
		delParamButton.addActionListener(new DeleteParamAction());

		panel.add(locate(l0,                10,  10, 100,  25));
		panel.add(locate(sp,                10,  40, 270, 145));
		panel.add(locate(addParamButton,   290,  40,  80,  25));
		panel.add(locate(editParamButton,  290,  70,  80,  25));
		panel.add(locate(delParamButton,   290, 100,  80,  25));

		validate();
		
		return panel;
	}
	
	/**
	 * ʒmҏ̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createResponsibleInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 200);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("ProcessInspector.label.5"));

		rspField = new JTextField();
		rspField.setDocument(new ByteLimitedDocument(64));
		rspTable = new JTable(new ResponsibleTableModel());
		rspTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		ListSelectionModel lsm = rspTable.getSelectionModel();
		lsm.addListSelectionListener(new ResponsibleSelectAction());
		JScrollPane sp = new JScrollPane();
		sp.setViewportView(rspTable);
		addRspButton = new JButton(rm.getResource("JButton.label.add"));
		addRspButton.addActionListener(new AddResponsibleAction());
		updRspButton = new JButton(rm.getResource("JButton.label.update"));
		updRspButton.addActionListener(new EditResponsibleAction());
		delRspButton = new JButton(rm.getResource("JButton.label.delete"));
		delRspButton.addActionListener(new DeleteResponsibleAction());

		panel.add(locate(l0,            10,  10, 100,  25));
		panel.add(locate(sp,            10,  40, 270, 115));
		panel.add(locate(addRspButton, 290,  40,  80,  25));
		panel.add(locate(updRspButton, 290,  70,  80,  25));
		panel.add(locate(delRspButton, 290, 100,  80,  25));
		panel.add(locate(rspField,      10, 160, 270,  25));

		validate();
		
		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		super.init();

		nameField.setText("");
		descriptionField.setText("");
		limitField.setText("0");
		unitBox.setSelectedIndex(2);
		responsibles.clear();
		rspField.setText("");
		paramTable.clearSelection();
		rspTable.clearSelection();
	}

	/**
	 * CXyNgΏۂݒ肷B
	 * 
	 * @param elem	Ώۗvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */	
	public void setInspectable(Element elem)
	{
		super.setInspectable(elem);
		
		if (elem != null) {
			if (elem instanceof ProcessElement) {
				ProcessElement proc = (ProcessElement)elem;
				idField.setText(proc.getID());
				nameField.setText(proc.getName());
				limitField.setText("" + proc.getLimit());
				int u = proc.getDurationUnit();
				if (u == ProcessElement.YEAR) {
					unitBox.setSelectedIndex(0);
				} else if (u == ProcessElement.MONTH) {
					unitBox.setSelectedIndex(1);
				} else if (u == ProcessElement.DAY) {
					unitBox.setSelectedIndex(2);
				} else if (u == ProcessElement.HOUR) {
					unitBox.setSelectedIndex(3);
				} else if (u == ProcessElement.MINUTE) {
					unitBox.setSelectedIndex(4);
				} else if (u == ProcessElement.SECOND) {
					unitBox.setSelectedIndex(5);
				} else {
					unitBox.setSelectedIndex(2);
				}
				int a = proc.getAccessLevel();
				if (a == ProcessElement.PUBLIC) {
					accessField.setText(accessLevels[0]);
				} else {
					accessField.setText(accessLevels[1]);
				}
				descriptionField.setText(proc.getDescription());
				
				Iterator rit = proc.getResponsibles().iterator();
				while (rit.hasNext()) {
					responsibles.add(rit.next());
				}
			}
		}
		setSelectedIndex(0);
	}

	/**
	 * ݒl`FbNB
	 * 
	 * @return	`FbN
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#check()
	 */	
	public boolean check()
	{
		return true;
	}

	/**
	 * ݒlR~bgB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */	
	public void commit()
	{
		Element e = getInspectable();
		if (e != null) {
			if (e instanceof ProcessElement) {
				ProcessElement proc = (ProcessElement)e;
				proc.setName(nameField.getText());
				
				try {
					int limit = Integer.parseInt(limitField.getText());
					proc.setLimit(limit);
				} catch (Exception ex) {
					proc.setLimit(0);
				}
				int u = unitBox.getSelectedIndex();
				if (u == 0) {
					proc.setDurationUnit(ProcessElement.YEAR);
				} else if (u == 1) {
					proc.setDurationUnit(ProcessElement.MONTH);
				} else if (u == 2) {
					proc.setDurationUnit(ProcessElement.DAY);
				} else if (u == 3) {
					proc.setDurationUnit(ProcessElement.HOUR);
				} else if (u == 4) {
					proc.setDurationUnit(ProcessElement.MINUTE);
				} else if (u == 5) {
					proc.setDurationUnit(ProcessElement.SECOND);
				}
				proc.setDescription(descriptionField.getText());
				
				proc.getResponsibles().clear();
				Iterator rit = responsibles.iterator();
				while (rit.hasNext()) {
					proc.addResponsible((String)rit.next());
				}

				fireElementChanged();
			}
		}		
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	protected Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}

	/**
	 * p[^ǉB
	 */	
	class AddParamAction extends AbstractAction
	{
		/**
		 * p[^ǉB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			Element newElem = InspectorDialog.showDialog(ProcessInspector.this, WorkflowDesignerConstants.EL_PARAMETER);
			if (newElem == null) return;
			
			Element proc = getInspectable();
			if (proc == null) return;

			((ProcessElement)proc).addParameter((ParameterElement)newElem);
			paramTable.clearSelection();
			paramTable.updateUI();
		}
	}
	
	/**
	 * p[^ҏW
	 */	
	class EditParamAction extends AbstractAction
	{
		/**
		 * p[^ҏWB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = paramTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
				return;
			}
			Element proc = getInspectable();
			if (proc == null) return;

			List list = ((ProcessElement)proc).getParameters();
			ParameterElement p = (ParameterElement)list.get(selected);
			InspectorDialog.showDialog(ProcessInspector.this, p);
			paramTable.clearSelection();
			paramTable.updateUI();
		}
	}
	
	/**
	 * p[^폜B
	 */	
	class DeleteParamAction extends AbstractAction
	{
		/**
		 * p[^폜B
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = paramTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0002"));
				return;
			}
			Element proc = getInspectable();
			if (proc == null) return;

			List list = ((ProcessElement)proc).getParameters();
			ParameterElement p = (ParameterElement)list.remove(selected);
			paramTable.clearSelection();
			paramTable.updateUI();
		}
	}
	
	/**
	 * p[^e[u䃂f
	 */
	class ParamTableModel extends AbstractTableModel
	{
		/**
		 * p[^e[u䃂f𐶐B
		 */
		ParamTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return 3;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			Element e = getInspectable();
			if (e == null) return 0;
			
			return ((ProcessElement)e).getParameters().size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			Element e = getInspectable();
			if (e == null) return "";

			List list = ((ProcessElement)e).getParameters();
			ParameterElement p = (ParameterElement)list.get(row);
			if (col == 0) {
				int m = p.getMode();
				if (m == ParameterElement.IN) {
					return ParameterInspector.PARAM_MODES[0];
				} else if (m == ParameterElement.OUT) {
					return ParameterInspector.PARAM_MODES[1];
				} else if (m == ParameterElement.INOUT) {
					return ParameterInspector.PARAM_MODES[2];
				}
			} else if (col == 1) {
				int t = p.getType();
				if (t == ParameterElement.STRING) {
					return ParameterInspector.PARAM_TYPES[0];
				} else if (t == ParameterElement.INTEGER) {
					return ParameterInspector.PARAM_TYPES[1];
				} else if (t == ParameterElement.BOOLEAN) {
					return ParameterInspector.PARAM_TYPES[2];
				}
			} else if (col == 2) {
				return p.getDescription();
			}
			return "";
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}
	
	/**
	 * ʒmҒǉ
	 */	
	class AddResponsibleAction extends AbstractAction
	{
		/**
		 * ʒm҂ǉB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			String addr = rspField.getText();
			if (StringUtils.checkNull(addr)) {
				DialogUtilities.showError(rm.getResource("message.error.0026"));
			} else if (responsibles.contains(addr)) {
				DialogUtilities.showError(rm.getResource("message.error.0027"));
			} else {
				responsibles.add(addr);
			}
			rspTable.clearSelection();
			rspTable.updateUI();
		}
	}
	
	/**
	 * ʒmҕҏW
	 */	
	class EditResponsibleAction extends AbstractAction
	{
		/**
		 * ʒm҂ҏWB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = rspTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0003"));
				return;
			}
			String addr = rspField.getText();
			if (StringUtils.checkNull(addr)) {
				DialogUtilities.showError(rm.getResource("message.error.0026"));
			} else if (responsibles.contains(addr)) {
				if (addr.equals(responsibles.get(selected)) == false) { 
					DialogUtilities.showError(rm.getResource("message.error.0027"));
				}
			} else {
				responsibles.set(selected, addr);
			}
			responsibles.set(selected, addr);
			rspTable.clearSelection();
			rspTable.updateUI();
		}
	}
	
	/**
	 * ʒmҍ폜
	 */	
	class DeleteResponsibleAction extends AbstractAction
	{
		/**
		 * ʒm҂폜B
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = rspTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0003"));
				return;
			}
			responsibles.remove(selected);
			rspField.setText("");
			rspTable.clearSelection();
			rspTable.updateUI();
		}
	}

	/**
	 * ʒmґI
	 */	
	class ResponsibleSelectAction implements ListSelectionListener
	{
		/**
		 * Iꂽʒm҂\B
		 * 
		 * @param e	Cxg
		 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
		 */
		public void valueChanged(ListSelectionEvent e)
		{
			if (e.getValueIsAdjusting()) return;

			ListSelectionModel lsm = (ListSelectionModel)e.getSource();
			if (lsm.isSelectionEmpty() == false) {
				int selected = lsm.getMinSelectionIndex();
				rspField.setText((String)responsibles.get(selected));
			}
		}
	}
		
	/**
	 * ʒm҃e[u䃂f
	 */
	class ResponsibleTableModel extends AbstractTableModel
	{
		/**
		 * ʒm҃e[u䃂f𐶐B
		 */
		ResponsibleTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return 1;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			return responsibles.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return rspColumnName;
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			return responsibles.get(row);
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}
}
