/* $Id: TransitionalActivityInspector.java,v 1.3 2005/08/26 04:50:37 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.inspector;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.ConditionDialog;
import jp.co.argo21.nautica.tool.wfd.DesktopPane;
import jp.co.argo21.nautica.tool.wfd.ProcessDesignFrame;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.Element;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.expression.ExceptionExpression;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;
import jp.co.argo21.nautica.tool.wfd.expression.OtherwiseExpression;

/**
 * JڏtANeBreBp̃CXyN^
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class TransitionalActivityInspector extends BasicActivityInspector
{
	/** e[u̗ */
	static private String[] columnNames;

	/** Jڏ̃^Cv */
	static private String[] conditionTypes;

	/** ݒ{^ */
	private JButton editCondButton;

	/** Jڃe[u */
	private JTable transitionTable;

	/** \GA */
	private JTextArea conditionArea;
	
	/** Jڈꗗ */
	private List transitions = new ArrayList();

	/**
	 * ϐ
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		columnNames = new String[2];
		columnNames[0] = rm.getResource("TransitionTableModel.columnName.0");
		columnNames[1] = rm.getResource("TransitionTableModel.columnName.1");

		conditionTypes = new String[5];
		conditionTypes[0] = rm.getResource("TransitionTableModel.conditionType.0");
		conditionTypes[1] = rm.getResource("TransitionTableModel.conditionType.1");
		conditionTypes[2] = rm.getResource("TransitionTableModel.conditionType.2");
		conditionTypes[3] = rm.getResource("TransitionTableModel.conditionType.3");
		conditionTypes[4] = rm.getResource("TransitionTableModel.conditionType.4");
	}

	/**
	 * JڏtANeBreBp̃CXyN^ʂ𐶐B
	 */
	public TransitionalActivityInspector()
	{
		super();
		
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel = createTransitionInfoPanel(rm);
		addTab(rm.getResource("TransitionalActivityInspector.tab.0"), panel);

		validate();
	}
	
	/**
	 * {̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createTransitionInfoPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 380);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("TransitionalActivityInspector.label.0"));
		JLabel l1 = new JLabel(rm.getResource("TransitionalActivityInspector.label.1"));

		transitionTable = new JTable(new TransitionTableModel());
		transitionTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		ListSelectionModel tlsm = transitionTable.getSelectionModel();
		tlsm.addListSelectionListener(new TransitionSelectAction());
		JScrollPane sp1 = new JScrollPane();
		sp1.setViewportView(transitionTable);
		
		conditionArea = new JTextArea();
		conditionArea.setLineWrap(true);
		conditionArea.setEditable(false);
		JScrollPane sp2 = new JScrollPane();
		sp2.setViewportView(conditionArea);

		JButton editButton = new JButton(rm.getResource("JButton.label.edit"));

		editButton.addActionListener(new EditTransitionAction());
		
		panel.add(locate(l0,          10,  10, 100,  25));
		panel.add(locate(sp1,         10,  40, 360, 155));
		panel.add(locate(l1,          10, 200, 100,  25));
		panel.add(locate(sp2,         10, 230, 270, 105));
		panel.add(locate(editButton, 290, 230,  80,  25));

		validate();

		return panel;
	}

	/**
	 * CXyN^B
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#init()
	 */
	public void init()
	{
		super.init();

		transitions.clear();
		conditionArea.setText("");
	}
	
	/**
	 * ҏWꂽANeBreBvfɔfB
	 * 
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#commit()
	 */
	public void commit()
	{
		super.commit();
		Element e = getInspectable();
		if (e != null) {
			if (e instanceof ActivityElement) {
				ActivityElement act = (ActivityElement)e;
			}
		}		
	}
	
	/**
	 * ANeBreBvf̏CXyN^ɔfB
	 * 
	 * @param elem ANeBreBvf
	 * @see jp.co.argo21.nautica.tool.wfd.inspector.Inspector#setInspectable(jp.co.argo21.nautica.tool.wfd.element.Element)
	 */
	public void setInspectable(Element elem)
	{
		super.setInspectable(elem);

		if (elem != null) {
			if (elem instanceof ActivityElement) {
				ActivityElement act = (ActivityElement)elem;
				
				DesktopPane desktop = WorkflowDesignerManager.getMainFrame().getDesktop();
				ProcessDesignFrame frame = desktop.getCurrentProcessDesignFrame();
				if (frame == null) return;
				ProcessElement proc = frame.getProcess();
				if (proc == null) return;
				Iterator tit = proc.getTransitions().iterator();
				while (tit.hasNext()) {
					TransitionElement t = (TransitionElement)tit.next();
					if (act == t.getSource()) {
						transitions.add(t);
					}
				}
			}
		}
		repaint();
	}

	/**
	 * Jڏ̕ҏWĂ΂ꂽꍇ̏
	 */	
	class EditTransitionAction extends AbstractAction
	{
		/**
		 * GfB^JB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = transitionTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0004"));
				return;
			}
			TransitionElement tr = (TransitionElement)transitions.get(selected);
			Expression exp = tr.getCondition();
			Expression newExp = ConditionDialog.showDialog(TransitionalActivityInspector.this, exp);
			if (newExp == null) {
				tr.setType(TransitionElement.CONDITION);
			} else if (newExp instanceof OtherwiseExpression) {
				tr.setType(TransitionElement.OTHERWISE);
			} else if (newExp instanceof ExceptionExpression) {
				tr.setType(TransitionElement.EXCEPTION);
			} else {
				tr.setType(TransitionElement.CONDITION);
			}
			tr.setCondition(newExp);
			transitionTable.clearSelection();
			conditionArea.setText("");
		}
	}

	/**
	 * JڂIꂽꍇ̏
	 */	
	class TransitionSelectAction implements ListSelectionListener
	{
		/**
		 * IꂽJڏ\B
		 * 
		 * @param e	Cxg
		 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
		 */
		public void valueChanged(ListSelectionEvent e)
		{
			if (e.getValueIsAdjusting()) return;

			ListSelectionModel lsm = (ListSelectionModel)e.getSource();
			if (lsm.isSelectionEmpty() == false) {
				int selected = lsm.getMinSelectionIndex();
				Expression exp = ((TransitionElement)transitions.get(selected)).getCondition();
				if (exp != null) {
					List vars = WorkflowDesignerManager.getMainFrame().getPackage().getVariables();
					conditionArea.setText(exp.getExpressionString(vars));
				} else {
					conditionArea.setText("");
				}
			}
		}
	}
	
	/**
	 * Jڃe[u䃂f
	 */
	class TransitionTableModel extends AbstractTableModel
	{
		/**
		 * Jڃe[u䃂f𐶐B
		 */
		TransitionTableModel()
		{
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return 2;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			return transitions.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * Z̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			TransitionElement tr = (TransitionElement)transitions.get(row);
			if (col == 0) {
				return tr.getDestination().getName();
			} else {
				int type = tr.getType();
				if (type == TransitionElement.OTHERWISE) {
					return conditionTypes[1];
				} else if (type == TransitionElement.EXCEPTION) {
					return conditionTypes[2];
				} else if (type == TransitionElement.DEFAULTEXCEPTION) {
					return conditionTypes[3];
				} else {
					if (tr.getCondition() == null) {
						return conditionTypes[4];
					} else {
						return conditionTypes[0];
					}
				}
			}
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}
}
