/* $Id: PrintData.java,v 1.3 2005/08/26 04:51:21 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2004.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.print;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

import jp.co.argo21.nautica.tool.wfd.ProcessFlowView;

/**
 * f[^B
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class PrintData implements Pageable
{
	/** y[WtH[}bg */
	private PageFormat format;
	/** `Ώۃr[ */
	private ProcessFlowView view;

	/**
	 * pf[^𐶐B
	 * 
	 * @param view Ώۂ̃r[
	 */
	public PrintData(ProcessFlowView view)
	{
		this.format = new PageFormat();
		this.view = view;
	}

	/**
	 * y[WtH[}bgݒ肷B
	 * 
	 * @param format y[WtH[}bg
	 */
	public void setFormat(PageFormat format)
	{
		this.format = format;
	}

	/**
	 * ̃y[WԂB
	 * 
	 * @return y[W
	 * @see java.awt.print.Pageable#getNumberOfPages()
	 */
	public int getNumberOfPages()
	{
		return 1;
	}

	/**
	 * w肳ꂽy[W̃tH[}bgԂB
	 * 
	 * @param pageIndex y[W
	 * @return tH[}bg
	 * @throws java.lang.IndexOutOfBoundsException
	 * @see java.awt.print.Pageable#getPageFormat(int)
	 */
	public PageFormat getPageFormat(int pageIndex)
	throws IndexOutOfBoundsException
	{
		return format;
	}

	/**
	 * w肳ꂽy[Ẅf[^ԂB
	 * 
	 * @param pageIndex y[W
	 * @return f[^
	 * @throws java.lang.IndexOutOfBoundsException
	 * @see java.awt.print.Pageable#getPrintable(int)
	 */
	public Printable getPrintable(int pageIndex)
	throws IndexOutOfBoundsException
	{
		return new FlowPage();
	}
	
	/**
	 * t[C[Wf[^pB
	 */
	class FlowPage implements Printable
	{
		/**
		 * t[C[W`悷B
		 * 
		 * @param	g				y[W`悳ReLXg
		 * @param	format			`悳y[W̃TCYƈ
		 * @param	pageIndex		`悳y[W̃[n܂CfbNX
		 * @return	y[W̕`ɐꍇPAGE_EXISTSA
		 *			pageIndex Ŏw肳ꂽy[W݂ȂꍇNO_SUCH_PAGE
		 * @throws java.awt.print.PrinterException
		 * @see java.awt.print.Printable#print(java.awt.Graphics, java.awt.print.PageFormat, int)
		 */
		public int print(Graphics g, PageFormat format, int pageIndex)
		throws PrinterException
		{
			Dimension psize = view.getPreferredSize();
			boolean needToRotate = false;
			if (psize.width > psize.height) needToRotate = true;

			double xScale = format.getImageableWidth() / psize.width;
			double yScale = format.getImageableHeight() / psize.height;
			if (needToRotate) {
				xScale = format.getImageableHeight() / psize.width;
				yScale = format.getImageableWidth() / psize.height;
			}
			double scale = 1.0;

			if (xScale < yScale) scale = xScale;
			else scale = yScale;

			Graphics2D g2 = (Graphics2D)g;

			AffineTransform tr = g2.getTransform();
			if (needToRotate) {
				g2.translate(0, format.getHeight());
				g2.rotate(Math.toRadians(-90));
			}

			g2.translate(format.getImageableX(), format.getImageableY());
			g2.scale(scale, scale);

			view.paintView(g2);

			g2.setTransform(tr);
			return PAGE_EXISTS;
		}
	}
}
