/* $Id: PrintManager.java,v 1.3 2005/08/26 04:51:20 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2004.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.print;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;

import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;

/**
 * sB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public final class PrintManager
{
	/** }l[W */
	static private PrintManager singleton = null;

	/** v */
	private PrintRequestAttributeSet aset;

	/**
	 * }l[W𐶐B
	 */
	private PrintManager()
	{
		/* v̎w */
		aset = new HashPrintRequestAttributeSet();
		aset.add(OrientationRequested.PORTRAIT);
		aset.add(MediaSizeName.ISO_A4);
		aset.add(new Copies(1));
		aset.add(new JobName("WorkflowDesigner", null));
	}

	/**
	 * }l[WԂB
	 *
	 * @return }l[W
	 */
	static public PrintManager getInstance()
	{
		if (singleton == null) {
			singleton = new PrintManager();
		}

		return singleton;
	}

	/**
	 * ێĂCX^XB
	 */
	static public void releaseInstance()
	{
		singleton = null;
	}

	/**
	 * vԂB
	 * 
	 * @return v
	 */
	public PrintRequestAttributeSet getCurrentPageFormat()
	{
		return aset;
	}

	/**
	 * ĂяoAw肳ꂽΏۂ̈sB
	 *
	 * @param data hLg
	 */
	public void print(PrintData data)
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();
		
		if (data == null) {
			DialogUtilities.showError(rm.getResource("message.error.0001"));
			return;
		}
		/* Wu̍쐬 */
		PrinterJob job = PrinterJob.getPrinterJob();
		job.setPageable(data);

		/* vt\ȈT[rXꗗԂ */
		PrintService[] services = PrinterJob.lookupPrintServices();

		if (services.length > 0) {
			try {
				/* Wuɍŏ̃v^蓖Ă */
				job.setPrintService(services[0]);
				/* y[Wݒ_CAO̕\ */
				PageFormat format = job.pageDialog(aset);
				if (format == null) return;
				data.setFormat(format);
				/* _CAO̕\ */
				if (job.printDialog(aset)) {
					// pl̏IR[h^ȂAs
					job.print(aset);
				}
			} catch (PrinterException ex) {
				DialogUtilities.showError(rm.getResource("message.error.0002"));
			}
		} else {
			DialogUtilities.showError(rm.getResource("message.error.0003"));
		}
	}
}
