/* $Id: SimulatableActivityWrapper.java,v 1.3 2005/08/26 04:50:01 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.util.EmptyStackException;
import java.util.Stack;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;

/**
 * ANeBreBCX^XV~[g邽߂
 * [bp[B
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class SimulatableActivityWrapper
{
	/** ANeBreB */
	private ActivityElement act;
	/** ͑J */
	private TransitionElement tr;
	/** ubNX^bN */
	private Stack blockStack = new Stack();
	
	/**
	 * [bp[𐶐B
	 * 
	 * @param act	ANeBreB
	 * @param tr	͑J
	 */
	public SimulatableActivityWrapper(ActivityElement act, TransitionElement tr)
	{
		this.act = act;
		this.tr = tr;
		if (act.getType().equals(ActivityElement.CONCUR_START)) {
			blockStack.push(this);
		} else if (act.getType().equals(ActivityElement.CONCUR_END)) {
			blockStack.pop();
		}
	}

	/**
	 * [bp[𐶐B
	 * 
	 * @param act	ANeBreB
	 * @param tr	͑J
	 * @param st	ȑÕX^bN
	 */	
	public SimulatableActivityWrapper(ActivityElement act, TransitionElement tr, Stack st)
	{
		this.act = act;
		this.tr = tr;
		if (st != null) blockStack.addAll(st);
		if (act.getType().equals(ActivityElement.CONCUR_START)) {
			blockStack.push(this);
		} else if (act.getType().equals(ActivityElement.CONCUR_END)) {
			blockStack.pop();
		}
	}

	/**
	 * ANeBreBԂB
	 * 
	 * @return	ANeBreB
	 */	
	public ActivityElement getActivity()
	{
		return act;
	}

	/**
	 * JڂԂB
	 * 
	 * @return	J
	 */	
	public TransitionElement getTransition()
	{
		return tr;
	}

	/**
	 * ubNX^bNԂB
	 * 
	 * @return	ubNX^bN
	 */	
	public Stack getBlockStack()
	{
		return blockStack;
	}

	/**
	 * ubNX^bN̍ŏʂ̗vfԂB
	 * 
	 * @return	ubNANeBreBbp[
	 */	
	public SimulatableActivityWrapper peekTopBlockWrapper()
	{
		try {
			return (SimulatableActivityWrapper)blockStack.peek();
		} catch (EmptyStackException ex) {
			return null;
		}
	}

	/**
	 * w肳ꂽubNANeBreBbp[ǂԂB
	 * 
	 * @param wrapper	ubNANeBreBbp[
	 * @return	ꍇɂtrue
	 */	
	public int searchBlockWrapper(SimulatableActivityWrapper wrapper)
	{
		return blockStack.search(wrapper);
	}
}
