/* $Id: SimulatorView.java,v 1.3 2005/08/26 04:50:00 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.Document;

import jp.co.argo21.commons.swing.BooleanDocument;
import jp.co.argo21.commons.swing.ByteLimitedDocument;
import jp.co.argo21.commons.swing.DialogUtilities;
import jp.co.argo21.commons.swing.NumericDocument;
import jp.co.argo21.commons.util.ResourceManager;
import jp.co.argo21.nautica.tool.wfd.IconManager;
import jp.co.argo21.nautica.tool.wfd.IconView;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerConstants;
import jp.co.argo21.nautica.tool.wfd.WorkflowDesignerManager;
import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.expression.ConditionalVariable;

/**
 * V~[^pϐݒp_CAOɕ\r[B
 * 
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class SimulatorView extends JTabbedPane
{
	/** e[u̗ */
	static private String[] columnNames;

	/** g */
	static protected final Border border = BorderFactory.createEtchedBorder();

	/** ACR\GA */
	private IconView iconView;
	/** ID\GA */
	private JLabel idField;
	/** ̕\GA */
	private JLabel nameField;
	/** ϐXV{^ */
	private JRadioButton editVarButton;
	/** O{^ */
	private JRadioButton raiseExButton;
	/** ϐꗗe[u */
	private JTable varTable;
	/** ϐnҏWGA */
	private JTextField varField;
	/** ύX{^ */
	private JButton updateButton;
	
	/** ͐ */
	private Document strDocument = new ByteLimitedDocument(128);
	
	/** l͐ */
	private Document numDocument = new NumericDocument(9, true);
	
	/** ^l͐ */
	private Document boolDocument = new BooleanDocument();
	
	/** ϐꗗ */
	private List vars;
	
	/**
	 * 萔
	 */
	static
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		columnNames = new String[3];
		columnNames[0] = rm.getResource("SimulatorView.columnName.0");
		columnNames[1] = rm.getResource("SimulatorView.columnName.1");
	}
	
	/**
	 * r[𐶐B
	 */
	public SimulatorView()
	{
		ResourceManager rm = WorkflowDesignerManager.getResourceManager();

		JPanel panel = createEditorPanel(rm);
		addTab(rm.getResource("SimulatorView.tab.0"), panel);

		validate();
	}
	
	/**
	 * GfB^̃pl𐶐B
	 * 
	 * @param rm \[X}l[W
	 * @return pl
	 */
	private JPanel createEditorPanel(ResourceManager rm)
	{
		JPanel panel = new JPanel();
		panel.setLayout(null);
		panel.setBorder(border);
		Dimension size = new Dimension(380, 265);
		panel.setSize(size);
		panel.setPreferredSize(size);
		JLabel l0 = new JLabel(rm.getResource("SimulatorView.label.0"));
		JLabel l1 = new JLabel(rm.getResource("SimulatorView.label.1"));

		iconView = new IconView();
		idField = new JLabel();
		idField.setBorder(border);
		nameField = new JLabel();
		nameField.setBorder(border);

		editVarButton = new JRadioButton(rm.getResource("SimulatorView.operate.0"));
		editVarButton.addActionListener(new SelectEditVarAction());
		raiseExButton = new JRadioButton(rm.getResource("SimulatorView.operate.1"));
		raiseExButton.addActionListener(new SelectRaiseExceptionAction());

		JPanel opePane = new JPanel();
		opePane.setLayout(new GridLayout(1, 3, 5, 5));
		opePane.setBorder(border);
		opePane.add(editVarButton);
		opePane.add(raiseExButton);

		ButtonGroup opeGroup = new ButtonGroup();
		opeGroup.add(editVarButton);
		opeGroup.add(raiseExButton);

		varTable = new JTable(new VarTableModel());
		varTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		varTable.setRowHeight(35);
		varTable.getColumnModel().getColumn(0).setCellRenderer(new VarRenderer());
		ListSelectionModel vlsm = varTable.getSelectionModel();
		vlsm.addListSelectionListener(new VarSelectAction());
		JScrollPane sp0 = new JScrollPane();
		sp0.setViewportView(varTable);
		
		varField = new JTextField();
		varField.setDocument(strDocument);

		updateButton = new JButton(rm.getResource("JButton.label.update"));
		updateButton.addActionListener(new UpdateVarAction());

		panel.add(locate(iconView,      10,  10,  60,  60));
		panel.add(locate(l0,            80,  10, 100,  25));
		panel.add(locate(l1,            80,  40, 100,  25));
		panel.add(locate(idField,      180,  10, 190,  25));
		panel.add(locate(nameField,    180,  40, 190,  25));
		panel.add(locate(opePane,       10,  80, 360,  35));
		panel.add(locate(sp0,           10, 120, 360, 105));
		panel.add(locate(varField,      10, 230, 270,  25));
		panel.add(locate(updateButton, 290, 230,  80,  25));

		validate();

		return panel;
	}

	/**
	 * ϐ̕ҏWۂݒ肷B
	 * 
	 * @param b	ҏW
	 */	
	private void setVarEditable(boolean b)
	{
		varTable.clearSelection();
		varField.setText("");
		varTable.setEnabled(b);
		varField.setEditable(b);
		updateButton.setEnabled(b);
	}

	/**
	 * OIԂB
	 * 
	 * @return	Iꍇtrue
	 */
	public boolean isExceptionRaising()
	{
		return raiseExButton.isSelected();
	}

	/**
	 * ݂̕ϐꗗԂB
	 * 
	 * @return	ϐꗗ
	 */
	public List getCurrentVariables()
	{
		return vars;
	}

	/**
	 * ݂̃ANeBreBݒ肷B
	 * 
	 * @param act	ANeBreB
	 */
	public void setCurrentActivity(ActivityElement act)
	{
		iconView.setIconName(act.getActivityState().getIconName());
		idField.setText(act.getID());
		nameField.setText(act.getName());
	}

	/**
	 * ϐꗗݒ肷B
	 * 
	 * @param vars	ϐꗗ
	 */
	public void setCurrentVariables(List vars)
	{
		this.vars = vars;
	}

	/**
	 * l̕ҏWۂݒ肷B
	 * 
	 * @param b	ҏW
	 */	
	void setValueEditable(boolean b)
	{
		editVarButton.setEnabled(b);
		raiseExButton.setEnabled(b);
		varTable.setEnabled(b);
		varField.setEditable(b);
		updateButton.setEnabled(b);
		varField.setText("");
	}

	/**
	 * r[B
	 */
	void init()
	{
		editVarButton.setSelected(true);
		setVarEditable(true);
	}

	/**
	 * ݒl`FbNB
	 * 
	 * @return	
	 */	
	public boolean check()
	{
		return true;
	}
	
	/**
	 * ݒlm肷B
	 */
	public void commit()
	{
	}

	/**
	 * w肳ꂽR|[lg̑w̑傫ƍWōXVB
	 * 
	 * @param component ΏۃR|[lg
	 * @param x XW
	 * @param y YW
	 * @param w 
	 * @param h 
	 * @return ύXꂽR|[lg
	 */
	protected Component locate(Component component, int x, int y, int w, int h)
	{
		component.setLocation(x, y);
		component.setSize(w, h);
		return  component;
	}
	
	/**
	 * ϐҏWIꍇ̏B
	 */	
	class SelectEditVarAction extends AbstractAction
	{
		/**
		 * ϐҏW\ɂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setVarEditable(true);
		}
	}
	
	/**
	 * OIꍇ̏
	 */	
	class SelectRaiseExceptionAction extends AbstractAction
	{
		/**
		 * ϐҏWsɂB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			setVarEditable(false);
		}
	}
	
	/**
	 * XVB
	 */	
	class UpdateVarAction extends AbstractAction
	{
		/**
		 * XVB
		 * 
		 * @param e	Cxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */
		public void actionPerformed(ActionEvent e)
		{
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();
			int selected = varTable.getSelectedRow();
			if (selected < 0) {
				DialogUtilities.showWarning(rm.getResource("message.warn.0006"));
				return;
			}
			ConditionalVariable var = (ConditionalVariable)vars.get(selected);
			var.setValue(varField.getText());
			varTable.updateUI();
		}
	}

	/**
	 * ϐXgȈB
	 */	
	class VarSelectAction implements ListSelectionListener
	{
		/**
		 * ϐ̌^ɉē̓GA؂ւB
		 * 
		 * @param e	Cxg
		 * @see javax.swing.event.ListSelectionListener#valueChanged(javax.swing.event.ListSelectionEvent)
		 */
		public void valueChanged(ListSelectionEvent e)
		{
			if (e.getValueIsAdjusting()) return;

			ListSelectionModel lsm = (ListSelectionModel)e.getSource();
			if (lsm.isSelectionEmpty() == false) {
				int selected = lsm.getMinSelectionIndex();
				ConditionalVariable var = (ConditionalVariable)vars.get(selected);
				String v = var.getValue();
				int type = var.getType();
				if (v == null) varField.setText("");
				else varField.setText(v);
				if (type == ConditionalVariable.INTEGER) {
					varField.setDocument(numDocument);
					varField.setHorizontalAlignment(SwingUtilities.RIGHT);
				} else if (type == ConditionalVariable.BOOLEAN) {
					varField.setDocument(boolDocument);
					varField.setHorizontalAlignment(SwingUtilities.LEFT);
				} else {
					varField.setDocument(strDocument);
					varField.setHorizontalAlignment(SwingUtilities.LEFT);
				}
			}
		}
	}

	/**
	 * vZXϐe[u䃂f
	 */
	class VarTableModel extends AbstractTableModel
	{
		/**
		 * vZXϐ䃂f𐶐B
		 */
		VarTableModel()
		{
			vars = WorkflowDesignerManager.getMainFrame().getPackage().getVariables();
		}

		/**
		 * f[^\[XIuWFNgǗ񐔂ԂB
		 * JTable͂̃\bhgāAɍ쐬ѕ\
		 * Kv̂񐔂𔻒fB
		 *
		 * @return	f̗
		 */
		public int getColumnCount()
		{
			return 2;
		}

		/**
		 * f[^\[XIuWFNgǗ郌R[hԂB
		 * JTable͂̃\bhgāA쐬ѕ\Kv̂s𔻒fB
		 *
		 * @return	f̍s
		 */
		public int getRowCount()
		{
			return vars.size();
		}

		/**
		 * colɂ̖OԂB
		 * ̃\bh́Ae[u̗wb_邽߂ɎgB
		 *
		 * @param	col		̃CfbNX
		 * @return	wb_
		 */
		public String getColumnName(int col)
		{
			return columnNames[col];
		}

		/**
		 * J̒lԂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	w肳ꂽZɂl
		 */
		public Object getValueAt(int row, int col)
		{
			ConditionalVariable var = (ConditionalVariable)vars.get(row);
			if (col == 0) return var;
			else return var.getValue();
		}

		/**
		 * ClassԂB
		 *
		 * @param	col		
		 * @return	f̃IuWFNgl̋ʂ̏ʃNX
		 */
		public Class getColumnClass(int col)
		{
			if (col == 0) return ConditionalVariable.class;
			else return String.class;
		}

		/**
		 * rowcolɂZҏW\ȏꍇtrueԂB
		 * łȂꍇAZsetValueAt()ĂяoĂÃZ̒l͕ύXȂB
		 *
		 * @param	row		lQƂs
		 * @param	col		lQƂ
		 * @return	ZҏW\ȏꍇtrue
		 */
		public boolean isCellEditable(int row, int col)
		{
			return false;
		}
	}

	/**
	 * ϐe[up̃_[
	 */	
	public class VarRenderer extends DefaultTableCellRenderer
	{
		/** ACR */
		private Icon icon;
		
		/**
		 * _[𐶐B
		 */
		VarRenderer()
		{
			String name = WorkflowDesignerConstants.EL_VARIABLE + "-cur";
			icon = IconManager.getIcon(name);
		}

		/**
		 * _O
		 * 
		 * @param table	e[u
		 * @param o	Ze
		 * @param isSelected	I
		 * @param hasFocus	tH[JX
		 * @param row	s
		 * @param column	
		 * @return	_O
		 * @see javax.swing.table.TableCellRenderer#getTableCellRendererComponent(javax.swing.JTable, java.lang.Object, boolean, boolean, int, int)
		 */		
		public Component getTableCellRendererComponent(
		JTable table,
		Object o,
		boolean isSelected,
		boolean hasFocus,
		int row,
		int column)
		{
			super.getTableCellRendererComponent(table, o, isSelected, hasFocus, row, column);
			ResourceManager rm = WorkflowDesignerManager.getResourceManager();

			ConditionalVariable var = (ConditionalVariable)o;
			setText(var.getName());

			if (icon != null) setIcon(icon);
			setToolTipText(var.getTooltipText(rm));
			return this;
		}
	}
}
