/* $Id: SimurateManager.java,v 1.3 2005/08/26 04:50:01 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.sim;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.Timer;

import jp.co.argo21.nautica.tool.wfd.element.ActivityElement;
import jp.co.argo21.nautica.tool.wfd.element.ProcessElement;
import jp.co.argo21.nautica.tool.wfd.element.TransitionElement;
import jp.co.argo21.nautica.tool.wfd.expression.Expression;

/**
 * t[V~[V𐧌䂷}l[WB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class SimurateManager
{
	/** V~[gĕ`܂ł̑҂ */
	static private final int TIMER_DELAY = 1000; /* (ms) */

	/** V~[ViWƂ\tO */
	static private final int SIMULATION_PROGRESSED = 1;
	/** V~[VƂ\tO */
	static private final int SIMULATION_FINISHED   = 2;
	/** V~[VrŒfƂ\tO */
	static private final int SIMULATION_TERMINATED = 3;
	
	/** V~[Vp̕ϐݒ_CAO */
	private SimulatorDialog dialog;
	/** V~[g󋵂󂯎郊Xi[ */
	private SimulationListener listener;
	/** V~[gΏۂ̃vZXvf */
	private ProcessElement proc;
	/** V~[gΏۂ̋[ANeBreBCX^Xbp[ */
	private SimulatableActivityWrapper wrapper;

	/**
	 * V~[^𐶐B
	 */
	public SimurateManager()
	{
		dialog = new SimulatorDialog();
	}
	
	/**
	 * V~[gJnB
	 * 
	 * @param l	Xi[
	 * @param vars	vZXϐ
	 * @param proc	ΏۃvZX
	 * @param act	JnANeBreBbp[
	 */
	public void start(
	SimulationListener l,
	List vars,
	ProcessElement proc,
	SimulatableActivityWrapper act)
	{
		this.listener = l;
		this.proc = proc;
		this.wrapper = act;
		dialog.setCurrentActivity(act.getActivity());
		dialog.setCurrentVariables(vars);

		if (listener != null) listener.simulationStarted(act);
		
		simulate();
	}

	/**
	 * PXebvV~[gB
	 * 
	 * @param act
	 */	
	public void simulate(SimulatableActivityWrapper act)
	{
		this.wrapper = act;
		dialog.setCurrentActivity(act.getActivity());
		
		simulate();
	}

	/**
	 * V~[gB
	 */
	private void simulate()
	{
		if (wrapper.getActivity().getType().equals(ActivityElement.CONCUR_START)
			|| wrapper.getActivity().getType().equals(ActivityElement.CONCUR_END)
		|| wrapper.getActivity().getType().equals(ActivityElement.END)) {
			dialog.setValueEditable(false);
		} else {
			dialog.setValueEditable(true);
		}

		dialog.setVisible(true);

		if (dialog.getResult() == SimulatorDialog.EVAL_OPTION) {
			SimulateAction action = null;
			if (wrapper.getActivity().getType().equals(ActivityElement.END)) {
				action = new SimulateAction(SIMULATION_FINISHED);
			} else {
				List vars = dialog.getCurrentVariables();
				boolean isExRaising = dialog.isExceptionRaising();
				List trs = evaluate(vars, isExRaising);

				if (trs.size() == 0) {
					action = new SimulateAction(SIMULATION_TERMINATED);
					action.setSimulatedActivity(wrapper);
				} else {
					action = new SimulateAction(SIMULATION_PROGRESSED);
					action.setSimulatedTransitions(trs);
				}
			}

			Timer timer = new Timer(TIMER_DELAY, action);
			timer.setRepeats(false);
			timer.start();
		}
	}

	/**
	 * ̔sB
	 * 
	 * @param vars	vZXϐ
	 * @param isExRaising	O
	 * @return	V~[gʑIꂽJ
	 */
	private List evaluate(List vars, boolean isExRaising)
	{
		List result = new ArrayList();
		List otherwises = new ArrayList();
		boolean isConcurrent = false;
		if (wrapper.getActivity().getType().equals(ActivityElement.CONCUR_START)) {
			isConcurrent = true;
		}

		Iterator tit = proc.getTransitions().iterator();
		while (tit.hasNext()) {
			TransitionElement tr = (TransitionElement)tit.next();
			if (wrapper.getActivity() != tr.getSource()) continue;

			Expression exp = tr.getCondition();
			int type = tr.getType();
			
			if (type == TransitionElement.EXCEPTION) {
				if (isExRaising) {
					result.add(tr);
					if (isConcurrent == false) break;
				}
			} else if (type == TransitionElement.OTHERWISE) {
				otherwises.add(tr);
			} else {
				if (exp == null) {
					//Ȃꍇ͖JڂƂ݂ȂB
					result.add(tr);
					if (isConcurrent == false) break;
				} else {
					if (exp.eval(vars)) {
						result.add(tr);
						if (isConcurrent == false) break;
					}
				}
			}
		}

		//֑Jڂ̔
		if (result.size() == 0) {
			if (otherwises.size() > 0) {
				if (isConcurrent) {
					result = otherwises;
				} else {
					result.add(otherwises.get(0));
				}
			}
		}

		return result;
	}
	
	/**
	 * V~[^Aj[V邽߂̃^C}[ANV
	 */	
	class SimulateAction extends AbstractAction
	{
		/** V~[g */
		private int state;
		/** ΏۃANeBreBbp[ */
		private SimulatableActivityWrapper simact;
		/** ʑJ */
		private List simtrs;

		/**
		 * ANV𐶐B
		 * 
		 * @param s	
		 */		
		SimulateAction(int s)
		{
			this.state = s;
		}

		/**
		 * ԂɉANVsB
		 * 
		 * @param e	ANVCxg
		 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
		 */		
		public void actionPerformed(ActionEvent e)
		{
			if (state == SIMULATION_PROGRESSED) {
				fireSimulationProgressed();
			} else if (state == SIMULATION_FINISHED) {
				fireSimulationFinished();
			} else if (state == SIMULATION_TERMINATED) {
				fireSimulationTerminated();
			}
		}

		/**
		 * V~[gΏۂ̃ANeBreBbp[ݒ肷B
		 * 
		 * @param a	ANeBreBbp[
		 */		
		void setSimulatedActivity(SimulatableActivityWrapper a)
		{
			this.simact = a;
		}
	
		/**
		 * ʑJڂݒ肷B
		 * 
		 * @param trs	ʑJ
		 */		
		void setSimulatedTransitions(List trs)
		{
			this.simtrs = trs;
		}

		/**
		 * V~[g̐iWʒmB
		 */
		private void fireSimulationProgressed()
		{
			if (listener != null) listener.simulationProgressed(wrapper, simtrs);
		}

		/**
		 * V~[g̊ʒmB
		 */
		private void fireSimulationFinished()
		{
			if (listener != null) listener.simulationFinished(simact);
		}

		/**
		 * V~[g̒fʒmB
		 */
		private void fireSimulationTerminated()
		{
			if (listener != null) listener.simulationTerminated(simact);
		}
	}
}
