/* $Id: XPDLFileFilter.java,v 1.3 2005/08/26 04:51:20 ysahara Exp $
 * 
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.tool.wfd.xpdl;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * [Nt[`f[^`łXPDLt@CJFileChooser
 * I邽߂̃tB^łB
 * 
 * @author  Norihiro Itoh(ARGO 21 Corp.)
 * @version $Revision: 1.3 $
 * @since   Nautica Workflow 0.9
 */
public class XPDLFileFilter extends FileFilter
{
	/** tB^Ώۂ̊gq */
	static public final String EXTENSION = "xpdl";
	/**  */
	private String description;

	/**
	 * XPDLIp̃tB^[`B
	 * 
	 * @param desc 
	 */
	public XPDLFileFilter(String desc)
	{
		description = desc;
	}
	
	/**
	 * w肳ꂽt@C󂯓邩ǂ𔻒肷B
	 *
	 * @param file t@C
	 * @return 茋
	 */
	public boolean accept(File file)
	{
		if (file.isDirectory()) return true;

		String fileName = file.getName();
		int periodIndex = fileName.lastIndexOf('.');

		boolean accepted = false;

		if ((periodIndex > 0) && (periodIndex < (fileName.length() - 1))) {
			String extension = fileName.substring(periodIndex + 1).toLowerCase();
			if (extension.equals(EXTENSION)) accepted = true;
		}
		return accepted;
	}

	/**
	 * tB^̐ԂB
	 *
	 * @return 
	 */
	public String getDescription()
	{
		return description;
	}
}
