/* $Id: ChangeWorkItemStateServlet.java,v 1.6 2005/08/26 04:48:28 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.servlet;

import java.io.IOException;
import java.rmi.RemoteException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.argo21.nautica.workflow.rmi.WorkItemHandlerRemote;
import jp.co.argo21.nautica.workflow.util.StringManager;
import jp.co.argo21.nautica.workflow.wfmc.InvalidSessionException;
import jp.co.argo21.nautica.workflow.wfmc.WorkItemState;

import org.apache.log4j.Logger;

/**
 * ƍڏԂ̕ύXsT[ubgłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.6 $
 * @since   Nautica Workflow 0.9
 */
public class ChangeWorkItemStateServlet extends HttpServlet {

	/** Oo͗pIuWFNg */
	private static Logger log = Logger.getLogger(
			GetWorkItemsServlet.class);
	
	/**
	 * GET vB<br>
	 * SĂ̏ doPost ɈϏB
	 * 
	 * @param req HttpServletRequest IuWFNg
	 * @param res HttpServletResponse IuWFNg
	 * @throws ServletException vłȂꍇ
	 * @throws IOException o̓G[oꂽꍇ
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void doGet(HttpServletRequest req, HttpServletResponse res)
		throws ServletException,IOException {
		this.doPost(req, res);
	}

	/**
	 * POST vB<br>
	 * [Nt[GWɐڑėvɊւ鏈sB
	 *
	 * @param req HttpServletRequest IuWFNg
	 * @param res HttpServletResponse IuWFNg
	 * @throws ServletException vłȂꍇ
	 * @throws IOException o̓G[oꂽꍇ
	 * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
	 */
	protected void doPost(HttpServletRequest req, HttpServletResponse res)
		throws ServletException,IOException {
		
		// HttpServletRequest GWJC^tF[Ẍ擾
		String session = NWFRequestUtil.getSession(req);
		String wid = NWFRequestUtil.getWorkItemID(req);
		WorkItemState state = NWFRequestUtil.getWorkItemState(req);
		
		// Oo
		String I4001 = StringManager.get("I4001")
			+ "(SessionID=" + session 
			+ ", WorkItemID=" + wid 
			+ ", WorkItemState=" + state + ")";
		log.info(I4001);
		
		// GWƂ̃[gʐM
		try {
			WorkItemHandlerRemote wih 
				= WorkflowRemoteServiceAccessor.getWorkItemHandlerRemote(session);
			wih.changeWorkItemState(session, wid, state);
			
		} catch (RemoteException ex) {
			String errMsg = StringManager.get("E4004");
			log.error(errMsg);
			throw new ServletException(errMsg);
		
		} catch (InvalidSessionException ex) {
			// WorkflowRemoteServiceAccessor NXŃOo͍ς
			throw new ServletException(ex);
		
		} catch (Exception ex) {
			String errMsg = StringManager.get("E4006");
			log.error(errMsg);
			throw new ServletException(errMsg, ex);
		}
		
		// Oo
		String I4002 = StringManager.get("I4002");
		log.info(I4002);
	}
}
