/* $Id: InitializeServlet.java,v 1.5 2005/08/26 04:48:13 ysahara Exp $
 *
 * Copyright (c)ARGO 21, Corporation. 2005.  All rights reserved.
 * 
 * This file is part of Nautica Workflow.
 * 
 *  Nautica Workflow is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Nautica Workflow is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Nautica Workflow; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *  
 */
package jp.co.argo21.nautica.workflow.servlet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import jp.co.argo21.nautica.workflow.client.WorkflowServiceAccessorManager;
import jp.co.argo21.nautica.workflow.omg.WorkflowException;

import org.apache.log4j.Logger;

/**
 * ʐMC^tF[XT[ubgNXłB
 *
 * @author  ysahara(Argo 21, Corp.)
 * @version $Revision: 1.5 $
 * @since   Nautica Workflow 0.9
 */
public class InitializeServlet extends HttpServlet {

	/**
	 * T[ubgT[rXJnłԂɂȂۂɁAT[ubgRei
	 * ɂČĂяoB
	 * AvP[VN̏łB
	 *
	 * @throws ServletException Axis AvP[VNɉ炩̗Oꍇ
	 * @see javax.servlet.GenericServlet#init()
	 */
	public void init() throws ServletException {
		// Logger 񋟂 LogManager B
		LogManager.create(this.getServletContext());
		Logger log = Logger.getLogger(this.getClass());
		
		try {
			WorkflowServletConfig.create(this.getServletContext());
			// VOgIuWFNgォNAȂ悤
			// ServletContext ɕۊ
			this.getServletContext().setAttribute(
					"NWF_APPLICATION_CONFIG", 
					WorkflowServletConfig.getInstance());
			this.getServletContext().setAttribute(
					"NWF_SERVICE_ACCESSOR_MANAGER", 
					WorkflowServiceAccessorManager.getInstance());
			
		} catch (WorkflowException ex) {
			throw new ServletException(ex);
		}
	}
}
